#include "dns.h"

int dns_name4(const ipv4addr* ip, str* name)
{
  str tmp = {0,0,0};
  str packet = {0,0,0};
  str nametmp = {0,0,0};
  int result;
  str_catu(&tmp, ip->addr[3]);
  str_catc(&tmp, '.');
  str_catu(&tmp, ip->addr[2]);
  str_catc(&tmp, '.');
  str_catu(&tmp, ip->addr[1]);
  str_catc(&tmp, '.');
  str_catu(&tmp, ip->addr[0]);
  str_cats(&tmp, ".in-addr.arpa");
  if ((result = dns_query_fqdn(tmp.s, DNS_TYPE_PTR, &packet)) > 0) {
    tmp.len = 0;
    if (dns_packet_get(&packet, &tmp, DNS_TYPE_PTR)) {
      if (tmp.len > 3) {
	unsigned len = uint16_get_msb(tmp.s);
	if (tmp.len >= len + 2) {
	  name->len = 0;
	  if (dns_uncompress_name(tmp.s+2, len, &packet, &nametmp) &&
	      dns_name_to_dots(nametmp.s, nametmp.len, name))
	    result = 1;
	}
      }
    }
  }
  str_free(&nametmp);
  str_free(&packet);
  str_free(&tmp);
  return result;
}
