---
layout: post
permalink: /blog/the-road-to-1-0/
title: The Road to 1.0
---

Quill launched with the ambitious goal of becoming *the* rich text editor for the web, being both easy to use for drop in use cases, and powerful enough for complex ones. Its current [API](/docs/api/) is core to those goals.

In the past months, much effort has been placed into providing even greater means for customization, particularly the editor's contents. With this nearing completion, Quill is approaching its 1.0 coming of age.


### Parchment

A full introduction and guide to Parchment is still forthcoming, but in short it is a new document model for Quill. An editor's document model is an important abstraction over the DOM that allows the editor and API users to reason about its contents through a much simpler yet more expressive interface than directly interacting with the browser. For Quill, this enables an elegant solution to the longstanding problem of format customization.

<!-- more -->

Prior to Parchment, Quill required near complete control over its editor container and descendant DOM nodes in order to provide its precise retrieval and manipulation API. Even simple modifications such as changing the default link open behavior required hacks and defining new content types, such as syntax highlighted code, was impossible.

Parchment hands control of entire subtrees back to the user, allowing the definition of new nodes or overwriting existing ones. The requirement is that certain methods such as `getValue` and `getFormat` be defined in order to happily exist within a Parchment document. Those familiar will find this very similar to `render` and Components in [React](https://facebook.github.io/react/), a significant influencer of Parchment's design.

While the Parchment interface is still being stabilized, a preview of a definition for a [KaTeX](https://github.com/Khan/KaTeX) equation looks like this (with ES6 syntax):

```javascript
class Equation extends Parchment.Embed {
  constructor(value) {
    super(value);
    this.value = value;
    this.domNode.setAttribute('contenteditable', false);
    katex.render(value, this.domNode);
  }

  getValue() {
    return this.value;
  }
}

Quill.registerFormat(Equation);
```

The current priority is to integrate Parchment into Quill as its new document model. However, Parchment is and will remain organized as its own [repository](https://github.com/quilljs/parchment), as it was designed as a general purpose tool. Hopefully one day it may serve as the document model for other editors as well.


### Formats

Parchment opens the doors to scalably support many more formats, many of which will be included in the 1.0 release. The complete list is not ready for announcement but they will at least include semantic headers and nested lists. Equations and syntax highlighted code will also be added as separate repositories because of their likely dependency on external libraries.


### Modules

Quill organizes most of its source code as modules to make it easy to overwrite their default behavior. Unfortunately a documentation gap currently exists for these modules--this will have to be filled for their extensibility to be realized.

Some non-essential modules will also be moved out into their own repositories. Custom builds are planned to conveniently include or exclude these modules, along with other permutations, though this may land post 1.0 depending on timing.


### Beyond 1.0

With Quill 1.0, the main foundations will be complete and much more emphasis will be placed into building examples and enhancing support, with internationalization, accessibility, and cross application interactions (copy/paste) as main focus points.

In addition, Quill's UI is due for an upgrade. While the aesthetics of Quill is already completely customizable, more numerous defaults could be available for those wanting a drop in solution. Here's a sneak peak at a couple of upcoming themes in the works:

<p>
  <img class="road-1-theme-preview" src="/assets/images/blog/theme-1.png" alt="Quill Theme 1">
  <img class="road-1-theme-preview" src="/assets/images/blog/theme-2.png" alt="Quill Theme 2">
</p>

Finally, the community deserves a great thank you for all of your contributions and support! All the [bug reports](https://github.com/quilljs/quill/labels/bug), [features suggestions](https://github.com/quilljs/quill/labels/feature) and [pull requests](https://github.com/quilljs/quill/pulls?q=is%3Apr) make Quill what it is today. Keep these coming! Exciting times are ahead for web editing and for Quill.
