/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_DIALOGFINDNOTE_H
#define INCLUDED_DIALOGFINDNOTE_H


#include <gtk/gtk.h>
#include "configuration.h"
#include "session.h"


class FindNoteDialog
{
public:
  FindNoteDialog (Configuration* configuration, Session * session);
  virtual ~FindNoteDialog ();
  virtual int run ();
  vector<gint32> ids;
protected:
private:
  GtkWidget *findnotedialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox2;
  GtkWidget *label5;
  GtkWidget *entry1;
  GtkWidget *checkbutton_case;
  GtkWidget *dialog_action_area1;
  GtkWidget *buttonfind;
  GtkWidget *buttoncancel;
  Configuration* myconfiguration;
  Session * mysession;
  static void findnotedialog_on_buttonfind_clicked (GtkButton * button, gpointer user_data);
  void on_buttonfind_clicked ();
  vector<ustring> references;
  vector<int> dates;
  static void on_word_entry_changed (GtkEditable * editable, gpointer user_data);
  void set_gui ();  
};


#endif
