/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_FONTUTILS_H
#define INCLUDED_FONTUTILS_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>
#include "configuration.h"
#include "progress.h"


enum FontVariant {fvRegular, fvItalic, fvBold, fvBoldItalic};
#define DISABLED_FONTS_BELOW "˅˅˅ Disabled Fonts Below ˅˅˅"


bool font_get_afm_file (ustring& file);
vector<ustring> font_list_families ();
void font_get_for_xep (vector<ustring>& family, vector<ustring>& path, 
                       vector<ustring>& metrics, vector<FontVariant>& variant);
vector<ustring> font_print_get_families (Configuration * configuration, bool full);
void font_print_set_families (Configuration * configuration, const vector<ustring>& fonts);


#endif
