/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "pdfviewer.h"
#include <gtk/gtk.h>
#include "gtkwrappers.h"
#include "unixwrappers.h"
#include "shell.h"
#include "uname.h"
#include "windowsoutpost.h"


#define NUMBER_OF_VIEWERS 7


ustring pdf_binary (int index, bool full)
{
  // Returns a command to be executed to view pdf files.
  // Variabele "index" selects which viewer will be used.
  // When "full", additional switches, appropriate for that viewer, are added.
  ustring command;
  switch (index) {
    case 0:
      {
        command = "xpdf";
        if (full)
          command.append (" -paper match");
        break;
      }
    case 1:
      {
        command = "acroread";
        break;
      }
    case 2:
      {
        command = "ghostview";
        break;
      }
    case 3:
      {
        command = "gpdf";
        break;
      }
    case 4:
      {
        command = "kpdf";
        break;
      }
    case 5:
      {
        command = "kghostview";
        break;
      }
    case 6:
      {
        command = "open";
        break;
      }
      // Note: when adding new browsers, ensure that the variabele
      // NUMBER_OF_VIEWERS is updated too.
  }
  return command;
}


void pdfviewer (const ustring& filename)
{
  // Handle Windows.
  if (uname_get () == untCygwin) {
    windowsoutpost_open_url (filename_modify_if_cygwin (filename));
    return; 
  }
  // Handle Unix.
  for (unsigned int i = 0; i < NUMBER_OF_VIEWERS; i++)
  {
    if (unix_which (pdf_binary (i, false))) {
      ustring command = pdf_binary (i, true);
      command.append (shell_quote_space (filename));
      command.append ("> /dev/null &");
      system (command.c_str ());
      return;
    }
  }
  // If we're here, it shows that no suitable viewer was found.
  // Inform the user about it, and what to do to solve it.
  ustring message;
  message =
    "The file cannot be displayed, because there is no suitable pdf viewer installed.\n";
  message.append ("Install one of the following supported pdf viewers:\n");
  for (unsigned int i = 0; i < NUMBER_OF_VIEWERS; i++) {
    message.append (pdf_binary (i, false));
    message.append ("\n");
  }
  gtkw_dialog_error (NULL, message);
}
