/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "scripture_reordered.h"



ScriptureReordered::ScriptureReordered (const Scripture& scripture, const Project& project)
// This object encapsulates a reordered Scripture.
{
  for (unsigned int i = 0; i < project.reordered_books.size(); i++) {
    for (unsigned int i2 = 0; i2 < scripture.books.size(); i2++) {
      if (project.reordered_books[i] == scripture.books[i2]) {
        if (project.reordered_includes[i]) {
          books.push_back (project.reordered_books[i]);
          paths.push_back (scripture.paths[i2]);
          portions.push_back (project.reordered_portions[i]);
        }
      }
    }
  }  
}


ScriptureReordered::~ScriptureReordered ()
{
}
