/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_STYLE_H
#define INCLUDED_STYLE_H


#include "libraries.h"
#include "configuration.h"


enum StyleType {
  stIdentifier, stComment, stRunningHeader, stStartsParagraph, stInlineText, 
  stChapterNumber, stVerseNumber, stFootEndNote, stCrossreference
};
enum FootEndNoteType {
  fentFootnote, fentEndnote, fentStandardContent, fentContent, fentContentWithEndmarker, fentParagraph
};
enum CrossreferenceType {
  ctCrossreference, ctStandardContent, ctContent, ctContentWithEndmarker
};
enum NoteNumberingType {
  nntNumerical, nntAlphabetical, nntUserDefined
};
enum NoteNumberingRestartType {
  nnrtNever, nnrtBook, nnrtChapter, nnrtPage
};
enum ParagraphType {
  ptMainTitle, ptSubTitle, ptSectionHeading, ptNormalParagraph
};

                
#define STYLE_BIBLEDIT_STYLE        "bibledit-style"
#define STYLE_NAME                  "name"
#define STYLE_DESCRIPTION           "description"
#define STYLE_FONTSIZE              "fontsize"
#define STYLE_FONTPERCENTAGE        "fontpercentage"
#define STYLE_ITALIC                "italic"
#define STYLE_BOLD                  "bold"
#define STYLE_UNDERLINE             "underline"
#define STYLE_SMALL_CAPS            "small-caps"
#define STYLE_SUPERSCRIPT           "superscript"
#define STYLE_JUSTIFICATION         "justification"
#define STYLE_SPACE_BEFORE          "space-before"
#define STYLE_SPACE_AFTER           "space-after"
#define STYLE_MARGIN_LEFT           "margin-left"
#define STYLE_MARGIN_RIGHT          "margin-right"
#define STYLE_INDENT_FIRSTLINE      "indent-firstline"
#define STYLE_COLUMNS_SPAN          "columns-span"
#define STYLE_STYLE_TYPE            "style-type"
#define STYLE_TYPE_IDENTIFIER       "identifier"
#define STYLE_TYPE_COMMENT          "comment"
#define STYLE_TYPE_RUNNING_HEADER   "running-header"
#define STYLE_TYPE_STARTS_PARAGRAPH "starts-paragraph"
#define STYLE_TYPE_INLINE_TEXT      "inline-text"
#define STYLE_TYPE_CHAPTER_NUMBER   "chapter-number"
#define STYLE_TYPE_VERSE_NUMBER     "verse-number"
#define STYLE_TYPE_FOOT_END_NOTE    "foot-end-note"
#define STYLE_TYPE_CROSSREFERENCE   "crossreference"
#define STYLE_SUBTYPE               "subtype"
#define STYLE_USER_BOOL1             "user-boolean-1"
#define STYLE_USER_BOOL2             "user-boolean-2"
#define STYLE_USER_BOOL3             "user-boolean-3"
#define STYLE_USER_INT1              "user-integer-1"
#define STYLE_USER_INT2              "user-integer-2"
#define STYLE_USER_INT3              "user-integer-3"
#define STYLE_USER_STRING1           "user-string-1"
#define STYLE_USER_STRING2           "user-string-2"
#define STYLE_USER_STRING3           "user-string-3"



class Style
// Manages settings for one style.
{
public:
  Style (const ustring& stylesheet, const ustring& style, bool write);
  virtual ~Style ();
  ustring marker;
  ustring name;
  ustring info;
  double fontsize;
  int fontpercentage;
  ustring italic;
  ustring bold;
  ustring underline;
  ustring smallcaps;
  bool superscript;
  ustring justification;
  double spacebefore;
  double spaceafter;
  double leftmargin;
  double rightmargin;
  double firstlineindent;
  bool spancolumns;
  StyleType type;
  int subtype;
  bool userbool1;
  bool userbool2;
  bool userbool3;
  int userint1;
  int userint2;
  int userint3;
  ustring userstring1;
  ustring userstring2;
  ustring userstring3;
  void import_it (const ustring& filename);
  void export_it (const ustring& filename);
private:
  ustring mystylesheet;
  bool mywrite;
  ustring current_element;
  ustring current_value;
  static void start_element_handler  (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      const gchar        **attribute_names,
                                      const gchar        **attribute_values,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void start_element_handler (const ustring& element_name);
  static void end_element_handler    (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void end_element_handler   (const ustring& element_name);
  static void text_handler           (GMarkupParseContext *context,
                                      const gchar         *text,
                                      gsize                text_len,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void text_handler          (const ustring& text);
  static void passthrough_handler    (GMarkupParseContext *context,
                                      const gchar         *passthrough_text,
                                      gsize                text_len,
                                      gpointer             user_data,
                                      GError             **error);
  static void error_handler          (GMarkupParseContext *context,
                                      GError              *error,
                                      gpointer             user_data);

};


#endif
