/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_DIALOGCHAPTERNUMBER_H
#define INCLUDED_DIALOGCHAPTERNUMBER_H


#include "utilities.h"


class ChapterNumberDialog
{
public:
  ChapterNumberDialog (bool insert);
  ~ChapterNumberDialog ();
  int run ();
protected:
  GtkWidget *dialogchapternumber;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *radiobutton_chapter_change;
  GtkWidget *radiobutton_chapter_erase;
  GtkWidget *label_purpose;
  GtkWidget *table1;
  GtkWidget *radiobuttonlist;
  GtkWidget *radiobuttonentry;
  GtkWidget *combobox1;
  GtkWidget *entry1;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;
  set <unsigned int> currentchapters_set;
  unsigned int currentchapter;
  bool myinsert;
  static void on_radiobuttonlist_clicked (GtkButton *button, gpointer user_data);
  void on_radiobuttonlist ();
  static void on_radiobuttonentry_clicked (GtkButton *button, gpointer user_data);
  void on_radiobuttonentry ();
  static void on_okbutton1_clicked (GtkButton *button, gpointer user_data);
  void on_ok ();
  static void on_radiobutton_chapter_change_clicked (GtkButton *button, gpointer user_data);
  static void on_radiobutton_chapter_erase_clicked (GtkButton *button, gpointer user_data);
  static void on_entry1_changed (GtkEditable *editable, gpointer user_data);
  void set_gui ();
  unsigned int get_chapter ();
};


#endif
