/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.HashMap;
import jolon.xml.XMLObject;

public class OsisConverter
extends GoBibleCreator {
    public static final String OSIS_TAG = "osis";
    public static final String OSIS_BODY_TAG = "osisText";
    public static final String TESTAMENT_TAG = "div";
    public static final String BOOK_TAG = "div";
    public static final String BOOK_NAME_ATTRIBUTE = "osisID";
    public static final String BOOK_SHORT_NAME_ATTRIBUTE = "osisID";
    public static final String CHAPTER_TAG_CHAPTER = "chapter";
    public static final String CHAPTER_TAG_DIV = "div";
    public static final String CHAPTER_NUMBER_ATTRIBUTE = "osisID";
    public static final String VERSE_TAG = "verse";

    public HashMap parse(XMLObject osis) {
        return this.parseBooks(osis, OSIS_BODY_TAG, "div", "div", "osisID", null);
    }

    public boolean isChapter(XMLObject xml) {
        String tag = xml.getTag();
        return tag.equals(CHAPTER_TAG_CHAPTER) || tag.equals("div");
    }

    public int getChapterNumber(XMLObject xml) {
        String title = xml.getAttribute("osisID", "*Error no osisID attribute*");
        int spaceIndex = title.lastIndexOf(46);
        return Integer.parseInt(title.substring(spaceIndex + 1));
    }

    public void parseChapter(XMLObject xml, Chapter chapter) {
        Enumeration e = xml.getChildren();
        while (e.hasMoreElements()) {
            XMLObject xmlVerse = (XMLObject)e.nextElement();
            if (!xmlVerse.getTag().equals(VERSE_TAG)) continue;
            String verseString = OsisConverter.extractCDATA(xmlVerse);
            chapter.verses.addElement(verseString);
            chapter.allVerses.append(verseString);
        }
    }
}

