# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Sun Mar 13 21:31:13 2005

import wx, StringIO
import BIB

class ImportFrame(wx.Frame):
	def __init__(self, *args, **kwds):
		# begin wxGlade: ImportFrame.__init__
		kwds["style"] = wx.DEFAULT_FRAME_STYLE
		wx.Frame.__init__(self, *args, **kwds)
		self.label_1 = wx.StaticText(self, -1, _("Format"))
		self.format = wx.Choice(self, -1, choices=[])
		self.clear = wx.Button(self, -1, _("Clear"))
		self.text = wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE|wx.HSCROLL)
		self.import_quit = wx.Button(self, -1, _("Import && Quit"))
		self.importb = wx.Button(self, -1, _("Import"))
		self.quit = wx.Button(self, -1, _("Quit"))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.__set_evt()

	def __set_properties(self):
		# begin wxGlade: ImportFrame.__set_properties
		self.SetTitle(_("Import"))
		self.SetSize((388, 392))
		self.format.SetSelection(0)
		self.import_quit.SetDefault()
		# end wxGlade
		# Add Importer names in self.format
		for importer in ('Refer','Refer_EndNote','RIS','BibTeX','ISI','PubMed','PubMedXML'):
			self.format.Append(importer)
		# restore default values from config
		self.SetDimensions(BIB.IMPORT_X, BIB.IMPORT_Y, BIB.IMPORT_WIDTH, BIB.IMPORT_HEIGHT)
		self.format.SetSelection(BIB.IMPORT_FORMAT)

	def __do_layout(self):
		# begin wxGlade: ImportFrame.__do_layout
		sizer_1 = wx.BoxSizer(wx.VERTICAL)
		sizer_2 = wx.BoxSizer(wx.VERTICAL)
		sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_3.Add(self.label_1, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_3.Add(self.format, 1, wx.ALIGN_CENTER_VERTICAL, 0)
		sizer_3.Add((20, 20), 0, 0, 0)
		sizer_3.Add(self.clear, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_2.Add(sizer_3, 0, wx.EXPAND, 0)
		sizer_2.Add(self.text, 1, wx.ALL|wx.EXPAND, 5)
		sizer_4.Add(self.import_quit, 0, wx.ALL, 5)
		sizer_4.Add(self.importb, 0, wx.ALL, 5)
		sizer_4.Add(self.quit, 0, wx.ALL, 5)
		sizer_2.Add(sizer_4, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
		sizer_1.Add(sizer_2, 1, wx.EXPAND, 0)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_1)
		self.Layout()
		# end wxGlade

	def __set_evt(self):
		wx.EVT_BUTTON(self,self.clear.GetId(), lambda evt: self.text.Clear())
		wx.EVT_BUTTON(self,self.quit.GetId(), self.onQuit)
		wx.EVT_BUTTON(self,self.importb.GetId(), self.onImport)
		wx.EVT_BUTTON(self,self.import_quit.GetId(), self.onImportQuit)

	def onImport(self,event):
		self.GetParent().FileImport(self.format.GetStringSelection(), StringIO.StringIO(self.text.GetValue().encode('UTF-8')) )

	def onImportQuit(self,event):
		self.onImport(event)
		self.onQuit(event)

	def onQuit(self,event):
		BIB.IMPORT_X, BIB.IMPORT_Y = self.GetPositionTuple()
		BIB.IMPORT_WIDTH, BIB.IMPORT_HEIGHT = self.GetSizeTuple()
		BIB.IMPORT_FORMAT = self.format.GetSelection()
		self.Destroy()

# end of class ImportFrame


