# lyxtest.py:  Interactive Test of the LyX package
raise "this test is meant to be run as an interactive experimental session"

# customize the lyx command
from LyX import constants
constants.LYXCMD = 'lyx -dbg 4096'      # lyx cmd with lyxserver debugging

from LyX import lyxserver

constants.LYXCMD, lyxserver.LYXCMD
import logging
constants.LOG_LEVEL = logging.DEBUG

reload(lyxserver); from LyX.lyxserver import *;

# Debug/Logging with logging standard module
# ------------------------------------------

# Simple

import logging

logging.warn("Hello")
logging.error("Still here...")
logging.warn("Goodbye")


# With Logger instances

# --- mymodule.py --------------------------------------------------------------------
import logging

log = logging.getLogger("MyModule")

def doIt():
    log.debug("doin' stuff")
    #do stuff...but suppose an error occurs?
    raise TypeError, "bogus type error for testing"

# --- myapp.py -----------------------------------------------------------------------
import logging

logging.basicConfig()
log = logging.getLogger("MyApp")
log.setLevel(logging.DEBUG) #set verbosity to show all messages of severity >= DEBUG

log.info("Starting my app")
try:
    # mymodule.doIt()
    doIt()
except Exception, e:
    log.exception("There was a problem.")

log.info("Ending my app")



from LyX.lyclient import filter_options

# filter command options (like -dbg 1234)
filter_options(['-help', "file1", 'file2'], constants.LYX_OPTIONS)
filter_options(['-dbg', '4096', "file1", 'file2'], constants.LYX_OPTIONS)
filter_options(['-dbg', '4096', '-private', "file1", 'file2'], constants.LYX_OPTIONS)
filter_options(['--import', 'fmt', 'ifile', "file1", 'file2'], constants.LYX_OPTIONS)
# "wrong" options
filter_options(['--help', "file1", 'file2'], constants.LYX_OPTIONS)
filter_options(['-import', 'fmt', 'ifile', "file1", 'file2'], constants.LYX_OPTIONS)
filter_options(['-db', '4096', '-private', "file1", 'file2'], constants.LYX_OPTIONS)


# startlyx

reload(lyxserver); from LyX.lyxserver import *; lyxserver.DEBUG = 3

start_lyx()
start_lyx("lyx")
start_lyx("lyx -dbg 4096")
start_lyx("lyx", ["-dbg", "4096"])


# LyX pipes
# ---------

inpipe = lyxpipe()
inpipe = lyxpipe(lyxcmd=LYXCMD)
inpipe
inpipe.write('LYXCMD:test:message:hello world\n')
del(inpipe)

outpipe = lyxpipe(mode='r+')
outpipe.read()
del(outpipe)

# LyXServer
# ---------
reload(lyxserver); from LyX.lyxserver import *; lyxserver.DEBUG = 4

lx = LyXServer(lyxcmd=None)
lx = LyXServer()
dir(lx); lx.name
lx.inpipe, lx.outpipe
lx.write("LYXCMD:lx:server-get-layout\n")    # remember the '\n'!!!!!!!!!
lx.write("LYXCMD:%s:self-insert: foo\n"%lx.name)
lx.readline(timeout = 500)
lx.readlines()
lx.read()
lx.closed
lx.close()
lx.open()

lx.write("LYXCMD:%s:buffer-write\n"%lx.name)

# iterating

dir(lx.__iter__)
help(lx.__iter__)
lx.write("LYXCMD:lx:server-get-layout\n")    # remember the '\n'!!!!!!!!!
for line in lx:
    print repr(line)

lx.inpipe, lx.outpipe

for line in lx.__iter__(5000):
    print repr(line)

del(lx)

# LyXClient
# ---------
import LyX.lyxclient
reload(LyX.lyxclient); from LyX.lyxclient import *; LyX.lyxclient.DEBUG = 3

# LyXMessage

msg_strings = ["LYXCMD:clientname:function:argument",
               "INFO:clientname:function:data",
               "ERROR:clientname:function:error message",
               "NOTIFY:key-sequence",
               "LYXSRV:clientname:hello"]

for msg in msg_strings:
    print LyXMessage(msg),

# "wrong" messages
LyXMessage("STRANGE:F12")           # wrong message type -> KeyError
LyXMessage("LYXCMD:F11")            # missing fields are left out
LyXMessage("NOTIFY") 
LyXMessage(msg_type = "INFO")
LyXMessage("NOTIFY:F11:cargo data") # Additional fields are ignored

# ------------------------------------------------------------------------

import LyX.lyxclient
reload(LyX.lyxclient); from LyX.lyxclient import *; LyX.lyxclient.DEBUG = 3

# client = LyXClient()
client = LyXClient()
dir(client)
client.inpipe, client.outpipe, client.closed

# load mulitple files
filenames = ["test.lyx", "test2.lyx"]

print "result of file-open: %r"%client("file-open", filenames[0])
print "result of file-open: %r"%client("file-open", filenames[1])

print "current buffer: %r"%client("server-get-name")

client("buffer-close")
client("lyx-quit")
client.close()

client.open()
del client

# Test the iterator
for msg in client:
    print msg



# Test the message picking
reload(LyX.lyxclient); from LyX.lyxclient import *; LyX.lyxclient.DEBUG = 4
client = LyXClient()

fname = 'test.lyx'
client("file-open", fname)
client.write_lfun("server-get-layout") # return INFO
client.write_lfun("math-macro", "")  # return ERROR

client.readmessage()
client.readmessage(msg_type='INFO')
client.readmessage(msg_type='ERROR')
client.readmessage(msg_type='INFO', data="Standard")
client.readmessage(msg_type='INFO', data="lfff")

client.readmessages()

# read with writeback of junk messages
client.write_lfun("server-get-layout") # return INFO
client.write_lfun("math-macro", "")  # return ERROR

client.readmessage(msg_type='ERROR', writeback=5)
client.readmessage(msg_type='INFO', writeback=5)

# What happens for 2 instances?
client2 = LyXClient()
client = LyXClient()

client.write_lfun("server-get-layout") # return INFO
client.write_lfun("math-macro", "")  # return ERROR
client2.readmessage(writeback=5)
client2("apropos", "file-open")
client.readmessage()
# no problem with more than one reader (as they are non-blocking)
del(client2)

client.write_lfun("lyx-quit")
client.readmessage()

# Listening
# ---------
reload(LyX.lyxclient); from LyX.lyxclient import *; LyX.lyxclient.DEBUG = 4
client = LyXClient()

fname = 'test.lyx'
# client("file-open", fname)

client("server-get-layout") # return INFO
client("server-notify") # return-value "" (no-data as this is no INFO but a  NOTIFY)
client.readlines()      # NOTFY + last key pressed in LyX


client = LyXClient(lyxcmd=LYXCMD)
client.bindings["M-q"] = "raise LyXError, 'kbd-quit'"
client.bindings["F12"] = "print 'hi'"
for key, fun in client.bindings.iteritems():
    print "%s: %s"%(key, fun)


client.listen()  # abort with M-q in LyX

del client



# pyfuns.py, lfuns.py
# -------------------

from LyX import lfuns, pyfuns
reload(lfuns); from LyX.lfuns import *; lfuns.DEBUG = 3
# overwrite with pyfuns
reload(pyfuns); from LyX.pyfuns import *; pyfuns.DEBUG = 3

kbd_quit()

# Help functions
print "".join(apropos("copy"))
print where_is('copy')
showkey("C-C")
showkey("C-c")
showkey("M-w")

buffer_new()
self_insert("some test string with some nice words")
buffer_select()
line_select()
get_x_selection()
get_lyx_selection()
get_buffer()
count_words()
external_edit()

server_get_name()
buffer_write()
escape()

# Apropos
apropos("buffer")
apropos("delete")
apropos("file")
apropos("key")
apropos("line")
apropos("menu")
apropos("name")
apropos("paragraph")
apropos("reload")
apropos("select")
apropos("write")

# lfuns
# -------------
from LyX import lfuns
reload(lfuns); from LyX.lfuns import *; lyxclient.DEBUG = 3

fname = '/home/milde/Texte/Test/article-test.lyx'

message("Hi from python")
file_open(fname)
apropos("file-open")
math_macro("xyx", 3)
math_macro("")  # return error
buffer_end()
server_get_layout()
self_insert(" foo ")
server_get_name()
server_get_xy()
accent_ogonek()
self_insert("aha")
bookmark_save("1")
bookmark_goto(1)
bookmark_save("my-mark")
bookmark_goto("my-mark")
buffer_update("dvi")

# problematic LFUNS
lfuns.server_get_font()       
# always returns '0'

lfuns.server_get_tip()           
# always returns 'Keine Beschreibung vorhanden!'

lfuns.server_goto_file_row(fname, "55") 
# open file or goto associated buffer
# * Doesnot seem to go to row
# * With a read-only buffer as current buffer:
#    LyXError: 'Document is read-only'
# * With a fresh lyx
#    LyXError: 'Command not allowed without any document open'

client("server-notify")
# * With a fresh lyx
#    LyXError: 'Command not allowed without any document open'

lfuns.nonexisting()              
# non existing LFUNs should return an ERROR response

lfuns.server_char_after("j")
# This is one exception: it doesnot result in an ERROR, however in some
# debug output: 'A truly unknown func [server-char-after]!'

lfuns.buffer_reload()


lfuns.menu_open("insert")
# takes menu names from *.ui as argument (also submenues?)

# LFUNS breaking the serverpipes: 
# -------------------------------

# The following functions work fine but break the serverpipe when called 
# via the lyxserver. 
# This is bad for a client listening at the outpipe for a notice
#
# No problem if they are called via M-x (as then no reply will be sent 
# to the outpipe

lfuns.buffer_export('text')
# The command succedes, a reply is sent (and received)
#   LyXComm: Sending 'INFO:pyClient1076141868:buffer-export:
#   '
# but after that comes
#   LyXComm: Ungltiger Link ber Gertegrenzen hinweg
#   LyXComm: Closing connection
#   LyXComm: Opening connection
#   LyXComm: Connection established
   
lfuns.buffer_write()
# Here we get (after a successfull write):
#   LyXComm: Datei oder Verzeichnis nicht gefunden
#   LyXComm: Closing connection
#   LyXComm: Opening connection
#   LyXComm: Connection established

lfuns.buffer_write_as(fname+"test")
lfuns.buffer_view("ps")
# the same as buffer_write


