#include <bickley/bkl-db.h>
#include <bickley/bkl-source-client.h>
#include <bickley/bkl-utils.h>

int
main (int    argc,
      char **argv)
{
    BklSourceClient *client;
    GPtrArray *items;
    BklDB *db = NULL;

    g_thread_init (NULL);
    bkl_init ();

    client = bkl_source_client_new (BKL_LOCAL_SOURCE_PATH);
    g_assert (client);

    db = bkl_source_client_get_db (client);
    if (db != NULL) {
      items = bkl_db_get_items (db, FALSE, NULL);

      if (items) {
        g_print ("Got %d items\n", items->len);
      }
    } else {
      g_print ("No database to query. Try running bkl-orbiter.\n");
    }

    return 0;
}
