/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __KOZO_PACK_H__
#define __KOZO_PACK_H__

#include <glib.h>

#include "kozo-field.h"

typedef struct
{
        guint8 *data;
        guint32 length;
        guint32 offset;
} KozoPackEntry;

typedef struct
{
        gboolean prepend_count;
        guint n_fields;
        guint alignment;

        KozoPackEntry *entries;

        guint cur_idx;

        guint8 *dest;
        guint32 length;
} KozoPackContext;

#define kozo_pack_context_init(xcontext, xprepend_count, \
                               xn_fields, xalignment) \
        (xcontext)->n_fields = (xn_fields); \
        (xcontext)->prepend_count = (xprepend_count); \
        (xcontext)->alignment = (xalignment); \
        (xcontext)->entries = g_newa (KozoPackEntry, (xcontext)->n_fields);

void kozo_pack_start       (KozoPackContext *c);

void kozo_pack_finish      (KozoPackContext *c);

void kozo_pack_data        (KozoPackContext *c,
                            guint8          *data,
                            guint32          length);

void kozo_pack_field       (KozoPackContext *c,
                            KozoField       *field);
void kozo_pack_empty_field (KozoPackContext *c);

void kozo_pack_string      (KozoPackContext *c,
                            const char      *str);
void kozo_pack_int         (KozoPackContext *c,
                            gint32          *i);
void kozo_pack_time        (KozoPackContext *c,
                            time_t          *time);
void kozo_pack_entry       (KozoPackContext *c,
                            KozoEntry       *entry);

#endif /* __KOZO_PACK_H__ */
