/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "bkl-entry.h"

KozoField *
bkl_entry_get_field (KozoEntry   *entry,
                     BklFieldType field)
{
    g_return_val_if_fail (entry != NULL, NULL);

    return kozo_entry_get_field (entry, field);
}

const char *
bkl_file_field_get_string (KozoField   *f,
                           BklFileField field)
{
    g_return_val_if_fail (f != NULL, NULL);

    return kozo_field_get_value_string (f, field);
}

const char *
bkl_audio_field_get_string (KozoField    *f,
                            BklAudioField field)
{
    g_return_val_if_fail (f != NULL, NULL);

    return kozo_field_get_value_string (f, field);
}

const char *
bkl_image_field_get_string (KozoField    *f,
                            BklImageField field)
{
    g_return_val_if_fail (f != NULL, NULL);

    return kozo_field_get_value_string (f, field);
}

const char *
bkl_video_field_get_string (KozoField    *f,
                            BklVideoField field)
{
    g_return_val_if_fail (f != NULL, NULL);

    return kozo_field_get_value_string (f, field);
}

const char *
bkl_extended_field_get_string (KozoField       *f,
                               BklExtendedField field)
{
    g_return_val_if_fail (f != NULL, NULL);

    return kozo_field_get_value_string (f, field);
}

const char *
bkl_broken_field_get_string (KozoField     *f,
                             BklBrokenField field)
{
    g_return_val_if_fail (f != NULL, NULL);

    return kozo_field_get_value_string (f, field);
}

const char *
bkl_playlist_field_get_string (KozoField       *f,
                               BklPlaylistField field)
{
    g_return_val_if_fail (f != NULL, NULL);

    return kozo_field_get_value_string (f, field);
}
