;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Reduce/walk.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:25:23 1995                          */
;*    Last change :  Tue Apr  1 07:00:09 2003 (serrano)                */
;*    Copyright   :  1995-2003 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The Reduction optimizations                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module reduce_walk
   (include "Engine/pass.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    type_type
	    ast_var
	    ast_node
	    reduce_copy
	    reduce_cse
	    reduce_cond
	    reduce_typec
	    reduce_1occ
	    reduce_beta
	    ast_remove)
   (export  (reduce-walk! globals)))

;*---------------------------------------------------------------------*/
;*    reduce-walk ...                                                  */
;*---------------------------------------------------------------------*/
(define (reduce-walk! globals)
   (if *optim-dataflow?*
       (begin
	  (pass-prelude "Reduction")
	  (reduce-copy! globals)
	  (if (>=fx *optim* 2) (reduce-cse! globals))
	  (reduce-type-check! globals)
	  (reduce-copy! globals)
	  (reduce-conditional! globals)
	  (reduce-1occ! globals)
	  (if *optim-reduce-beta?* (reduce-beta! globals))
	  (pass-postlude (remove-var 'reduce globals)))
       globals))
  
 
