(module saw_defs
   (import type_type ast_var ast_node saw_lib)
   (export
    ;; Regs
    (final-class rtl_reg type::type var) ; var::(or local #f)
    ;; Functions
    (class rtl_fun)
     ; dest = #f and no continuation (last instruction of terminals blocks)
     (class rtl_last::rtl_fun)
      (class rtl_return::rtl_last type::type)
      (class rtl_jumpexit::rtl_last)
      (class rtl_fail::rtl_last)
     ; dest = #f and multiple continuation (last instruction of blocks)
     (class rtl_notseq::rtl_fun)
      (class rtl_if::rtl_notseq)
      (class rtl_select::rtl_notseq type::type patterns)
      (class rtl_switch::rtl_select labels)
      (class rtl_ifeq::rtl_notseq then::block)
      (class rtl_ifne::rtl_notseq then::block)
      (class rtl_go::rtl_notseq to::block)
     ; doesn't make side effects
     (class rtl_pure::rtl_fun)
      (class rtl_nop::rtl_pure)
      (class rtl_mov::rtl_pure)
      (class rtl_loadi::rtl_pure constant::atom)
      (class rtl_loadg::rtl_pure var::global)
      (class rtl_loadfun::rtl_pure var::global)
      (class rtl_globalref::rtl_pure var::global)
      (class rtl_getfield::rtl_pure name::bstring objtype::type type::type)
      (class rtl_valloc::rtl_pure type::type vtype::type)
      (class rtl_vref::rtl_pure type::type vtype::type)
      (class rtl_vlength::rtl_pure type::type)
      (class rtl_isa::rtl_pure type::type)
      (class rtl_makebox::rtl_pure)
      (class rtl_boxref::rtl_pure)
     ; dest = #f and make side-effect
     (class rtl_effect::rtl_fun)
      (class rtl_storeg::rtl_effect var::global)
      (class rtl_setfield::rtl_effect name::bstring objtype::type type::type)
      (class rtl_vset::rtl_effect type::type vtype::type)
      (class rtl_boxset::rtl_effect)
     ; others
     (class rtl_new::rtl_fun type::type constr::pair-nil)
     (class rtl_call::rtl_fun var::global)
     (class rtl_apply::rtl_fun)
     (class rtl_lightfuncall::rtl_fun)
     (class rtl_funcall::rtl_fun)
     (class rtl_pragma::rtl_fun format::bstring)
     (class rtl_cast::rtl_fun type::type)
     (class rtl_cast_null::rtl_fun type::type)
     (class rtl_protect::rtl_fun)
      (class rtl_protected::rtl_fun)

    ;; New Functions for STL
    (class stl_loadr::rtl_fun reg::rtl_reg)
    (class stl_storer::rtl_fun reg::rtl_reg)
    (class stl_pop::rtl_fun)

    ;; Instructions
    (final-class rtl_ins
       (loc (default #f))
       (dest (default #f))			; ::(or reg #f)
       (fun::rtl_fun)
       (args::pair-nil) )			; ::(list (or reg ins))

    ;; Block of instructions
    (final-class block
       (label::int (default 0))
       (preds::pair-nil (default '()))		; ::(list block)
       (succs::pair-nil (default '()))		; ::(list block)
       first::pair )				; :: (list ins)
    
    (ins-name ins::rtl_ins)
    (fun-name fun::rtl_fun))
   )

(define (ins-name ins::rtl_ins)
   (fun-name (rtl_ins-fun ins)) )

(define (fun-name fun::rtl_fun)
   (if (rtl_call? fun)
       (string-append "call "
		      (symbol->string (variable-id (rtl_call-var fun))) )
       (class-name (object-class fun)) ))
