;*=====================================================================*/
;*    serrano/prgm/project/bigloo/fthread/src/exc.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 18 14:27:27 2002                          */
;*    Last change :  Wed Mar  6 08:58:25 2002 (serrano)                */
;*    Copyright   :  2002 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Fair exceptions                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __ft_exception

   (import __ft_types
	   __ft_%types
	   __ft_%exception
	   __ft_thread)

   (export (current-exception-handler)
	   (with-exception-handler handler thunk)
	   (raise obj)

	   (join-timeout-exception?::bool ::obj)
	   (abandoned-mutex-exception?::bool ::obj)
	   (terminated-thread-exception?::bool ::obj)
	   (uncaught-exception?::bool ::obj)
	   (uncaught-exception-reason::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    *exception-handler* ...                                          */
;*---------------------------------------------------------------------*/
(define *exception-handler*
   (list uncaught-exception-hdl))

;*---------------------------------------------------------------------*/
;*    current-exception-handler ...                                    */
;*---------------------------------------------------------------------*/
(define (current-exception-handler)
   (let ((t (current-thread)))
      (if (thread? t)
	  (car (thread-%exc-handlers t))
	  (car *exception-handler*))))

;*---------------------------------------------------------------------*/
;*    with-exception-handler ...                                       */
;*---------------------------------------------------------------------*/
(define (with-exception-handler handler thunk)
   (let ((t (current-thread)))
      (if (thread? t)
	  (with-access::thread t (%exc-handlers)
	     (set! %exc-handlers (cons handler %exc-handlers))
	     (unwind-protect
		(thunk)
		(set! %exc-handlers (cdr %exc-handlers))))
	  (begin
	     (set! *exception-handler* (cons handler *exception-handler*))
	     (unwind-protect
		(thunk)
		(set! *exception-handler* (cdr *exception-handler*)))))))

;*---------------------------------------------------------------------*/
;*    raise ...                                                        */
;*---------------------------------------------------------------------*/
(define (raise obj)
   ((current-exception-handler) obj))

;*---------------------------------------------------------------------*/
;*    join-timeout-exception? ...                                      */
;*---------------------------------------------------------------------*/
(define (join-timeout-exception? obj)
   (eq? obj *join-timeout-exception*))

;*---------------------------------------------------------------------*/
;*    abandoned-mutex-exception? ...                                   */
;*---------------------------------------------------------------------*/
(define (abandoned-mutex-exception? obj)
   (eq? obj *abandoned-mutex-exception*))

;*---------------------------------------------------------------------*/
;*    terminated-thread-exception? ...                                 */
;*---------------------------------------------------------------------*/
(define (terminated-thread-exception? obj)
   (eq? obj *terminated-thread-exception*))

;*---------------------------------------------------------------------*/
;*    uncaught-exception? ...                                          */
;*---------------------------------------------------------------------*/
(define (uncaught-exception? obj)
   (%uncaught-exception? obj))

;*---------------------------------------------------------------------*/
;*    uncaught-exception-reason ...                                    */
;*---------------------------------------------------------------------*/
(define (uncaught-exception-reason obj)
   (if (not (uncaught-exception? obj))
       (error "uncaught-exception-reason" "Illegal exception" obj)
       (%uncaught-exception-reason obj)))
       
