/*=====================================================================*/
/*    serrano/prgm/project/bigloo/fthread/src/Posix/bglthread.h        */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Feb 22 11:01:20 2002                          */
/*    Last change :  Sat Aug 16 14:13:05 2003 (serrano)                */
/*    Copyright   :  2002-03 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The C headers for Bigloo fair threads.                           */
/*=====================================================================*/
#include <pthread.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    bglthread_t                                                      */
/*---------------------------------------------------------------------*/
typedef struct bglthread {
   obj_t thunk;
   obj_t bglobj;
   obj_t name;
   bgldenv_t env;
   pthread_t pthread;
   pthread_mutex_t lock;
   pthread_cond_t cv;
   struct bglthread *parent;
} *bglthread_t;

/*---------------------------------------------------------------------*/
/*    Prototypes                                                       */
/*---------------------------------------------------------------------*/
extern bglthread_t bglthread_new( obj_t );
extern bglthread_t bglthread_new_with_name( obj_t, obj_t );
extern void bglthread_start( bglthread_t );
extern void bglthread_setup( bglthread_t, obj_t );

extern void bglthread_wait( bglthread_t );
extern void bglthread_switch( bglthread_t, bglthread_t );

extern void bglthread_enter_scheduler( bglthread_t );
extern void bglthread_leave_scheduler( bglthread_t );

extern obj_t bglthread_id_set( bglthread_t, obj_t );
extern obj_t bglthread_id_get();

extern void bglasync_spawn( bglthread_t, obj_t, obj_t );
extern void bglasync_synchronize( bglthread_t );
extern void bglasync_asynchronize( bglthread_t );
extern void bglasync_scheduler_wait( bglthread_t );
extern void bglasync_scheduler_notify( bglthread_t );

extern int bglthread_key_create( pthread_key_t *, void * );
extern int bglthread_setspecific( pthread_key_t, void * );
extern void *bglthread_getspecific( pthread_key_t );

/*---------------------------------------------------------------------*/
/*    String buffers                                                   */
/*---------------------------------------------------------------------*/
#define BGL_STRING_REF( _s, _i ) ((_s)[ _i ])
#define BGL_STRING_SET( _s, _i, _v ) ((_s)[ _i ] = (_v))
