.TH BDEPEND 1 "Aug 15 1998" 
.de BP
.sp
.ti -.2i
..
.SH NAME
bdepend \- create Bigloo dependencies in makefiles

.SH SYNOPSIS
.B bdepend
[ options ]
.I sourcefile ...

.SH DESCRIPTION

.B bdepend
program reads each \fIsourcefile\fR in sequence and  parses it to find the
module \fBinclude\fR and \fBimport\fR module directives. \fBbdepend\fR
computes the transitive closure of the import relationship. That is, it
is sufficient to provide \fBbdepend\fR with a single Bigloo file that 
imports all the project file (e.g. the "main" file.)

Every  file  that a \fIsourcefile\fR includes, directly or indirectly, 
is what \fBbdepend\fR calls a \fIdependency\fR. These dependencies are then
written to a \fImakefile\fR in such a way that \fBmake(1)\fR will know 
which object files must be recompiled when a dependency has changed.

By default, \fBbdepend\fR writes its output on the standard output device.
If \fBbdepend\fR is provided with a \fB-o\fR \fImakefile\fR\fR option, 
it will update the \fImakefile\fR file. That is, it will search the makefile 
for the line:
.sp 0 
 # bdepend start (don't edit)
.sp 0
and
.sp 0
 # bdepend stop
.sp 0
  
Dependencies will be written in between these two lines.

.SH OPTIONS

.TP 16
.TP
file
Is an file implementing a module. 
.B Afile
reads that file to discover the name of the implemented module.

.TP
-search-path <path>
Add \fIpath\fR to the directory list read for searching Bigloo source files.

.TP
-exclude-path <path>
Exclude \fIpath\fR from the directory list read for searching Bigloo 
source files.

.TP
-suffix <suf>
Adds \fIsuf\fR to the \fBbmake\fR source file suffixes list. Default 
suffixes are "scm", "sch" and "bgl".

.TP
-v
Verbose mode

.TP
-o <makefile>
The name of the \fImakefile\fR file to be updated

.SH "EXAMPLE"

Normally,  \fbbdepend\fR will be used in a makefile target so
that typing ``make bdepend'' will bring the dependencies up
to date for the makefile.  For example,

.sp 0
   MAIN=foo.scm
.sp 0
   SRCS = $(MAIN) bar.scm gee.scm
.sp 0
   bdepend:
.sp 0
       bdepend -o Makefile $(MAIN)
.sp 0

.SH "SEE ALSO"
bigloo(1), afile(1), bmake(1), bpp(1), bprof(1), btags(1), makedepend(1),
make(1)

.SH AUTHOR
Manuel SERRANO,
Manuel.Serrano@inria.fr


