/*=====================================================================*/
/*    serrano/prgm/project/bigloo/fthread/src/Java/bglfthread.java     */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jan 30 10:40:23 2002                          */
/*    Last change :  Fri Mar 11 10:57:28 2005 (serrano)                */
/*    Copyright   :  2002-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Bigloo Class for threads. Nothing fancy here.                    */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    The package                                                      */
/*---------------------------------------------------------------------*/
package bigloo.fthread;
import java.lang.*;
import bigloo.*;

/*---------------------------------------------------------------------*/
/*    bglfthread                                                       */
/*---------------------------------------------------------------------*/
public class bglfthread extends Thread {
   // Bigloo connection
   private Object bgl_obj;
   private Object ident;
   private procedure bgl_thunk;
   public bgldynamic env;
   
   // parent thread (i.e. the Java thread that has entered this Bgl thread)
   private Thread parent;

   // global cpu token
   private static Object token;

   // class constructor
   static {
      bglfdynamic.setup();
   }

   // public constructor
   public bglfthread() {
      super();
      env = new bgldynamic( bgldynamic.abgldynamic.get() );
   }
   
   // public constructor
   public bglfthread( procedure thunk ) {
      super();
      env = new bgldynamic( bgldynamic.abgldynamic.get() );
      bgl_thunk = thunk;
   }

   // public constructor
   public bglfthread( procedure thunk, symbol name ) {
      super( new String( name.string ) );
      ident = name;
      env = new bgldynamic( bgldynamic.abgldynamic.get() );
      bgl_thunk = thunk;
   }

   // This method is invoked by Bigloo when the Bigloo object
   // representing the thread has been allocated and the thread starts
   public void start( Object o ) {
      bgl_obj = o;
      start();
   }

   // This method is used for compatibility with the Posix implementation
   // Don't remove it
   public Object idSet( Object o ) {
      ident = o;
      return o;
   }

   // Return back the pointer to the Bigloo object
   public Object getBglObj() {
      return bgl_obj;
   }
   
   // entry point for Bugloo
   private void bugloo_hook() {
   }


   // The thread entry-point
   public void run() {
      try {
	 fairWait();
	 bgl_thunk.funcall0();
      } catch( Throwable e ) {
	 e.printStackTrace();
	 try {
	    foreign.internalerror( e );
	 } catch( Throwable _ ) {
	    System.exit( 1 );
	 }
      }
      bugloo_hook();
   }

   // user hook
   private void fairWaitHook() {
   }
   
   // wait for a notification
   public void fairWait() {
      synchronized( this ) {
	 try {
	    while( token != this ) {
	       wait();
	    }
	 } catch( InterruptedException e ) { 
	    System.err.println( "interrupted wait exception: " + e ); 
	 }
	 fairWaitHook();
      }
   }

   // switch to another thread
   public void fairSwitch( bglfthread next ) {
      synchronized( next ) {
	 token = next;
	 next.notify();
      }
   }

   // enter the scheduler
   public void enter_scheduler() {
      parent = currentThread();

      /* switch into the scheduler thread */
      fairSwitch( this );

      /* wait for the token to be back */
      synchronized( parent ) {
	 try {
	    while( token != parent ) {
	       parent.wait();
	    }
	 } catch( InterruptedException e ) {
	    System.err.println( "interrupted wait exception: " + e ); 
	 }
      }
   }

   // leave the scheduler
   public void leave_scheduler() {
      token = null;

      synchronized( parent ) {
	 token = parent;
	 parent.notify();
      }
      
      synchronized( this ) {
	 while( token != this ) {
	    try {
	       wait();
	    } catch( InterruptedException e ) {
	       System.err.println( "interrupted wait exception: " + e ); 
	    }
	 }
      }
   }
}
