/*=====================================================================*/
/*    serrano/prgm/project/bigloo/api/fthread/src/Posix/bglasync.c     */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Feb 25 18:13:15 2002                          */
/*    Last change :  Tue Apr  5 11:59:09 2005 (serrano)                */
/*    Copyright   :  2002-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The implementation of asynchronous threads.                      */
/*=====================================================================*/
#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <gc.h>

#define GC_PRIVATE_H
#include <bglfthread.h>

/*---------------------------------------------------------------------*/
/*    Imports                                                          */
/*---------------------------------------------------------------------*/
BGL_IMPORT char *strerror();

/*---------------------------------------------------------------------*/
/*    Global lock                                                      */
/*---------------------------------------------------------------------*/
extern pthread_key_t bglkey;

/*---------------------------------------------------------------------*/
/*    bglasync_t                                                       */
/*---------------------------------------------------------------------*/
typedef struct bglasync {
   obj_t thunk;
   obj_t id;
   bglfthread_t scdl;
} *bglasync_t;

/*---------------------------------------------------------------------*/
/*    static void *                                                    */
/*    bglfth_async_run ...                                             */
/*---------------------------------------------------------------------*/
static void *
bglfth_async_run( void *arg ) {
   bglasync_t th = (bglasync_t)arg;

   /* Mark the id for bmem (the first argument is ignored) */
   bglfth_thread_id_set( (bglfthread_t)th, th->id );

   /* run the asynchronous body */
   PROCEDURE_ENTRY( th->thunk )( th->thunk, BEOA );

   return 0L;
}

/*---------------------------------------------------------------------*/
/*    static bglasync_t                                                */
/*    bglfth_async_new ...                                             */
/*---------------------------------------------------------------------*/
static bglasync_t
bglfth_async_new( bglfthread_t scdl, obj_t proc, obj_t id ) {
   bglasync_t thread = (bglasync_t)GC_MALLOC( sizeof( struct bglasync ) );
   
   thread->thunk = proc;
   thread->id = id;
   thread->scdl = scdl;

   return thread;
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_async_spawn ...                                           */
/*---------------------------------------------------------------------*/
void
bglfth_async_spawn( bglfthread_t scdl, obj_t proc, obj_t id ) {
   bglasync_t async = bglfth_async_new( scdl, proc, id );
   pthread_attr_t a;
   pthread_t pthread;
   
   pthread_attr_init( &a );
   pthread_attr_setdetachstate( &a, PTHREAD_CREATE_DETACHED );

   if( pthread_create( &pthread, &a, bglfth_async_run, async ) )
      FAILURE( string_to_bstring( "bglasync-spawn" ),
	       string_to_bstring( "Cannot start thread" ),
	       string_to_bstring( strerror( errno ) ) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_async_scheduler_wait ...                                  */
/*    -------------------------------------------------------------    */
/*    This function must always be called within the dynamic           */
/*    extent of a bglasync_synchronize                                 */
/*---------------------------------------------------------------------*/
void
bglfth_async_scheduler_wait( bglfthread_t scdl ) {
   pthread_cond_wait( &(scdl->cv), &(scdl->lock) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_async_scheduler_notify ...                                */
/*    -------------------------------------------------------------    */
/*    This function must always be called within the dynamic           */
/*    extent of a bglfth_async_synchronize                             */
/*---------------------------------------------------------------------*/
void
bglfth_async_scheduler_notify( bglfthread_t scdl ) {
   pthread_cond_signal( &(scdl->cv) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_async_synchronize ...                                     */
/*---------------------------------------------------------------------*/
void
bglfth_async_synchronize( bglfthread_t scdl ) {
   pthread_mutex_lock( &(scdl->lock) );
}   

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_async_asynchronize ...                                    */
/*---------------------------------------------------------------------*/
void
bglfth_async_asynchronize( bglfthread_t scdl ) {
   pthread_mutex_unlock( &(scdl->lock) );
}


