;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/number.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 28 10:52:56 1992                          */
;*    Last change :  Tue May  3 11:11:49 2005 (serrano)                */
;*                                                                     */
;*    On test les operateurs generiques sur les nombres                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module number
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-number)))

;*---------------------------------------------------------------------*/
;*    test-number ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-number)
   (test-module "number" "number.scm")
   (test "=.1" (= 1 1) #t)
   (test "=.2" (= 1 1 1) #t)
   (test "=.3" (= 1 2 1) #f)
   (test "=.4" (= 1.0 1.0 1.0) #t)
   (test "=.5" (= 1.0 2.0 1.0) #f)
   (test "=.6" (= 1.0 1) #t)
   (test "=.7" (= 1 1.0) #t)
   (test "=.8" (= 1.1 1) #f)
   (test "=.9" (= 1 1.1) #f)
   (test "=.10" (= 1 #e1) #t)
   (test "=.11" (= 1 #e2) #f)
   (test "=.12" (= #e1 1) #t)
   (test "=.13" (= #e2 3) #f)
   (test "=.14" (= #e2 #e2 #e2) #t)
   (test "=.15" (= #e2 #e2 #e3) #f)
   (test "=.16" (= 1 #l1) #t)
   (test "=.17" (= 1 #l2) #f)
   (test "=.18" (= #l1 1) #t)
   (test "=.19" (= #l2 3) #f)
   (test "=.20" (= #l2 #l2 #l2) #t)
   (test "=.21" (= #l2 #l2 #l3) #f)
   (test "=.22" (= 1. #e1) #t) 
   (test "=.23" (= 1. #e2) #f)
   (test "=.24" (= #e1 1.) #t)
   (test "=.25" (= #e2 3.) #f)
   (test "=.26" (= 1. #l1) #t)
   (test "=.27" (= 1. #l2) #f)
   (test "=.28" (= #l1 1.) #t)
   (test "=.29" (= #l2 3.) #f)
   (test "<.1" (< 1 2) #t)
   (test "<.2" (< 1 1) #f) 
   (test "<.3" (< 2 1) #f)
   (test "<.4" (< 1 2 3) #t)
   (test "<.5" (< 1 2 1 3) #f)
   (test "<.6" (<elong #e1 #e2) #t)
   (test "<.7" (<elong #e2 #e1) #f) 
   (test "<.8" (< 1 #e2) #t) 
   (test "<.9" (< 10 #e2) #f) 
   (test "<.10" (<llong #l1 #l2) #t)
   (test "<.11" (<llong #l2 #l1) #f) 
   (test "<.12" (< 1 #l2) #t) 
   (test "<.13" (< 10 #l2) #f) 
   (test ">.1" (> 1 2) #f)
   (test ">.2" (> 1 1) #f)
   (test ">.3" (> 2 1) #t)
   (test ">.4" (> 3 2 1) #t)
   (test ">.5" (> 3 1 2 1) #f)
   (test ">.6" (> #e3 #e1) #t)
   (test ">.7" (> #e3 #e11) #f)
   (test ">.8" (> #l3 #e1) #t)
   (test ">.9" (> #l3 #e11) #f)
   (test ">=.1" (>= 1 2) #f)
   (test ">=.2" (>= 1 1) #t)
   (test ">=.3" (>= 2 1) #t)
   (test ">=.4" (>= 3 2 1) #t)
   (test ">=.5" (>= 3 1 2 1) #f)
   (test ">=.6" (>= #e1 #l2) #f)
   (test ">=.7" (>= #l1 #l1) #t)
   (test ">=.8" (>= #l2 #e1) #t)
   (test "<=.1" (<= 1 2) #t)
   (test "<=.2" (<= 1 1) #t)
   (test "<=.3" (<= 2 1) #f)
   (test "<=.4" (<= 1 2 3) #t)
   (test "<=.5" (<= 1 2 1 3) #f)
   (test "<=.6" (<= #l1 #e2) #t)
   (test "<=.7" (<= #e1 #e1) #t)
   (test "<=.8" (<= #l2 #l1) #f)
   (test "+.1" (+ 1 2 3 4) 10)
   (test "+.2" (+ #e1 #e2) #e3)
   (test "+.3" (+ #l1 #e2) #l3)
   (test "-.1" (- 1 2 3 4) -8)
   (test "-.2" (let ((x 4.0)) (- x)) -4.0)
   (test "-.3" (- #l2 #e1) #l1)
   (test "*.1" (* 1 2 3 4) 24)
   (test "*.2" (* #l2 #e2) #l4)
   (test "/.1" (/ 12 3 2 1) 2)
   (test "/.2" (/ (/ 4)) 4.0)
   (test "/.3" (/ 4. #l2) 2.0)
   (test "/.4" (/ 4. #e2) 2.0)
   (test "/.5" (/ 1 #e2) 0.5)
   (test "/.6" (/ 1 #l2) 0.5)
   (test "/.7" (/ #e1 #e2) 0.5)
   (test "/.8" (/ #e1 #l2) 0.5)
   (test "/.9" (/ #l1 #e2) 0.5)
   (test "/.10" (/ #l1 #l2) 0.5)
   (test "/.11" (/ 1. #l2) 0.5)
   (test "/.12" (/ #l1 2.) 0.5)
   (test "/.13" (/ 1. #e2) 0.5)
   (test "/.14" (/ #e1 2.) 0.5)
   (test "/fx.1" (/fx 5 4) 1)
   (test "/fx.2" (integer? (/fx 5 4)) #t)
   (test "zero?.1" (zero? 3) #f)
   (test "zero?.2" (zero? 0) #t)
   (test "zero?.3" (zero? 3.0) #f)
   (test "zero?.4" (zero? 0.0) #t)
   (test "zero?.5" (zero? #e0) #t)
   (test "zero?.6" (zero? #l0) #t)
   (test "positive?.1" (positive? 5.0) #t)
   (test "positive?.2" (positive? -5.0) #f)
   (test "positive?.3" (positive? 5) #t)
   (test "positive?.4" (positive? -5) #f)
   (test "positive?.5" (positive? #e-5) #f)
   (test "positive?.6" (positive? #l-5) #f)
   (test "negative?.1" (negative? 5.0) #f)
   (test "negative?.2" (negative? -5.0) #t)
   (test "negative?.3" (negative? 5) #f)
   (test "negative?.4" (negative? -5) #t)
   (test "negative?.5" (negative? #e-5) #t)
   (test "negative?.6" (negative? #l-5) #t)
   (test "odd?.1" (odd? 4) #f)
   (test "odd?.2" (odd? 3) #t)
   (test "even?.1" (even? 4) #t)
   (test "even?.2" (even? 3) #f)
   (test "max.1" (max 3 4) 4)
   (test "max.2" (max 3.9 4) 4)
   (test "min.1" (min 3 4) 3) 
   (test "min.2" (min 3.9 4) 3.9)
   (test "modulo.1" (modulo 13 4) 1)
   (test "remainder.1" (remainder 13 4) 1)
   (test "modulo.2" (modulo -13 4) 3)
   (test "remainder.2" (remainder -13 4) -1)
   (test "modulo.3" (modulo 13 -4) -3)
   (test "remainder.3" (remainder 13 -4) 1)
   (test "modulo.4" (modulo -13 -4) -1)
   (test "remainder.4" (remainder -13 -4) -1)
   (test "gcd" (gcd 32 -36) 4)
   (test "gcd" (gcd) 0)
   (test "lcm" (lcm 32 -36) 288)
   (test "lcm" (lcm) 1)
   (test "flonum->fixnum" (flonum->fixnum (cosfl 0.0)) 1)
   (test "atan" (tan (atan 1)) (fixnum->flonum 1))
   (test "flofix.<" (< 3.0 3) #f)
   (test "flofix.<" (< 3.1 3) #f)
   (test "flofix.<" (< 3.1 4) #t)
   (test "flofix.>" (> 3 3.0) #f)
   (test "flofix.>" (> 3 3.1) #f)
   (test "flofix.>" (> 4 3.1) #t)
   (test "flofix.<=" (<= 3 3.0) #t)
   (test "flofix.<=" (<= 3 3.1) #t)
   (test "flofix.<=" (<= 3 2.0) #f)
   (test "flofix.>=" (>= 3.0 3) #t)
   (test "flofix.>=" (>= 3.1 3) #t)
   (test "flofix.>=" (>= 3.1 4) #f)
   (let ((x 3.0) (y 3))
      (test "flofix.<" (< x y) #f))
   (let ((x 3.1) (y 3))
      (test "flofix.<" (< x y) #f))
   (let ((x 3.1) (y 4))
      (test "flofix.<" (< x y) #t))
   (let ((x 3) (y 3.0))
      (test "flofix.>" (> x y) #f))
   (let ((x 3) (y 3.1))
      (test "flofix.>" (> x y) #f))
   (let ((x 4) (y 3.1))
      (test "flofix.>" (> x y) #t))
   (let ((x 3) (y 3.0))
      (test "flofix.<=" (<= x y) #t))
   (let ((x 3) (y 3.1))
      (test "flofix.<=" (<= x y) #t))
   (let ((x 3) (y 2.0))
      (test "flofix.<=" (<= x y) #f))
   (let ((x 3.0) (y 3))
      (test "flofix.>=" (>= x y) #t))
   (let ((x 3.1) (y 3))
      (test "flofix.>=" (>= 3.1 3) #t))
   (let ((x 3.1) (y 4))
      (test "flofix.>=" (>= 3.1 4) #f))
   (let ((x -0.2) (y 0))
      (test "flofix.<" (< x y) #t))
   (test "string->number" (string->number "0") 0)
   (test "string->number" (string->number "e") #f)
   (test "string->number" (string->number "0" 2) 0)
   (test "string->number" (string->number "0" 8) 0)
   (test "string->number" (string->number "0" 16) 0)
   (test "string->number" (string->number "") #f)
   (test "string->number" (string->number "7F" 16) 127)
   (test "string->number" (string->number "314t") #f)
   (test "string->number" (string->number #"5") 5)
   (test "string->number" (string->number #"-5") -5)
   (test "string->number" (string->number #"+5") 5)
   (test "string->number" (string->number #"5\n") #f)
   (test "string->number" (string->number #"-5\n") #f)
   (test "string->number" (string->number #"+5\n") #f)
   (test "number->string" (number->string 0 2) "0")
   (test "number->string" (number->string 0 8) "0")
   (test "number->string" (number->string 0 10) "0")
   (test "number->string" (number->string 0 16) "0")
   (test "number->string" (number->string 7 2) "111")
   (test "number->string" (number->string -7 2) "-111")
   (test "number->string" (number->string 8 2) "1000")
   (test "number->string" (number->string -8 2) "-1000")
   (test "number->string" (number->string 9 2) "1001")
   (test "number->string" (number->string -9 2) "-1001")
   (test "number->string" (number->string 127 16) "7f")
   (test "number->string" (number->string -127 16) "-7f")
   (test "number->string" (number->string 127 8) "177")
   (test "number->string" (number->string -127 8) "-177")
   (test "elong.1" (find-runtime-type #e1) "elong")
   (test "elong.2" #e1 #e1)
   (test "elong?.1" (elong? #e1) #t) 
   (test "elong?.2" (elong? #l1) #f)
   (test "elong->string" (elong->string #e1) "1")
   (test "string->elong" (string->elong "1") #e1)
   (test "elong->fixnum" (elong->fixnum #e123456) 123456)
   (test "fixnum->elong" (fixnum->elong 123456) #e123456)
   (test "elong->flonum" (elong->flonum #e123456) 123456.)
   (test "flonum->elong" (flonum->elong 123456.) #e123456)
   (test "llong" (find-runtime-type #l1) "llong")
   (test "llong" #l1 #l1)
   (test "llong?.1" (llong? #l1) #t)
   (test "llong?.2" (llong? #e1) #f)
   (test "llong->string" (llong->string #l1) "1")
   (test "string->llong" (string->llong "1") #l1)
   (test "llong->fixnum" (llong->fixnum #l123456) 123456)
   (test "fixnum->llong" (fixnum->llong 123456) #l123456)
   (test "llong->flonum" (llong->flonum #l123456) 123456.)
   (test "flonum->llong" (flonum->llong 123456.) #l123456)
   (test "integer?.1" (integer? 1) #t)
   (test "integer?.2" (integer? 1.) #t)
   (test "integer?.3" (integer? 1.1) #f)
   (test "fixnum?.1" (fixnum? 1) #t)
   (test "fixnum?.2" (fixnum? 1.) #f)
   (test "fixnum?.3" (fixnum? 1.1) #f)
   (test "Infinity" (flonum? (/fl 1.0 0.0)) #t)
   (test "bit-or" (bit-or 1 2) 3)
   (test "bit-orelong" (bit-orelong #e1 #e2) #e3)
   (test "bit-orllong" (bit-orllong #l1 #l2) #l3)
   (test "bit-and" (bit-and 1 3) 1)
   (test "bit-andelong" (bit-andelong #e1 #e3) #e1)
   (test "bit-andllong" (bit-andllong #l1 #l3) #l1)
   (test "bit-lsh" (bit-lsh 1 3) 8)
   (test "bit-lshelong" (bit-lshelong #e1 3) #e8)
   (test "bit-lshllong" (bit-lshllong #l1 3) #l8)
   (test "bit-rsh" (bit-rsh 8 3) 1)
   (test "bit-rshelong" (bit-rshelong #e8 3) #e1)
   (test "bit-rshllong" (bit-rshllong #l8 3) #l1)
   (test "abs.1" (= (abs 0) 0) #t)
   (test "abs.2" (= (abs 1) 1) #t)
   (test "abs.3" (= (abs -1) 1) #t)
   (test "abs.4" (= (abs -2147483648) 2147483648) #t)
   (test "abs.5" (= (abs 0.0) 0) #t)
   (test "abs.6" (= (abs 1.1) 1.1) #t)
   (test "abs.7" (= (abs -1.1) 1.1) #t)
   (test "abs.8" (= (abs #l0) #l0) #t)
   (test "abs.9" (= (abs #l1) #l1) #t)
   (test "abs.10" (= (abs #l-1) #l1) #t)
   (test "abs.11" (= (abs #l-2147483648) #l2147483648) #t)
   (test "abs.12" (= (abs #e0) #e0) #t)
   (test "abs.13" (= (abs #e1) #e1) #t)
   (test "abs.14" (= (abs #e-1) #e1) #t)
   (test "abs.15" (= (abs (- #e2147483648)) #e2147483648) #t)
   (test "abs.16" (= (abs (- #e9223372036854775808)) #e9223372036854775808) #t))

