;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/output.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jul  5 11:13:01 1992                          */
;*    Last change :  Sun May  1 08:11:59 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.3 Output (page 31, r4)                                      */
;*    -------------------------------------------------------------    */
;*    This module is able to display object even if it is not          */
;*    properly initailzed. This is very important because with this    */
;*    means, error during the initialization time will be correctly    */
;*    prompted. In particular, we must be very carefull not to launch  */
;*    unexpected errors.                                               */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/body.texi@                                */
;*       @node Input And Output@                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_output_6_10_3

   (import  __error
	    __bexit
	    __r4_ports_6_10_1
   	    __bigloo
	    __param)
   
   (use     __type
	    __tvector
	    __structure
	    __bexit
	    __object
	    __ucs2
	    __unicode
	    __date
	    __thread
	     
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_numbers_6_5
	    __r4_characters_6_6
	    __r4_strings_6_7
	    __r4_vectors_6_8
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    __r4_control_features_6_9

	    __evenv)
     
   (extern  (macro output-string-port::bool (::obj)
		   "OUTPUT_STRING_PORTP")
	    (macro $write-char::uchar (::uchar ::output-port)
		   "WRITE_CHAR")
	    (c-write-char::obj (::bchar ::output-port)
			       "write_char")
	    (display-char::obj (::bchar ::output-port)
			       "display_char")
	    (c-write_ucs2::obj (::bucs2 ::output-port)
			       "write_ucs2")
	    (display-ucs2::obj (::bucs2 ::output-port)
			       "display_ucs2")
	    (write-object::obj (::obj ::output-port)
			       "write_object")
	    (write-string::obj (::bstring ::bool ::output-port)
			       "write_string")
	    (display-string::obj (::bstring ::output-port)
				 "display_string")
	    (display-symbol::obj (::symbol ::output-port)
				 "display_symbol")
	    (display-fixnum::obj (::bint ::output-port)
				 "display_fixnum")
	    (display-flonum::obj (::real ::output-port)
				 "display_flonum")
	    (ill-char-rep::obj (::uchar)
			       "ill_char_rep")
	    (write-utf8string::obj (::bstring ::output-port)
				   "write_utf8string")
	    (display-ucs2string::obj (::ucs2string ::output-port)
				     "display_ucs2string")

	    (macro c-current-display::obj ()
		   "BGL_CURRENT_DISPLAY")
	    (macro c-current-display-set!::void (::procedure)
		   "BGL_CURRENT_DISPLAY_SET"))
    
   (java    (class foreign
	       (method static output-string-port::bool (::obj)
		       "OUTPUT_STRING_PORTP")
	       (method static $write-char::uchar (::uchar ::output-port)
		       "WRITE_CHAR")
	       (method static c-write-char::obj (::bchar ::output-port)
		       "write_char")
	       (method static display-char::obj (::bchar ::output-port)
		       "display_char")
	       (method static c-write_ucs2::obj (::bucs2 ::output-port)
		       "write_ucs2")
	       (method static display-ucs2::obj (::bucs2 ::output-port)
		       "display_ucs2")
	       (method static write-object::obj (::obj ::output-port)
		       "write_object")
	       (method static write-string::obj (::bstring ::bool ::output-port)
		       "write_string")
	       (method static display-string::obj (::bstring ::output-port)
		       "display_string")
	       (method static display-symbol::obj (::symbol ::output-port)
		       "display_symbol")
	       (method static display-fixnum::obj (::bint ::output-port)
		       "display_fixnum")
	       (method static display-flonum::obj (::real ::output-port)
		       "display_flonum")
	       (method static ill-char-rep::obj (::uchar)
		       "ill_char_rep")
	       (method static write-utf8string::obj (::bstring ::output-port)
		       "write_utf8string")
	       (method static display-ucs2string::obj (::ucs2string ::output-port)
		       "display_ucs2string")
	       
	       (method static c-current-display::obj ()
		       "BGL_CURRENT_DISPLAY")
	       (method static c-current-display-set!::void (::procedure)
		       "BGL_CURRENT_DISPLAY_SET")))

    
   (export  (newline . port)
	    (inline newline-1 ::output-port)
	    (write obj . port)
	    (write-2 obj ::output-port)
	    (display obj . port)
	    (display-2 obj ::output-port)  
	    (write-char ::uchar . port)
	    (write-symbol ::symbol ::output-port)
	    (inline write-char-2 ::uchar ::output-port)
	    (illegal-char-rep ::uchar) 
	    (display* . obj)
	    (write* . obj)
	    (print . obj)
	    (fprint ::output-port . obj)
	    (format ::bstring . obj)
	    (printf ::bstring . obj)
	    (fprintf ::output-port ::bstring . obj)
	    (set-printer! ::procedure)
	    (current-printer::procedure)
	    (native-printer::procedure))

   (pragma  (output-string-port nesting args-safe)
	    (display-char nesting)
	    ($write-char nesting)))
   
;*---------------------------------------------------------------------*/
;*    newline ...                                                      */
;*---------------------------------------------------------------------*/
(define (newline . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "newline"
			  "wrong number of optional arguments"
			  port)))))
      (newline-1 port)))

;*---------------------------------------------------------------------*/
;*    newline-1 ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (newline-1 port::output-port)
   ($write-char #\Newline port))

;*---------------------------------------------------------------------*/
;*    display ...                                                      */
;*---------------------------------------------------------------------*/
(define (display obj . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "display"
			  "wrong number of optional arguments"
			  port)))))
      (display-2 obj port)))

;*---------------------------------------------------------------------*/
;*    display-2 ...                                                    */
;*---------------------------------------------------------------------*/
(define (display-2 obj port::output-port)
   (let ((disp (c-current-display)))
      (if (or (eq? disp native-display) (not (procedure? disp)))
	  ;; a direct call without try
	  (write/display obj port #t)
	  ;; a protected computed call
	  (with-exception-handler
	     (lambda (err)
		(set-printer! (native-printer))
		(raise err))
	     (lambda ()
		(disp obj port))))))
   
;*---------------------------------------------------------------------*/
;*    native-display ...                                               */
;*---------------------------------------------------------------------*/
(define (native-display obj port)
   (write/display obj port #t))

;*---------------------------------------------------------------------*/
;*    write ...                                                        */
;*---------------------------------------------------------------------*/
(define (write obj . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "write"
			  "wrong number of optional arguments"
			  port)))))
      (write-2 obj port)))

;*---------------------------------------------------------------------*/
;*    write-2 ...                                                      */
;*---------------------------------------------------------------------*/
(define (write-2 obj port::output-port)
   (write/display obj port #f))

;*---------------------------------------------------------------------*/
;*    write-char ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-char char . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "write"
			  "wrong number of optional arguments"
			  port)))))
      (write-char-2 char port)))

;*---------------------------------------------------------------------*/
;*    write-char-2 ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (write-char-2 char::uchar port::output-port)
   ($write-char char port))

;*---------------------------------------------------------------------*/
;*    illegal-char-rep ...                                             */
;*---------------------------------------------------------------------*/
(define (illegal-char-rep char)
   (if (or (char-alphabetic? char) (char-numeric? char))
       char
       (case char
	  ((#\Newline)
	   "#\Newline")
	  ((#\Return)
	   "#\Return")
	  ((#\Space)
	   "#\Space")
	  ((#\Tab)
	   "#\Tab")
	  (else
	   (let ((i (char->integer char)))
	      (if (<fx i (char->integer #\!))
		  (ill-char-rep char)
		  char))))))

;*---------------------------------------------------------------------*/
;*    write/display ...                                                */
;*    -------------------------------------------------------------    */
;*    As we can't be sure that this module is initialized before       */
;*    used (for example when an error occurs during module             */
;*    intialization process), we can't use symbol to set               */
;*    flag. So if flag is equal to #t it means that                    */
;*    `write-display' is used to display and if flags is equal         */
;*    to #f it writes.                                                 */
;*---------------------------------------------------------------------*/
(define (write/display obj port flag)
   (cond
      ((fixnum? obj)
       (display-fixnum obj port))
      ((symbol? obj) 
       (if flag
	   (display-symbol obj port)
	   (write-symbol obj port)))
      ((string? obj) 
       (if flag
	   (display-string obj port)
	   (write-string (string-for-read obj)
			 (bigloo-strict-r5rs-strings)
			 port)))
      ((pair? obj)
       (write/display-pair obj port flag))
      ((class? obj)
       (write/display-class obj port flag))
      ((vector? obj)
       (write/display-vector obj port flag))
      ((char? obj)
       (if flag 
	   ($write-char obj port)
	   (c-write-char obj port)))
      ((flonum? obj)
       (display-flonum obj port))
      ((cell? obj)
       (write/display-cell obj port flag))
      ((struct? obj)
       (write/display-structure obj port flag))
      ((object? obj)
       (write/display-object obj port flag))
      ((date? obj)
       (if flag
	   (display-string (date->string obj) port)
	   (begin
 	      (display-string "#<date:" port)
	      (display-string (date->string obj) port)
	      (display-string ">" port))))
      ((mutex? obj)
       (display-string "#<mutex:" port)
       (display (mutex-name obj) port)
       (display-string ">" port))
      ((condition-variable? obj)
       (display-string "#<condition-variable:" port)
       (display (condition-variable-name obj) port)
       (display-string ">" port))
      ((ucs2-string? obj)
       (if flag
	   (display-ucs2string obj port) 
	   (write-utf8string (string-for-read (ucs2-string->utf8-string obj))
			     port)))
      ((tvector? obj)
       (write/display-tvector obj port flag))
      ((ucs2? obj)
       (if flag 
	   (display-ucs2 obj port)
	   (c-write_ucs2 obj port)))
      ((opaque? obj)
       (display-string "#<opaque>" port))
      (else
       (write-object obj port)))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    write-symbol ...                                                 */
;*---------------------------------------------------------------------*/
(define (write-symbol obj port)
   (let* ((str (symbol->string obj))
	  (len (string-length str)))
      (define (wrt)
	 (display-string "|" port)
	 (display-string str port)
	 (display-string "|" port))
      (let loop ((i 0))
	 (if (=fx i len)
	     (display-string str port)
	     (let ((c (string-ref str i)))
		(case c
		   ((#\Space #\Newline #\Tab #\Return #\' #\" #\# #\\)
		    (wrt))
		   (else
		    (if (char>=? c #a127)
			(wrt)
			(loop (+fx i 1))))))))))

;*---------------------------------------------------------------------*/
;*    write/display-class ...                                          */
;*---------------------------------------------------------------------*/
(define (write/display-class obj port flag)
   (display-string "#<class:" port)
   (display-symbol (class-name obj) port)
   (display-string ">" port))
   
;*---------------------------------------------------------------------*/
;*    write/display-cell ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-cell obj port flag)
   (display-string "#<cell:" port)
   (write/display (cell-ref obj) port flag)
   (display-string ">" port))

;*---------------------------------------------------------------------*/
;*    write/display-structure ...                                      */
;*---------------------------------------------------------------------*/
(define (write/display-structure obj port flag)
   ($write-char #\# port)
   ($write-char #\{ port)
   (write-object (struct-key obj) port)
   (if (=fx 0 (struct-length obj))
       ($write-char #\} port)
       (let ((len (-fx (struct-length obj) 1)))
	  ($write-char #\space port)
	  (let loop ((i 0))
	     (cond
		((=fx i len)
		 (write/display (struct-ref obj i) port flag)
		 ($write-char #\} port))
		(else
		 (write/display (struct-ref obj i) port flag)
		 ($write-char #\space port)
		 (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write/display-vector ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-vector obj port flag)
   ($write-char #\# port)
   (let ((tag (vector-tag obj)))
      (if (>fx tag 0)
	  (begin
	     (if (>=fx tag 100)
		 (write-object tag port)
		 (begin
		    ($write-char #\0 port)
		    (if (>=fx tag 10)
			(write-object tag port)
			(begin
			   ($write-char #\0 port)
			   (write-object tag port))))))))
   ($write-char #\( port)
   (if (=fx 0 (vector-length obj))
       ($write-char #\) port)
       (let ((len (-fx (vector-length obj) 1)))
	  (let loop ((i 0))
	     (cond
		((=fx i len)
		 (write/display (vector-ref obj i) port flag)
		 ($write-char #\) port))
		(else
		 (write/display (vector-ref obj i) port flag)
		 ($write-char #\space port)
		 (loop (+fx 1 i))))))))
 
;*---------------------------------------------------------------------*/
;*    write/display-tvector ...                                        */
;*---------------------------------------------------------------------*/
(define (write/display-tvector tvec port flag)
   (let ((tvector-ref (tvector-ref tvec))
	 (id          (tvector-id tvec)))
      ($write-char #\# port)
      (write-object id port)
      ($write-char #\( port)
      (if (not tvector-ref)
	  (begin
	     (write-object "...)" port)
	     tvec)
	  (begin
	     (if (=fx 0 (tvector-length tvec))
		 ($write-char #\) port)
		 (let ((len (-fx (tvector-length tvec) 1)))
		    (let loop ((i 0))
		       (cond
			  ((=fx i len)
			   (write/display (tvector-ref tvec i)
					  port
					  flag)
			   ($write-char #\) port))
			  (else
			   (write/display (tvector-ref tvec i)
					  port
					  flag)
			   ($write-char #\space port)
			   (loop (+fx 1 i)))))))))))

;*---------------------------------------------------------------------*/
;*    write/display-object ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-object obj port flag)
   (if flag
       (object-display obj port)
       (object-write obj port)))

;*---------------------------------------------------------------------*/
;*    write/display-pair ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-pair obj port flag)
   ($write-char #\( port)
   (let loop ((l obj))
      (cond
	 ((null? (cdr l))
	  (write/display (car l) port flag)
	  ($write-char #\) port))
	 ((not (pair? (cdr l)))
	  (write/display (car l) port flag)
	  ($write-char #\space port)
	  ($write-char #\. port)
	  ($write-char #\space port)
	  (write/display (cdr l) port flag)
	  ($write-char #\) port))
	 (else
	  (write/display (car l) port flag)
	  ($write-char #\space port)
	  (loop (cdr l))))))
 
;*---------------------------------------------------------------------*/
;*    print ...                                                        */
;*---------------------------------------------------------------------*/
(define (print . obj)
   (let ((port (current-output-port)))
      (let loop ((l   obj)
		 (res '()))
	 (if (null? l)
	     (begin
		($write-char #\Newline port)
		res)
	     (let ((v (car l)))
		(write/display v port #t)
		(loop (cdr l) v))))))

;*---------------------------------------------------------------------*/
;*    display* ...                                                     */
;*---------------------------------------------------------------------*/
(define (display* . obj)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(display (car l) port)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    write* ...                                                       */
;*---------------------------------------------------------------------*/
(define (write* . obj)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(write/display (car l) port #f)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    fprint ...                                                       */
;*---------------------------------------------------------------------*/
(define (fprint port . obj)
   (let loop ((l    obj)
	      (res '()))
      (if (null? l)
	  (begin
	     ($write-char #\Newline port)
	     res)
	  (let ((v (car l)))
	     (write/display (car l) port #t)
	     (loop (cdr l) v)))))

;*---------------------------------------------------------------------*/
;*    xprintf ...                                                      */
;*---------------------------------------------------------------------*/
(define (xprintf procname p::output-port fmt::bstring objs::pair-nil)
   (let ((len (string-length fmt)))
      (let loop ((i 0)
		 (os objs))
	 (define (next os fmt)
	    (if (null? os)
		(error procname "Insufficient number of arguments" fmt)
		(car os)))
	 (define (print-radix radix num)
	    (if (not (number? num))
		(error procname "Illegal number" num)
		(display (number->string num radix) p)))
	 (if (<fx i len)
	     (let ((c (string-ref fmt i)))
		(if (char=? c #\~)
		    (if (=fx i (-fx len 1))
			(error procname
			       "Tag not allowd here"
			       (substring fmt i len))
			(let ((f (string-ref fmt (+fx i 1))))
			   (case f
			      ((#\a #\A)
			       (display (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\s #\S)
			       (write (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\v #\V)
			       (display (next os f) p)
			       (newline p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\c #\C)
			       (let ((o (next os f)))
				  (if (not (char? o))
				      (error procname "Illegal char" o)
				      (begin
					 (write-char o p)
					 (loop (+fx i 2) (cdr os))))))
			      ((#\x #\X)
			       (print-radix 16 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\o #\O)
			       (print-radix 8 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\b #\B)
			       (print-radix 2 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\% #\n)
			       (newline p)
			       (loop (+fx i 2) os))
			      ((#\r)
			       (write-char #\return p)
			       (loop (+fx i 2) os))
			      ((#\~)
			       (write-char #\~ p)
			       (loop (+fx i 2) os))
			      (else
			       (error procname "Illegal tag" f)))))
		    (begin
		       (write-char c p)
		       (loop (+fx i 1) os))))))))
			 
;*---------------------------------------------------------------------*/
;*    format ...                                                       */
;*---------------------------------------------------------------------*/
(define (format fmt . obj)
   (let ((p (open-output-string)))
      (xprintf 'format p fmt obj)
      (close-output-port p)))

;*---------------------------------------------------------------------*/
;*    printf ...                                                       */
;*---------------------------------------------------------------------*/
(define (printf fmt . obj)
   (xprintf 'printf (current-output-port) fmt obj))

;*---------------------------------------------------------------------*/
;*    fprintf ...                                                      */
;*---------------------------------------------------------------------*/
(define (fprintf port fmt . obj)
   (xprintf 'fprintf port fmt obj))

;*---------------------------------------------------------------------*/
;*    set-printer! ...                                                 */
;*---------------------------------------------------------------------*/
(define (set-printer! f)
   (cond
      ((not (procedure? f))
       (error 'set-printer! "Illegal procedure" f))
      ((not (correct-arity? f 2))
       (error 'set-printer! "Illegal procedure arity" f))
      (else
       (begin (c-current-display-set! f) f))))

;*---------------------------------------------------------------------*/
;*    current-printer ...                                              */
;*---------------------------------------------------------------------*/
(define (current-printer)
   (let ((f (c-current-display)))
      (if (not (procedure? f))
	  native-display
	  f)))

;*---------------------------------------------------------------------*/
;*    native-printer ...                                               */
;*---------------------------------------------------------------------*/
(define (native-printer)
   native-display)


