/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/dlopen.java             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Dec 11 15:42:09 2000                          */
/*    Last change :  Fri Jul  6 15:13:53 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Dynamic class loading for the Jvm back-end.                      */
/*=====================================================================*/
package bigloo;

import java.lang.*;
import java.io.*;
import java.util.*;
import java.lang.reflect.*;

/*---------------------------------------------------------------------*/
/*    dlopen ...                                                       */
/*---------------------------------------------------------------------*/
public abstract class dlopen
{
  private static final String NO_ERROR_YET= "No error (yet)";

  private static String bgl_dload_error= NO_ERROR_YET;

  static String suffix( final byte[]  filename )
  {
    final int      len= filename.length;
    int            i;

    for ( i= len-1 ; (0 <= i) && (filename[i] != '.') ; --i )
      ;

    if (0 <= i)
      return new String( filename, 0, i );
    else
      return new String( filename );
  }

  public static int dload( final byte[]  filename,
                           final byte[]  init_sym )
  {
    bgl_dload_error= NO_ERROR_YET;

    try
    {
      final Class       new_class= Class.forName( suffix( filename ) );
      final Method      init= new_class.getDeclaredMethod( new String( init_sym ),
                                                           null );

      init.invoke( null, null );
      return 0;
    }
    catch (final Exception e)
    {
      bgl_dload_error= e.toString();
      return  1;
    }
  }

  public static byte[] dload_error()
  {
    return bgl_dload_error.getBytes();
  }
}