;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/thread.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Oct  8 05:19:50 2004                          */
;*    Last change :  Tue Jun  7 05:26:50 2005 (serrano)                */
;*    Copyright   :  2004-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    Not an implementation of threads (see Fthread for instance).     */
;*    This is simply an implementation of lock and synchronization     */
;*    mechanism.                                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __thread
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __bexit
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_vectors_6_8
	    __r4_control_features_6_9
	    __r4_pairs_and_lists_6_3
	    __r4_characters_6_6
	    __r4_equivalence_6_2 
	    __r4_strings_6_7
	    __r4_ports_6_10_1
	    __foreign
	    __evenv)
   
   (extern  (macro $mutex?::bool (::obj)
		   "BGL_MUTEXP")
	    (macro $make-mutex::mutex (::obj)
		   "bgl_make_mutex")
	    ($make-nil-mutex::mutex () "bgl_make_nil_mutex")
	    (macro $mutex-name::obj (::mutex)
		   "BGL_MUTEX_NAME")
	    (macro $mutex-lock::bool (::mutex)
		   "bgl_mutex_lock")
	    (macro $mutex-timed-lock::bool (::mutex ::long)
		   "bgl_mutex_timed_lock")
	    (macro $mutex-unlock::bool (::mutex)
		   "bgl_mutex_unlock")
	    
	    (macro $condvar?::bool (::obj)
		   "BGL_CONDVARP")
	    (macro $make-condvar::condvar (::obj)
		   "bgl_make_condvar")
	    ($make-nil-condvar::condvar () "bgl_make_nil_condvar")
	    (macro $condvar-name::obj (::condvar)
		   "BGL_CONDVAR_NAME")
	    (macro $condvar-wait!::bool (::condvar ::mutex)
		   "bgl_condvar_wait")
	    (macro $condvar-timed-wait!::bool (::condvar ::mutex ::long)
		   "bgl_condvar_timed_wait")
	    (macro $condvar-broadcast!::bool (::condvar)
		   "bgl_condvar_broadcast")
	    (macro $condvar-signal!::bool (::condvar)
		   "bgl_condvar_signal"))
	    
   (java    (class foreign
	       (method static $mutex?::bool (::obj)
		       "BGL_MUTEXP")
	       (method static $make-mutex::mutex (::obj)
		       "bgl_make_mutex")
	       (method static $make-nil-mutex::mutex ()
		       "bgl_make_nil_mutex")
	       (method static $mutex-name::obj (::mutex)
		       "BGL_MUTEX_NAME")
	       (method static $mutex-lock::bool (::mutex)
		       "bgl_mutex_lock")
	       (method static $mutex-timed-lock::bool (::mutex ::long)
		       "bgl_mutex_timed_lock")
	       (method static $mutex-unlock::bool (::mutex)
		       "bgl_mutex_unlock")
	       
	       (method static $condvar?::bool (::obj)
		       "BGL_CONDVARP")
	       (method static $make-condvar::condvar (::obj)
		       "bgl_make_condvar")
	       (method static $make-nil-condvar::condvar ()
		       "bgl_make_nil_condvar")
	       (method static $condvar-name::obj (::condvar)
		       "BGL_CONDVAR_NAME")
	       (method static $condvar-wait!::bool (::condvar ::mutex)
		       "bgl_condvar_wait")
	       (method static $condvar-timed-wait!::bool (::condvar ::mutex ::int)
		       "bgl_condvar_timed_wait")
	       (method static $condvar-broadcast!::bool (::condvar)
		       "bgl_condvar_broadcast")
	       (method static $condvar-signal!::bool (::condvar)
		       "bgl_condvar_signal")))

   (export  (inline mutex?::bool ::obj)
	    (inline make-mutex::mutex . ::obj)
	    (mutex-nil::mutex)
	    (inline mutex-name::obj ::mutex)
	    (inline mutex-lock!::obj ::mutex . ::obj)
	    (inline mutex-unlock!::obj ::mutex)
	    (inline with-lock ::mutex ::procedure)
	    
	    (inline condition-variable?::bool ::obj)
	    (inline make-condition-variable::condvar . ::obj)
	    (condition-variable-nil::condvar)
	    (inline condition-variable-name::obj ::condvar)
	    (inline condition-variable-wait!::bool ::condvar ::mutex . ::obj)
	    (inline condition-variable-signal!::bool ::condvar)
	    (inline condition-variable-broadcast!::bool ::condvar)))

;*---------------------------------------------------------------------*/
;*    mutex? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (mutex? obj)
   ($mutex? obj))

;*---------------------------------------------------------------------*/
;*    make-mutex ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (make-mutex . obj)
   ($make-mutex (if (pair? obj) (car obj) (gensym 'mutex))))

;*---------------------------------------------------------------------*/
;*    mutex-nil ...                                                    */
;*---------------------------------------------------------------------*/
(define *mutex-nil* ($make-nil-mutex))
(define (mutex-nil) *mutex-nil*)

;*---------------------------------------------------------------------*/
;*    mutex-name ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (mutex-name obj)
   ($mutex-name obj))

;*---------------------------------------------------------------------*/
;*    mutex-lock! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (mutex-lock! m . ms)
   (cond
      ((null? ms)
       ($mutex-lock m))
      ((not (null? (cdr ms)))
       (error 'mutex-lock! "Illegal optional argument" ms))
      (else
       ($mutex-timed-lock m (car ms)))))

;*---------------------------------------------------------------------*/
;*    mutex-unlock! ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (mutex-unlock! m)
   ($mutex-unlock m))

;*---------------------------------------------------------------------*/
;*    with-lock ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (with-lock mutex thunk)
   (mutex-lock! mutex)
   (unwind-protect
      (thunk)
      (mutex-unlock! mutex)))
	 
;*---------------------------------------------------------------------*/
;*    condition-variable? ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (condition-variable? obj)
   ($condvar? obj))

;*---------------------------------------------------------------------*/
;*    make-condition-variable ...                                      */
;*---------------------------------------------------------------------*/
(define-inline (make-condition-variable . obj)
   ($make-condvar (if (pair? obj) (car obj) (gensym 'condition-variable))))

;*---------------------------------------------------------------------*/
;*    condition-variable-nil ...                                       */
;*---------------------------------------------------------------------*/
(define *condition-variable-nil* ($make-nil-condvar))
(define (condition-variable-nil) *condition-variable-nil*)

;*---------------------------------------------------------------------*/
;*    condition-variable-name ...                                      */
;*---------------------------------------------------------------------*/
(define-inline (condition-variable-name obj)
   ($condvar-name obj))

;*---------------------------------------------------------------------*/
;*    condition-variable-wait! ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (condition-variable-wait! c m . ms)
   (cond
      ((null? ms)
       ($condvar-wait! c m))
      ((not (null? (cdr ms)))
       (error 'condition-variable-wait! "Illegal optional argument" ms))
      (else
       ($condvar-timed-wait! c m (car ms)))))

;*---------------------------------------------------------------------*/
;*    condition-variable-signal! ...                                   */
;*---------------------------------------------------------------------*/
(define-inline (condition-variable-signal! c)
   ($condvar-signal! c))

;*---------------------------------------------------------------------*/
;*    condition-variable-broadcast! ...                                */
;*---------------------------------------------------------------------*/
(define-inline (condition-variable-broadcast! c)
   ($condvar-broadcast! c))
