;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/BackEnd/c.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Aug  4 14:10:06 2003                          */
;*    Last change :  Wed Nov  9 15:13:29 2005 (serrano)                */
;*    Copyright   :  2003-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The C back-end                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module backend_c
   
   (include "Engine/pass.sch"
	    "Ast/unit.sch"
	    "Tools/trace.sch")
   
   (import  tools_shape
	    tools_error
	    engine_param
	    engine_configure
	    engine_compiler
	    engine_link
	    module_module
	    module_library
	    module_alibrary
	    type_type
	    ast_var
	    ast_node
	    ast_occur
	    ast_build
	    object_class
	    bdb_emit
	    bdb_setting
	    prof_emit
	    backend_backend
	    backend_init
	    backend_cvm
	    backend_c_emit
	    backend_c_prototype
	    backend_c_main
	    cc_indent
	    cc_cc
	    cc_ld
	    init_setrc
	    read_reader)

   (with    cgen_compile
	    saw_c_compile)

   (export  (build-sawc-backend)
	    (build-cgen-backend)
	    (cc-compiler ::bstring ::obj)))

;*---------------------------------------------------------------------*/
;*    registerd backends ...                                           */
;*---------------------------------------------------------------------*/
(register-backend! 'c build-cgen-backend)
(register-backend! 'c-saw build-sawc-backend)

;*---------------------------------------------------------------------*/
;*    build-sawc-backend ...                                           */
;*---------------------------------------------------------------------*/
(define (build-sawc-backend)
   (instantiate::sawc
      (language 'c-saw)
      (heap-compatible 'c)
      (srfi0 'bigloo-c)
      (require-tailc #t)))
 
;*---------------------------------------------------------------------*/
;*    build-cgen-backend ...                                           */
;*---------------------------------------------------------------------*/
(define (build-cgen-backend)
   (instantiate::cgen
      (language 'c)
      (srfi0 'bigloo-c)))

;*---------------------------------------------------------------------*/
;*    backend-compile ...                                              */
;*---------------------------------------------------------------------*/
(define-method (backend-compile me::cvm)
   (let ((c-prefix (profile cgen (c-walk me))))
      (stop-on-pass 'cgen (lambda () 'done))
      (stop-on-pass 'distrib (lambda () 'done))
      (when (string? c-prefix)
	 (when (or (eq? *pass* 'cindent) *c-debug*) (indent c-prefix))
	 (stop-on-pass 'cindent (lambda () 'done)))
      c-prefix))

;*---------------------------------------------------------------------*/
;*    backend-link ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (backend-link me::cvm result)
   (if (string? result)
       (cc-compiler result #f)))

;*---------------------------------------------------------------------*/
;*    c-walk ...                                                       */
;*---------------------------------------------------------------------*/
(define (c-walk me::cvm)
   (pass-prelude (if (sawc? me) "C generation (saw)" "C generation (cgen)")
		 (lambda () (start-emission! ".c")))
   
   ;; a very little comment 
   (emit-header)
   
   ;; emit the GC selection
   (emit-garbage-collector-selection)
   
   ;; if we are in debugging mode, we generate a macro
   (if (or (>fx *compiler-debug* 0) *c-debug*)
       (emit-debug-activation))
   
   ;; the include (both Bigloo's and user's ones)
   (emit-include)

   ;; C++ guard start
   (fprint *c-port* "#ifdef __cplusplus")
   (fprint *c-port* "extern \"C\" {")
   (fprint *c-port* "#endif")

   ;; we emit the generated type for the classes
   (emit-class-types *c-port*)
   
   ;; we declare prototypes
   ;; first, we print the prototype of variables
   (emit-prototypes)
   
   ;; then we emit the constants values
   (emit-cnsts)
   
   (let ((globals (cvm-functions me)))
      
      ;; when compiling in bdb mode we have to emit the identifier
      ;; translation table.
      (if (>fx *bdb-debug* 0)
	  (emit-bdb-info globals *c-port*))
      
      ;; when compiling for profile we emit identifier translation table
      (if (>fx *profile-mode* 0)
	  (emit-prof-info globals *c-port*))
      
      ;; we print the C main...
      (if (and (or *main* (memq *pass* '(ld distrib)))
	       (not (eq? *main* 'imported)))
	  (emit-main))
      
      ;; we emit the dynamic loading init point
      (let ((mod-init (get-module-init)))
	 (if (and (bigloo-config 'have-dlopen)
		  *dlopen-init*
		  (global? mod-init))
	     (emit-dlopen-init mod-init)))
      
      ;; we now emit the code for all the Scheme functions
      (backend-compile-functions me)

      ;; C++ guard end
      (fprint *c-port* "#ifdef __cplusplus")
      (fprint *c-port* "}")
      (fprint *c-port* "#endif")
      
      (stop-emission!)))

;*---------------------------------------------------------------------*/
;*    cc-compiler ...                                                  */
;*---------------------------------------------------------------------*/
(define (cc-compiler c-prefix o-prefix)
   ;; we invoke now the C compiler
   (cc c-prefix o-prefix (not (eq? *pass* 'cc)))
   (stop-on-pass 'cc (lambda () 'done))
   ;; and the linker
   (ld (if (string? o-prefix) o-prefix c-prefix) #f))

;*---------------------------------------------------------------------*/
;*    backend-cnst-table-name ::cvm                                    */
;*---------------------------------------------------------------------*/
(define-method (backend-cnst-table-name me::cvm offset)
   (if (=fx offset 0)
       "*__cnst"
       (string-append "__cnst[ " (number->string offset) " ] ")))

;*---------------------------------------------------------------------*/
;*    make-tmp-file-name ...                                           */
;*---------------------------------------------------------------------*/
(define (make-tmp-file-name)
   (make-file-name *bigloo-tmp*
		   (string-append "main-tmp"
				  "@"
				  (let ((user (getenv "USER")))
				     (if (not (string? user))
					 ""
					 user))
				  "."
				  (car *src-suffix*))))

;*---------------------------------------------------------------------*/
;*    backend-link-objects ::cvm ...                                   */
;*---------------------------------------------------------------------*/
(define-method (backend-link-objects me::cvm sources)
   (when (>fx *bdb-debug* 0) (bdb-setting!))
   (if (null? sources)
       (let ((first (prefix (car *o-files*))))
	  (warning "link" "No source file found" " -- " *o-files*)
	  (load-library-init)
	  (set! *o-files* (cdr *o-files*))
	  (ld first #f))
       (let loop ((sources sources)
		  (cls '())
		  (main #f)
		  (fmain "")
		  (libraries '()))
	  (if (null? sources)
	      (if main
		  (let ((first (prefix (car *o-files*))))
		     ;; if libraries are used by some module we add them
		     ;; to the link
		     (for-each (lambda (lib)
				  (use-library! lib 'now))
			       libraries)
		     ;; we load the library init files.
		     (load-library-init)
		     (set! *src-files* (list fmain))
		     (set! *o-files* (cdr *o-files*))
		     (ld first #f))
		  ;; let's generate a main, then link
		  (let ((tmp (make-tmp-file-name)))
		     (make-tmp-main tmp main (gensym 'module) cls libraries)
		     (set! *src-files* (list tmp))
		     ;; we have to remove extra mco files before compiler
		     ;; otherwise the compiler will warn about that files.
		     (let loop ((ra  *rest-args*)
				(res '()))
			(cond
			   ((null? ra)
			    (set! *rest-args* (reverse! res)))
			   ((member (suffix (car ra)) *mco-suffix*)
			    (loop (cdr ra) res))
			   (else
			    (loop (cdr ra) (cons (car ra) res)))))
		     (unwind-protect
			(compiler)
			;; we load the library init files.
			(load-library-init)
			(let* ((pre (prefix tmp))
			       (c-file (string-append pre ".c"))
			       (o-file (string-append
					pre
					"."
					*c-object-file-extension*)))
			   (for-each (lambda (f)
					(if (file-exists? f)
					    (delete-file f)))
				     (list tmp c-file o-file))))
		     0))
	      (let ((port (open-input-file (caar sources))))
		 (if (not (input-port? port))
		     (error "" "Illegal file" (caar sources))
		     (let ((exp (compiler-read port)))
			(close-input-port port)
			(match-case exp
			   ((module ?name ??- (main ?new-main) . ?-)
			    (if main
				(error ""
				       (string-append
					"Redeclaration of the main (files "
					fmain
					" and "
					(caar sources) ")")
				       (cons main new-main)))
			    (loop (cdr sources)
				  (cons (list name
					      (string-append
					       "\"" (caar sources) "\""))
					cls)
				  new-main
				  (caar sources)
				  (append (find-libraries (cddr exp))
					  libraries)))
			   ((module ?name . ?-)
			    (loop (cdr sources)
				  (cons (list name
					      (string-append
					       "\"" (caar sources) "\""))
					cls)
				  main
				  fmain
				  (append (find-libraries (cddr exp))
					  libraries)))
			   (else
			    (loop (cdr sources)
				  cls
				  main
				  fmain
				  libraries))))))))))
