;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/alibrary.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Feb 28 10:20:55 1998                          */
;*    Last change :  Wed Nov  9 13:47:25 2005 (serrano)                */
;*    Copyright   :  1998-2005 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The compiler library clause compilation                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_alibrary
   (include "Ast/unit.sch")
   (import  module_module
	    tools_error
	    engine_param
	    expand_srfi-0
	    backend_backend
	    (setup-library-values init_setrc))
   (export  (make-alibrary-compiler)
	    (use-library! library::symbol mode)))

;*---------------------------------------------------------------------*/
;*    use-library! ...                                                 */
;*---------------------------------------------------------------------*/
(define (use-library! library mode)
   (if (not (member library *additional-bigloo-libraries*))
       (begin
	  (set! *additional-bigloo-libraries*
		(cons library *additional-bigloo-libraries*))
	  (let ((heap-name (symbol->string library)))
	     (add-supported-srfi! library)
	     (add-supported-srfi! (string->symbol (string-upcase heap-name)))
	     ;; when use-library is called from the argument parsing we have
	     ;; to delay the library initialization until all arguments have
	     ;; been parsed. In consequence setup-library-values is called
	     ;; only when use-library is not called from argument parsing
	     ;; (which is denotes by the 'now mode value)
	     (if (eq? mode 'now) (setup-library-values library))
	     (set! *additional-heap-names*
		   (cons heap-name *additional-heap-names*))
	     library))))

;*---------------------------------------------------------------------*/
;*    make-alibrary-compiler ...                                       */
;*---------------------------------------------------------------------*/
(define (make-alibrary-compiler)
   (instantiate::ccomp
      (id 'library)
      (producer alibrary-producer)))

;*---------------------------------------------------------------------*/
;*    alibrary-producer ...                                            */
;*---------------------------------------------------------------------*/
(define (alibrary-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (x) (use-library! x 'now)) protos)
       '())
      (else
       (user-error "Parse error" "Illegal `library' clause" clause '()))))
       
