/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cwriter.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 17 09:44:20 1991                          */
/*    Last change :  Sat Oct 22 07:49:21 2005 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Object (that have to be non recursives) printing.                */
/*=====================================================================*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t c_constant_string_to_string( char *c_string );
extern obj_t llong_to_string( BGL_LONGLONG_T x, long radix );
extern obj_t bgl_write_obj( obj_t, obj_t );
extern obj_t bgl_display_obj( obj_t, obj_t );

/*---------------------------------------------------------------------*/
/*    Les noms des caracateres                                         */
/*---------------------------------------------------------------------*/
static char *char_name[] = {
   "","","","","","","","",
   "",  "tab", "newline", "", "", "return", "", "",
   "", "","","","","","","",
   "", "", "","","", "", "", "",
   "space", "!", "\"","#","$","%","&","'",
   "(", ")", "*", "+", ",", "-", ".", "/",
   "0", "1", "2", "3", "4", "5", "6", "7",
   "8", "9", ":", ";", "<", "=", ">", "?",
   "@", "A", "B", "C", "D", "E", "F", "G",
   "H", "I", "J", "K", "L", "M", "N", "O",
   "P", "Q", "R", "S", "T", "U", "V", "W",
   "X", "Y", "Z", "[", "\\", "]", "^", "_",
   "`", "a", "b", "c", "d", "e", "f", "g",
   "h", "i", "j", "k", "l", "m", "n", "o",
   "p", "q", "r", "s", "t", "u", "v", "w",
   "x", "y", "z", "{", "|", "}", "~", ""
};

/*---------------------------------------------------------------------*/
/*    PUTC ...                                                         */
/*---------------------------------------------------------------------*/
#define PUTC( port, c, s ) \
  ( OUTPUT_PORT( port ).sysputc( (c), (s) ) )

/*---------------------------------------------------------------------*/
/*    PUTS ...                                                         */
/*---------------------------------------------------------------------*/
#define PUTS( port, str, stream ) \
  OUTPUT_PORT( port ).syswrite( str, 1, sizeof( str ) - 1, ostream )
  
/*---------------------------------------------------------------------*/
/*    PRINTF1 ...                                                      */
/*---------------------------------------------------------------------*/
#define PRINTF1( port, bufsize, ostream, fmt, arg0 ) \
  if( OUTPUT_PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( ostream, fmt, arg0 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), ostream ); \
  }

#ifdef __GNUC__
#  define PRINTF1V( port, bufsize, ostream, fmt, arg0 ) \
  if( OUTPUT_PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( ostream, fmt, arg0 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), ostream ); \
  }
#  else
#  define PRINTF1V( port, bufsize, ostream, fmt, arg0 ) \
  if( OUTPUT_PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( ostream, fmt, arg0 ); \
  } else { \
    char *__buf = alloca( bufsize ); \
    sprintf( __buf, fmt, arg0 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), ostream ); \
  }
#endif

/*---------------------------------------------------------------------*/
/*    PRINTF2 ...                                                      */
/*---------------------------------------------------------------------*/
#define PRINTF2( port, bufsize, stream, fmt, arg0, arg1 ) \
  if( OUTPUT_PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( stream, fmt, arg0, arg1 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0, arg1 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), ostream ); \
  }

#ifdef __GNUC__
#  define PRINTF2V( port, bufsize, stream, fmt, arg0, arg1 ) \
  if( OUTPUT_PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( stream, fmt, arg0, arg1 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0, arg1 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), ostream ); \
  }
#  else
#  define PRINTF2V( port, bufsize, stream, fmt, arg0, arg1 ) \
  if( OUTPUT_PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( stream, fmt, arg0, arg1 ); \
  } else { \
    char *__buf = (char *)alloca( bufsize ); \
    sprintf( __buf, fmt, arg0, arg1 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), ostream ); \
  }
#endif

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_string ...                                           */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_display_string( obj_t o, obj_t port ) {
   long len = STRING_LENGTH( o );
   void *ostream = OUTPUT_PORT( port ).ostream;
   unsigned char *str = &STRING_REF( o, 0 );

   int n = OUTPUT_PORT( port ).syswrite( str, 1, len, ostream );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_string ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_string( obj_t o, bool_t esc, obj_t port ) {
   char *str = (char *)BSTRING_TO_STRING( o );
   long len  = STRING_LENGTH( o );
   void *ostream = OUTPUT_PORT( port ).ostream;

   if( esc ) PUTC( port, '#', ostream );
   
   PUTC( port, '"', ostream );
   OUTPUT_PORT( port ).syswrite( str, 1, len, ostream );
   PUTC( port, '"', ostream );

   return port;
}


/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_fixnum ...                                           */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_display_fixnum( obj_t o, obj_t port ) {
   PRINTF1( port, 32, OUTPUT_PORT( port ).ostream, "%ld", CINT( o ) );
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_elong ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_elong( long o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;

   PRINTF1( port, 32, ostream, "%ld", o );
   
   return port;
}
 
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_elong ...                                              */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_elong( long o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;

   PRINTF1( port, 32, ostream, "#e%ld", o );
   
   return port;
}
 
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_llong ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_llong( BGL_LONGLONG_T o, obj_t port ) {
   bgl_display_string( llong_to_string( o, 10 ), port );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_llong ...                                              */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_llong( BGL_LONGLONG_T o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PUTS( port, "#l", ostream );
   bgl_display_string( llong_to_string( o, 10 ), port );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_char ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_char( obj_t o, obj_t port ) {
   int c = CCHAR( o );
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   if( (c > 0) && (c < 128) && char_name[ c ][ 0 ] ) {
      char *name = char_name[ c ];
	 
      PUTC( port, '#', ostream );
      PUTC( port, '\\', ostream );
      OUTPUT_PORT( port ).syswrite( name, 1, strlen( name ), ostream );
   } else {
      PUTC( port, '#', ostream );
      PUTC( port, 'a', ostream );

      PRINTF1( port, 4, ostream, "%03d", (unsigned char)(c) );
   }
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_ucs2 ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_ucs2( obj_t o, obj_t port ) {
   PRINTF1( port, 7, OUTPUT_PORT( port ).ostream, "#u%04x", CUCS2( o ) );
   
   return port;
}   

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_ucs2 ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_ucs2( obj_t o, obj_t port ) {
   ucs2_t ch = CUCS2( o );
   
   if( UCS2_ISOLATIN1P( ch ) ) {
      BGL_DISPLAY_CHAR( (obj_t)BCHAR( ch ), port );
      return port;
   } else
      return bgl_write_ucs2( o, port );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_ucs2string ...                                       */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_ucs2string( obj_t o, obj_t port ) {
   int len  = UCS2_STRING_LENGTH( o );
   ucs2_t *ucs2 = BUCS2_STRING_TO_UCS2_STRING( o );
   void *ostream = OUTPUT_PORT( port ).ostream;
   int i;
   
   if( OUTPUT_STRING_PORTP( port ) ) {
      for( i = 0; i < len; i++ ) {
	 ucs2_t ch = ucs2[ i ];
	 
#if( UCS2_DISPLAYABLE )
#else
	 if( UCS2_ISOLATIN1P( ch ) )
	    PUTC( port, (char)ch, ostream );
#endif
      }
   } else {
      for( i = 0; i < len; i++ ) {
	 ucs2_t ch = ucs2[ i ];
	 
#if( UCS2_DISPLAYABLE )
#else
	 if( UCS2_ISOLATIN1P( ch ) )
	    PUTC( port, (char)ch, ostream );
#endif
      }
   }
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_utf8string ...                                         */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_utf8string( obj_t o, obj_t port ) {
   char *str = (char *)BSTRING_TO_STRING( o );
   int  len = STRING_LENGTH( o );
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PUTS( port, "#u\"", ostream );
   OUTPUT_PORT( port ).syswrite( str, 1, len, ostream );
   PUTC( port, '"', ostream );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_opaque ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_opaque( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PRINTF2( port, 40, ostream, "#<opaque:%ld:%08lx>",
	    TYPE( o ),
	    (unsigned long)o );
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_cnst ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_cnst( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PRINTF1( port, 7, ostream, "#<%04x>", (int)CCNST( o ) );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_procedure ...                                          */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_procedure( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PRINTF2( port, 96, ostream,
	    "#<procedure:%lx.%ld>",
	    VA_PROCEDUREP( o ) ?
	    (unsigned long)PROCEDURE_VA_ENTRY( o ) :
	    (unsigned long)PROCEDURE_ENTRY( o ),
	    (long)PROCEDURE( o ).arity );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_output_port ...                                        */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_output_port( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PRINTF1V( port, 20 + STRING_LENGTH( OUTPUT_PORT( o ).name ),
	     ostream,
	     "#<output_port:%s>",
	     BSTRING_TO_STRING( OUTPUT_PORT( o ).name ) );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_input_port ...                                         */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_input_port( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   PUTS( port, "#<input_port:", ostream );
   bgl_display_obj( INPUT_PORT( o ).name, port );
   PRINTF1( port, 10, ostream, ".%ld>", (long)INPUT_PORT( o ).bufsiz );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_binary_port ...                                        */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_binary_port( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PRINTF2V( port, 40 + STRING_LENGTH( INPUT_PORT( o ).name ),
	     ostream,
	     "#<binary_%s_port:%s>",
	     BINARY_PORT_INP( o ) ? "input" : "output",
	     BSTRING_TO_STRING( BINARY_PORT( o ).name ) );
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_foreign ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_foreign( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PUTS( port, "#<foreign:", ostream );
   bgl_display_obj( FOREIGN_ID( o ), port );
   PRINTF1( port, 16, ostream, ":%lx>", (long)FOREIGN_TO_COBJ( o ) );

   return port;
}
   
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_process ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_process( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PUTS( port, "#<process:", ostream );
   PRINTF1( port, 20, ostream, "%d>", PROCESS_PID( o ) );

   return port;
}
   
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_socket ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_socket( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PRINTF2V( port,
	     40 + (STRINGP( SOCKET( o ).hostname ) ?
		   STRING_LENGTH( SOCKET( o ).hostname ) :
		   sizeof( "localhost" )),
	     ostream,
	     "#<socket:%s.%d>",
	     STRINGP( SOCKET( o ).hostname ) ?
	     BSTRING_TO_STRING( SOCKET( o ).hostname ) :
	     "localhost",
	     SOCKET( o ).portnum );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_mmap ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_mmap( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;
   
   PUTS( port, "#<mmap:", ostream );
   bgl_display_obj( BGL_MMAP( o ).name, port );
   PRINTF1( port, 16, ostream, ":%ld>", (long)BGL_MMAP( o ).length );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_custom ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_custom( obj_t o, obj_t port ) {
   CUSTOM_OUTPUT( o )( o, port );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_unknown ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_unknown( obj_t o, obj_t port ) {
   void *ostream = OUTPUT_PORT( port ).ostream;

   PRINTF2( port, 40, ostream, "#<???:%ld:%08lx>",
	    TYPE( o ), (unsigned long)o );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_ill_char_rep ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_ill_char_rep( unsigned char c ) {
   char aux[ 10 ];

   sprintf( aux, "#a%03d", c );

   return c_constant_string_to_string( aux );
}



