;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/evmeaning.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Aug  4 10:48:41 1993                          */
;*    Last change :  Wed Nov  2 13:57:39 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Bigloo's interpreter.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __evmeaning
   
   (include "Eval/byte-code.sch")
   
   (import  __type
	    __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    __bit
	    __param
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __progn
	    __evenv
	    __evcompile
	    __everror)

   (static  (update-eval-global! variable value))
   
   (export  (evmeaning exp env)
	    (evmeaning-location))
   
   (extern  (%funcall-0::obj (::procedure)
			     "eval_funcall_0")
	    (%funcall-1::obj (::procedure ::obj)
			     "eval_funcall_1")
	    (%funcall-2::obj (::procedure ::obj ::obj)
			     "eval_funcall_2")
	    (%funcall-3::obj (::procedure ::obj ::obj ::obj)
			     "eval_funcall_3")
	    (%funcall-4::obj (::procedure ::obj ::obj ::obj ::obj)
			     "eval_funcall_4")
	    (%eval-apply::obj (::procedure ::obj) "eval_apply")
	    (macro %procedure-eval::obj (::procedure)
		   "PROCEDURE_EVAL")
	    (macro %procedure-eval-set!::obj (::procedure ::obj)
		   "PROCEDURE_EVAL_SET"))
   
   (java    (class foreign
	       (method static %funcall-0::obj (::procedure)
		       "eval_funcall_0")
	       (method static %funcall-1::obj (::procedure ::obj)
		       "eval_funcall_1")
	       (method static %funcall-2::obj (::procedure ::obj ::obj)
		       "eval_funcall_2")
	       (method static %funcall-3::obj (::procedure ::obj ::obj ::obj)
		       "eval_funcall_3")
	       (method static %funcall-4::obj (::procedure ::obj ::obj ::obj ::obj)
		       "eval_funcall_4")
	       (method static %eval-apply::obj (::procedure ::obj)
		       "eval_apply")

	       (method static %procedure-eval::obj (::procedure)
		       "PROCEDURE_EVAL")
	       (method static %procedure-eval-set!::obj (::procedure ::obj)
		       "PROCEDURE_EVAL_SET"))))

;*---------------------------------------------------------------------*/
;*    case-bounce ...                                                  */
;*---------------------------------------------------------------------*/
(define-macro (case-bounce test . clauses)
   (let* ((bounce '())
	  (r `(case ,test
		 ,@(map (lambda (c)
			   (match-case c
			      (((bounce ?vars ((and (? integer?) ?n))) . ?body)
			       (let ((id (string->symbol
					  (string-append
					   "evmeaning-bounce-"
					   (integer->string n)))))
				  (set! bounce
					(cons `(define (,id ,@vars) ,@body)
					      bounce))
				  `((,n) (,id ,@vars))))
			      (((bounce . ?-) . ?-)
			       (error 'case-bounce "Illegal clause" c))
			      (else
			       c)))
			clauses))))
      (putprop! 'case-bounce 'bouncing bounce)
      r))

;*---------------------------------------------------------------------*/
;*    emit-bounced! ...                                                */
;*---------------------------------------------------------------------*/
(define-macro (emit-bounced!)
   `(begin ,@(getprop 'case-bounce 'bouncing)))

;*---------------------------------------------------------------------*/
;*    %inline1 ...                                                     */
;*---------------------------------------------------------------------*/
(define-macro (%inline1 fun code stack)
   `(,fun (evmeaning (evcode-ref code 2) stack)))

;*---------------------------------------------------------------------*/
;*    %inline2 ...                                                     */
;*---------------------------------------------------------------------*/
(define-macro (%inline2 fun code stack)
   `(,fun (evmeaning (evcode-ref code 2) stack)
	  (evmeaning (evcode-ref code 3) stack)))

;*---------------------------------------------------------------------*/
;*    evmeaning ...                                                    */
;*---------------------------------------------------------------------*/
(define (evmeaning code stack)
   (if (evcode? code)
       (begin
	  (set! *current-bcode* code)
 	  (case-bounce (evcode-op code)
	     ((-2)
	      ;; errors
	      (apply evmeaning-error code (evcode-ref code 0)))
	     ((-1)
	      ;; La seule constante qui nessecite un codage: les `vecteurs'
	      (evcode-ref code 0))
	     ((0)
	      ;; first local variable
	      (car stack))
	     ((1)   
	      ;; second local variable
	      (cadr stack))
	     ((2)   
	      ;; third local variable
	      (caddr stack))
	     ((3)   
	      ;; fourth local variable
	      (cadddr stack))
	     ((4)   
	      ;; deep local variables
	      (let ((offset (evcode-ref code 0)))
		 (do ((i 4 (+fx i 1))
		      (env (cddddr stack) (cdr env)))
		     ((=fx i offset) (car env)))))
	     ((5)
	      ;; mutable global variable
	      (__evmeaning_address-ref
	       (eval-global-value (evcode-ref code 0))))
	     ((6)
	      ;; non mutable global variable
	      (eval-global-value (evcode-ref code 0)))
	     ((bounce (code stack) (7))
	      ;; dynamic global variable
	      (let* ((name (evcode-ref code 0))
		     (global (eval-lookup name)))
		 (if (eval-global? global)
		     (begin
			;; we change the value of the byte-code
			;; because, now, the variable is bound
			(evcode-op-set! code 6)
			(evcode-set! code 0 global)
			(eval-global-value global))
		     (evmeaning-error code
				      "eval"
				      "Unbound variable"
				      name))))
	     ((8)
	      ;; (set! <global> <value>)
	      (let ((var (evcode-ref code 0))
		    (val (evmeaning (evcode-ref code 1) stack)))
		 (update-eval-global! var val)
		 (unspecified)))
	     ((bounce (code stack) (9))
	      ;; (set! <dynamic-global> <value>)
	      (let* ((name (evcode-ref code 0))
		     (value (evcode-ref code 1))
		     (global (eval-lookup name)))
		 (if (eval-global? global)
		     (begin
			(evcode-op-set! code 8)
			(evcode-set! code 0 global)
			(evcode-set! code 1 value)
			(evmeaning code stack))
		     (evmeaning-error code
				      "eval"
				      "Unbound variable"
				      name))))
	     ((10)
	      ;; la mutation de la premiere variable locale
	      (set-car! stack (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ((11)
	      ;; la mutation de la deuxieme variable locale
	      (set-car! (cdr stack) (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ((12)
	      ;; la mutation de la troisieme variable locale
	      (set-car! (cddr stack) (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ((13)
	      ;; la mutation de la quatrieme variable locale
	      (set-car! (cdddr stack) (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ((bounce (code stack) (14))
	      ;; la mutation des variables locales profondes
	      (let ((offset (evcode-ref code 0))
		    (value  (evmeaning (evcode-ref code 1) stack)))
		 (do ((i 4 (+fx i 1))
		      (env (cddddr stack) (cdr env)))
		     ((=fx i offset) (set-car! env value)))
		 (unspecified)))
	     ((15) 
	      ;; conditional
	      (if (evmeaning (evcode-ref code 0) stack)
		  (evmeaning (evcode-ref code 1) stack)
		  (evmeaning (evcode-ref code 2) stack)))
	     ((16)
	      ;; sequence (by construction, the length is at least 1)
	      (let ((len (-fx (evcode-length code) 1)))
		 (let loop ((i 0))
		    (if (=fx i len)
			(evmeaning (evcode-ref code i) stack)
			(begin
			   (evmeaning (evcode-ref code i) stack)
			   (loop (+fx i 1)))))))
	     ((bounce (code stack) (17))
	      ;; (define <global> (lambda ...))
	      (let ((var (evcode-ref code 0))
		    (val (evcode-ref code 1)))
		 (let ((cell (eval-lookup var)))
		    (if (eval-global? cell)
			(begin
			   (update-eval-global! cell (evmeaning val '()))
			   (evmeaning-warning code
					      "eval"
					      #\Newline
					      "redefinition of variable -- "
					      var))
			(let ((cell (vector 0 var (unspecified))))
 			   (bind-eval-global! var cell)
			   ;; on le fait en deux fois pour etre
			   ;; sur que la liaison existe.
			   (let ((value (evmeaning val '())))
			      (set-eval-global-value! cell value))))
		    var)))
	     ((bounce (code stack) (18))
	      ;; bind-exit
	      (bind-exit (__dummy__)
		 ((evmeaning (evcode-ref code 0) stack) __dummy__)))
	     ((bounce (code) (25))
	      ;; l'appel de fonction de compilee anonyme d'arite 0
	      ((evcode-ref code 0)))
	     ((bounce (code stack) (26))
	      ;; l'appel de fonction de compilee anonyme d'arite 1
	      (let* ((fun (evcode-ref code 0)))
		 (set! *current-bcode* code)
		 (fun (evmeaning (evcode-ref code 1) stack))))
	     ((bounce (code stack) (27))
	      ;; l'appel de fonction de compilee anonyme d'arite 2
	      (let* ((fun (evcode-ref code 0))
		     (a0 (evmeaning (evcode-ref code 1) stack))
		     (a1 (evmeaning (evcode-ref code 2) stack)))
		 (set! *current-bcode* code)
		 (fun a0 a1)))
	     ((bounce (code stack) (28))
	      ;; l'appel de fonction de compilee anonyme d'arite 3
	      (let* ((fun (evcode-ref code 0))
		     (a0 (evmeaning (evcode-ref code 1) stack))
		     (a1 (evmeaning (evcode-ref code 2) stack))
		     (a2 (evmeaning (evcode-ref code 3) stack)))
		 (set! *current-bcode* code)
		 (fun a0 a1 a2)))
	     ((bounce (code stack) (29))
	      ;; l'appel de fonction de compilee anonyme d'arite 4
	      (let* ((fun (evcode-ref code 0))
		     (a0 (evmeaning (evcode-ref code 1) stack))
		     (a1 (evmeaning (evcode-ref code 2) stack))
		     (a2 (evmeaning (evcode-ref code 3) stack))
		     (a3 (evmeaning (evcode-ref code 4) stack)))
		 (set! *current-bcode* code)
		 (fun a0 a1 a2 a3)))
	     ((bounce (code stack) (30))
	      ;; l'appel de fonction de compilee anonyme d'arite plus que 4
	      (let ((eargs (map (lambda (x)
				   (evmeaning x stack))
				(evcode-ref code 1))))
		 (set! *current-bcode* code)
		 (apply (evcode-ref code 0) eargs)))
	     ((31)
	      ;; funcall 0
	      (evmeaning-funcall-0 code stack))
	     ((32)
	      ;; funcall 1
	      (evmeaning-funcall-1 code stack))
	     ((33)
	      ;; funcall 2
	      (evmeaning-funcall-2 code stack))
	     ((34)
	      ;; funcall 3
	      (evmeaning-funcall-3 code stack))
	     ((35)
	      ;; funcall 4
	      (evmeaning-funcall-4 code stack))
	     ((bounce (code stack) (36))
	      ;; funcall >4
	      (let* ((name (evcode-ref code 0))
		     (fun (evmeaning (evcode-ref code 1) stack)))
 		 (let loop ((args (evcode-ref code 2))
			    (new '())
			    (len 0))
		    (if (null? args)
			(begin
			   (set! *current-bcode* code)
			   (eval-apply code name fun len (reverse! new)))
			(loop (cdr args)
			      (cons (evmeaning (car args) stack) new)
			      (+fx 1 len))))))
	     ((bounce (code stack) (37))
	      ;; This code is very sensitive to the compiler order. Because
	      ;; of tail recursion, it is extremely important that the capture
	      ;; variable are order 0 for the body (the variable !b), and 1
	      ;; for the stack (the variable !s). To enforce this order, we
	      ;; explicitly use a cascade of "if"s
	      ;; procedure arity 0, traced
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda ()
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning !b !s)))
			      ($pop-trace)
			      res))))
		  0
		  body
		  stack)))
	     ((bounce (code stack) (38))
	      ;; procedure arity 1, traced
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning !b (cons x !s))))
			      ($pop-trace)
			      res))))
		  1
		  body
		  stack)))
	     ((bounce (code stack) (39))
	      ;; procedure arity 2, traced
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning !b (cons x (cons y !s)))))
			      ($pop-trace)
			      res))))
		  2
		  body
		  stack)))
	     ((bounce (code stack) (40))
	      ;; procedure arity 3, traced
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y z)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning !b
						 (cons x
						       (cons y
							     (cons z !s))))))
			      ($pop-trace)
			      res))))
		  3
		  body
		  stack)))
	     ((bounce (code stack) (41))
	      ;; procedure arity 4, traced
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y z t)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning
				       !b
				       (cons x
					     (cons y
						   (cons z
							 (cons t !s)))))))
			      ($pop-trace)
			      res))))
		  4
		  body
		  stack)))
	     ((bounce (code stack) (42))
	      ;; ...untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda ()
		     (let ((!b body))
			(evmeaning !b stack)))
		  0
		  body
		  stack)))
	     ((bounce (code stack) (43))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x)
		     (let ((!b body))
			(evmeaning !b (cons x stack))))
		  1
		  body
		  stack)))
	     ((bounce (code stack) (44))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y)
		     (let ((!b body))
			(evmeaning !b (cons x (cons y stack)))))
		  2
		  body
		  stack)))
	     ((bounce (code stack) (45))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y z)
		     (let ((!b body))
			(evmeaning !b (cons x (cons y (cons z stack))))))
		  3
		  body
		  stack)))
	     ((bounce (code stack) (46))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y z t)
		     (let ((!b body))
			(evmeaning !b
				   (cons x (cons y (cons z (cons t stack)))))))
		  4
		  body
		  stack)))
	     ((bounce (code stack) (47))
	      ;; procedure arity -1, traced
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda x
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning !b (cons x !s))))
			      ($pop-trace)
			      res))))
		  -1
		  body
		  stack)))
	     ((bounce (code stack) (48))
	      ;; procedure arity -2, traced
	      (let ((body  (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x . y)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning !b (cons x (cons y !s)))))
			      ($pop-trace)
			      res))))
		  -2
		  body
		  stack)))
	     ((bounce (code stack) (49))
	      ;; procedure arity -3, traced
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y . z)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning !b
						 (cons x
						       (cons y
							     (cons z !s))))))
			      ($pop-trace)
			      res))))
		  -3
		  body
		  stack)))
	     ((bounce (code stack) (50))
	      ;; procedure arity -4, traced
	      (let ((body  (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y z . t)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   ($push-trace where)
			   (let ((res (evmeaning
				       !b
				       (cons x
					     (cons y
						   (cons z
							 (cons t
							       !s)))))))
			      ($pop-trace)
			      res))))
		  -4
		  body
		  stack)))
	     ((bounce (code stack) (51))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda x
		     (let ((!b body))
			(evmeaning !b (cons x stack))))
		  -1
		  body
		  stack)))
	     ((bounce (code stack) (52))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x . y)
		     (let ((!b body))
			(evmeaning !b (cons x (cons y stack)))))
		  -2
		  body
		  stack)))
	     ((bounce (code stack) (53))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y . z)
		     (let ((!b body))
			(evmeaning !b
				   (cons x (cons y (cons z stack))))))
		  -3
		  body
		  stack)))
	     ((bounce (code stack) (54))
	      ;; untraced
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y z . t)
		     (let ((!b body))
			(evmeaning
			 !b
			 (cons x (cons y (cons z (cons t stack)))))))
		  -4
		  body
		  stack)))
	     ((55)
	      ;; procedure arity > 4 arguments, traced
	      (evmeaning-make-traced-4procedure code stack))
	     ;; untraced
	     ((56)
	      (evmeaning-make-4procedure code stack))
	     ((bounce (code stack) (63))
	      ;; the form define (global) value
	      (let* ((var (evcode-ref code 0))
		     (val (evmeaning (evcode-ref code 1) '())))
		 (let ((cell (eval-lookup var)))
		    (if (eval-global? cell)
			(begin
			   (update-eval-global! cell val)
			   (evmeaning-warning code
					      "eval"
					      #\Newline
					      "redefinition of variable -- "
					      var))
			(let ((cell (vector 0 var (unspecified))))
			   (bind-eval-global! var cell)
			   ;; on le fait en deux fois pour etre
			   ;; sur que la liaison existe.
			   (set-eval-global-value! cell val)))
		    var)))
	     ((bounce (code stack) (64))
	      ;; unwind-protect
	      (let ((body (evcode-ref code 0))
		    (protect (evcode-ref code 1)))
		 (unwind-protect (evmeaning body stack)
				 (evmeaning protect stack))))
	     ((65)
	      ;; let (bindings are stored reversed!)
	      (let loop ((vals (evcode-ref code 1))
			 (env stack))
		 (if (null? vals)
		     (evmeaning (evcode-ref code 0) env)
		     (loop (cdr vals)
			   (cons (evmeaning (car vals) stack) env)))))
	     ((66)
	      ;; let*
	      (let loop ((vals (evcode-ref code 1))
			 (env stack))
		 (if (null? vals)
		     (evmeaning (evcode-ref code 0) env)
		     (loop (cdr vals)
			   (cons (evmeaning (car vals) env) env)))))
	     ((bounce (code stack) (67))
	      ;; or
	      (let ((len (evcode-length code)))
		 (let loop ((i 0))
		    (if (<fx i len)
			(or (evmeaning (evcode-ref code i) stack)
			    (loop (+fx i 1)))
			#f))))
	     ((bounce (code stack) (68))
	      ;; and
	      (let ((len (evcode-length code)))
		 (let loop ((i 0)
			    (l #t))
		    (if (<fx i len)
			(let ((l (evmeaning (evcode-ref code i) stack)))
			   (and l (loop (+fx i 1) l)))
			l))))
	     ((70)
	      ;; letrec
	      (let* ((vals (evcode-ref code 1))
		     (env2 (append (make-list (length vals)) stack)))
		 (let loop ((vals vals)
			    (env3 env2))
		    (if (null? vals)
			(evmeaning (evcode-ref code 0) env2)
			(begin
			   (set-car! env3 (evmeaning (car vals) env2))
			   (loop (cdr vals) (cdr env3)))))))
	     ((131)
	      ;; tailcall 0
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-0-stack code stack fun))
		     (evmeaning-funcall-0 code stack))))
	     ((132)
	      ;; tailcall 1
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-1-stack code stack fun))
		     (evmeaning-funcall-1 code stack))))
	     ((133)
	      ;; tailcall 2
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-2-stack code stack fun))
		     (evmeaning-funcall-2 code stack))))
	     ((134)
	      ;; tailcall 3
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-3-stack code stack fun))
		     (evmeaning-funcall-3 code stack))))
	     ((135)
	      ;; tailcall 4
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-4-stack code stack fun))
		     (evmeaning-funcall-4 code stack))))
	     ((136)
	      ;; tailcall >4
	      (let* ((name (evcode-ref code 0))
		     (fun (evmeaning (evcode-ref code 1) stack)))
 		 (let loop ((args (evcode-ref code 2))
			    (new '())
			    (len 0))
		    (if (null? args)
			(if (evmeaning-procedure? fun)
			    (let* ((fmls (evmeaning-procedure-args fun))
				   (stack (evmeaning-procedure-stack fun))
				   (wen (reverse! new))
				   (e2 (if (>=fx fmls 0)
					   (evmeaning-push-fxargs name
								  code
								  wen
								  fmls
								  stack)
					   (evmeaning-push-vaargs name
								  code
								  wen
								  fmls
								  stack))))
			       (evmeaning (evmeaning-procedure-bcode fun) e2))
			    (begin
			       (set! *current-bcode* code)
			       (eval-apply code name fun len (reverse! new))))
			(loop (cdr args)
			      (cons (evmeaning (car args) stack) new)
			      (+fx 1 len))))))
	     ((145 146)
	      ;; unlinked global variable
	      (evcode-op-set! code (-fx (evcode-op code) 140))
	      (evcode-set! code 0 (eval-lookup (evcode-ref code 0)))
	      (evmeaning code stack))
	     ;; inline code-op	     
	     ((147)
	      (%inline2 + code stack))
	     ((148)
	      (%inline2 - code stack))
	     ((149)
	      (%inline2 * code stack))
	     ((150)
	      (%inline2 / code stack))
	     ((151)
	      (%inline2 < code stack))
	     ((152)
	      (%inline2 > code stack))
	     ((153)
	      (%inline2 <= code stack))
	     ((154)
	      (%inline2 >= code stack))
	     ((155)
	      (%inline2 = code stack))
	     ((156)
	      (%inline2 eq? code stack))
	     ((157)
	      (%inline2 cons code stack))
	     ((158)
	      (%inline1 car code stack))
	     ((159)
	      (%inline1 cdr code stack))
	     ((160)
	      (%inline1 cadr code stack))
	     (else
	      ;; unknown byte code
	      (evmeaning-error code
			       "evmeaning (internal error)"
			       "unknown byte-code"
			       code))))
       code))

(emit-bounced!)

;*---------------------------------------------------------------------*/
;*    evprocedure ...                                                  */
;*---------------------------------------------------------------------*/
(define-struct evprocedure args bcode stack)

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure? ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure? proc)
   (and (procedure? proc) (evprocedure? (%procedure-eval proc))))

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure! ...                                         */
;*---------------------------------------------------------------------*/
(define (evmeaning-procedure! proc args bcode stack)
   (%procedure-eval-set! proc (evprocedure args bcode stack))
   proc)

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure-bcode ...                                    */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure-bcode proc)
   (evprocedure-bcode (%procedure-eval proc)))

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure-stack ...                                    */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure-stack proc)
   (evprocedure-stack (%procedure-eval proc)))

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure-args ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure-args proc)
   (evprocedure-args (%procedure-eval proc)))

;*---------------------------------------------------------------------*/
;*    evmeaning-location ...                                           */
;*---------------------------------------------------------------------*/
(define (evmeaning-location)
   (if (evcode? *current-bcode*)
       (let ((p (evcode-loc *current-bcode*)))
	  (match-case p
	     ((at ?fname ?loc) p)
	     (else #f)))
       #f))
   
;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-location ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-location o)
   (let ((bcode (list-ref *funcall-bcodes*
			  (- *funcall-bcode-length*
			     (modulo o *funcall-bcode-length*)))))
      (if (evcode? bcode)
	  (let ((p (evcode-loc bcode)))
	     (match-case p
		((at ?fname ?loc) p)
		(else #f)))
	  #f)))
   
;*---------------------------------------------------------------------*/
;*      update-eval-global! ...                                        */
;*---------------------------------------------------------------------*/
(define (update-eval-global! variable val)
   (if (eq? (eval-global-tag variable) 1)
       (__evmeaning_address-set! (eval-global-value variable) val)
       (if (bigloo-eval-strict-module)
	   (error 'set! "Read-only variable" (eval-global-name variable))
	   (set-eval-global-value! variable val)))
   (eval-global-name variable))

;*---------------------------------------------------------------------*/
;*    *funcall-bcodes* ...                                             */
;*---------------------------------------------------------------------*/
(define *funcall-bcode-length*
   (let ((std (getenv "BIGLOOSTACKDEPTH")))
      (if (number? std)
	  (max std 10)
	  10)))
(define *funcall-bcodes*
   (let ((l (make-list *funcall-bcode-length* #f)))
      (set-cdr! (last-pair l) l)
      l))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-0 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-0 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (evmeaning-error code "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 0))
	  (evmeaning-error code "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-0 fun)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-1 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-1 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (evmeaning-error code "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 1))
	  (evmeaning-error code "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-1 fun a0)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-2 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-2 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (evmeaning-error code "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 2))
	  (evmeaning-error code "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-2 fun a0 a1)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-3 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-3 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (evmeaning-error code "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 3))
	  (evmeaning-error code "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-3 fun a0 a1 a2)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-4 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-4 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack))
	  (a3 (evmeaning (evcode-ref code 5) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (evmeaning-error code "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 4))
	  (evmeaning-error code "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-4 fun a0 a1 a2 a3)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-0-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-0-stack code stack fun)
   (let* ((envd (evmeaning-procedure-stack fun))
	  (arity (evmeaning-procedure-args fun)))
      (case arity
	 ((0)
	  envd)
	 ((-1)
	  (cons '() envd))
	 (else
	  (evmeaning-arity-error code (evcode-ref code 0))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-1-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-1-stack code stack fun)
   (let ((a0 (evmeaning (evcode-ref code 2) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((1)
	     (cons a0 envd))
	    ((-1)
	     (cons (list a0) envd))
	    ((-2)
	     (cons a0 (cons '() envd)))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-2-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-2-stack code stack fun)
   (let* ((a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((2)
	     (cons a0 (cons a1 envd)))
	    ((-1)
	     (cons (list a0 a1) envd))
	    ((-2)
	     (cons a0 (cons (list a1) envd)))
	    ((-3)
	     (cons a0 (cons a1 (cons '() envd))))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-3-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-3-stack code stack fun)
   (let* ((a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((3)
	     (cons a0 (cons a1 (cons a2 envd))))
	    ((-1)
	     (cons (list a0 a1 a2) envd))
	    ((-2)
	     (cons a0 (cons (list a1 a2) envd)))
	    ((-3)
	     (cons a0 (cons a1 (cons (list a2) envd))))
	    ((-4)
	     (cons a0 (cons a1 (cons a2 (cons '() envd)))))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-4-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-4-stack code stack fun)
   (let* ((a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack))
	  (a3 (evmeaning (evcode-ref code 5) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((4)
	     (cons a0 (cons a1 (cons a2 (cons a3 envd)))))
	    ((-1)
	     (cons (list a0 a1 a2 a3) envd))
	    ((-2)
	     (cons a0 (cons (list a1 a2 a3) envd)))
	    ((-3)
	     (cons a0 (cons a1 (cons (list a2 a3) envd))))
	    ((-4)
	     (cons a0 (cons a1 (cons a2 (cons (list a3) envd)))))
	    ((-5)
	     (cons a0 (cons a1 (cons a2 (cons a3 (cons '() envd))))))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    eval-apply ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (eval-apply code name fun len args)
   (cond
      ((not (procedure? fun))
       (evmeaning-error code "apply" "Not a procedure" name))
      ((not (correct-arity? fun len))
       (evmeaning-error code "eval" "Wrong number of argument" name))
      (else
       (%eval-apply fun args))))

;*---------------------------------------------------------------------*/
;*    evmeaning-make-traced-4procedure ...                             */
;*---------------------------------------------------------------------*/
(define (evmeaning-make-traced-4procedure code stack)
   (let ((body (evcode-ref code 0))
	 (where (evcode-ref code 1))
	 (formals (evcode-ref code 2)))
      (if (list? formals)
	  (let ((lf (length formals)))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ()
		       ($push-trace where)
		       (let ((e2 (evmeaning-push-fxargs where code x lf !s)))
			  (let ((res (evmeaning !b e2)))
			     ($pop-trace)
			     res)))))
	      lf
	      body
	      stack))
	  (let ((lf (let loop ((formals formals)
			       (num -1))
		       (if (pair? formals)
			   (loop (cdr formals) (-fx num 1))
			   num))))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ()
		       ($push-trace where)
		       (let ((e2 (evmeaning-push-vaargs where code x lf !s)))
			  (let ((res (evmeaning !b e2)))
			     ($pop-trace)
			     res)))))
	      lf
	      body
	      stack)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-make-4procedure ...                                    */
;*---------------------------------------------------------------------*/
(define (evmeaning-make-4procedure code stack)
   (let ((body (evcode-ref code 0))
	 (formals (evcode-ref code 1)))
      (if (list? formals)
	  (let ((lf (length formals)))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ((e2 (evmeaning-push-fxargs x code x lf !s)))
		       (evmeaning !b e2))))
	      lf
	      body
	      stack))
	  (let ((lf (let loop ((formals formals)
			       (num -1))
		       (if (pair? formals)
			   (loop (cdr formals) (-fx num 1))
			   num))))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ((e2 (evmeaning-push-vaargs x code x lf !s)))
		       (evmeaning !b e2))))
	      lf
	      body
	      stack)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-push-fxargs ...                                        */
;*---------------------------------------------------------------------*/
(define (evmeaning-push-fxargs name code actuals num stack)
   (let _loop_ ((actuals actuals)
		(num num))
      (cond
	 ((=fx num 0)
	  (if (not (null? actuals))
	      (evmeaning-arity-error code name))
	      stack)
	 ((null? actuals)
	  (evmeaning-arity-error code name))
	 (else
	  (cons (car actuals)
		(_loop_ (cdr actuals) (-fx num 1)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-push-vaargs ...                                        */
;*---------------------------------------------------------------------*/
(define (evmeaning-push-vaargs name code actuals num stack)
   (let _loop_ ((actuals actuals)
		(num num))
      (cond
	 ((=fx num -1)
	  (cons actuals stack))
	 ((null? actuals)
	  (evmeaning-arity-error code name))
	 (else
	  (cons (car actuals)
		(_loop_ (cdr actuals) (+fx num 1)))))))
   
;*---------------------------------------------------------------------*/
;*    Les environments ...                                             */
;*---------------------------------------------------------------------*/
(init-the-global-environment!)
