;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expanders.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 09:58:05 1994                          */
;*    Last change :  Thu Oct  6 10:26:10 2005 (serrano)                */
;*    Copyright   :  2002-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    Expanders installation.                                          */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __install_expanders

   (import  __error
	    __macro
	    __expander_quote
	    __expander_let
	    __expander_bool
	    __expander_case
	    __expander_define
	    __expander_do
	    __expander_try
	    __expander_struct
	    __expander_record
	    __expander_srfi-0
	    __expander_args
	    __expander_trace
	    __eval
	    __progn
	    __lalr_expand
	    __rgc_expand
	    __match_expand
	    __param
	    
	    __r5_macro_4_3_syntax
	    __r5_macro_4_3_hygiene)
   
   (use     __type
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    __r5_control_features_6_4
	    
	    __evenv)
	    
   (export  (install-all-expanders!)))

;*---------------------------------------------------------------------*/
;*    expand-test ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-test x e)
   (if *nil*
       (e x e)
       `((lambda (test-aux-for-nil)
	    (if test-aux-for-nil
		(if (null? test-aux-for-nil)
		    #f
		    #t)
		#f))
	 ,(e x e)))) 

;*---------------------------------------------------------------------*/
;*    install-all-expanders! ...                                       */
;*    -------------------------------------------------------------    */
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    It is mandatory to define the closure associated to expanders    */
;*    in *this* module in order to avoid module initialization         */
;*    order problems.                                                  */
;*---------------------------------------------------------------------*/
(define (install-all-expanders!)
   
;*---------------------------------------------------------------------*/
;*    Expanders shared by the compiler and the interpreter             */
;*---------------------------------------------------------------------*/
   ;; quote
   (install-expander 'quote (lambda (x e) (expand-quote x e)))
   
   ;; quasiquote
   (install-expander 'quasiquote (lambda (x e) (e (quasiquotation 1 x) e)))
   
   ;; define-macro  
   (install-expander 'define-macro (lambda (x e)
				      (expand-define-macro x e)))
   
   ;; define-hygiene-macro  
   (install-expander 'define-hygiene-macro (lambda (x e)
					      (expand-define-hygiene-macro x e)))
   
   ;; define-expander
   (install-expander 'define-expander (lambda (x e)
					 (expand-define-expander x e)))
   
   ;; cond
   (install-expander 'cond (lambda (x e) (e (expand-cond x) e)))
   
   ;; do
   (install-expander 'do (lambda (x e) (expand-do x e)))
   
   ;; try
   (install-expander 'try (lambda (x e) (expand-try x e)))
   
   ;; match-case
   (install-expander 'match-case (lambda (x e) (e (expand-match-case x) e)))
   
   ;; match-lambda
   (install-expander 'match-lambda (lambda (x e)
				      (e (expand-match-lambda x) e)))
   
   ;; define-pattern
   (install-expander 'define-pattern (lambda (x e)
					(e (expand-define-pattern x) e)))
   
   ;; delay
   (install-expander 'delay (lambda (x e)
			       (match-case x
				  ((?- ?exp)
				   `(make-promise (lambda () ,(e exp e))))
				  (else
				   (error "delay"
					  "Illegal form"
					  x)))))
   ;; regular-grammar
   (install-expander 'regular-grammar expand-regular-grammar)
   
   ;; string-case
   (install-expander 'string-case expand-string-case)
   
   ;; lalr-grammar
   (install-expander 'lalr-grammar expand-lalr-grammar)
   
   ;; begin
   (install-expander 'begin (lambda (x e)
			       (match-case x
				  ((?- . ?body)
				   (let loop ((l body))
				      (cond
					 ((null? l)
					  (let ((new `(begin
							 ,@(map
							    (lambda (x)
							       (e x e))
							    body))))
					     (set-car! x (car new))
					     (set-cdr! x (cdr new))
					     x))
					 ((pair? l)
					  (loop (cdr l)))
					 (else
					  (error "begin" "Illegal form" x)))))
				  (else
				   (error "begin"
					  "Illegal form"
					  x)))))
   
   ;; failure
   (install-expander 'failure (lambda (x e)
				 (match-case x
				    ((?- ?proc ?msg ?obj)
				     `(failure ,(e proc e)
					       ,(e msg e)
					       ,(e obj e)))
				    (else
				     (error "failure"
					    "Illegal `failure' form"
					    x)))))
   
   ;; receive
   (install-expander 'receive
		     (lambda (x e)
			(match-case x
			   ((?- ?vars ?call . ?exprs)
			    (e `(call-with-values (lambda () ,call)
						  (lambda ,vars ,@exprs))
			       e))
			   (else
			    (error "receive"
				   "Illegal form"
				   x)))))
   
   ;; when
   (install-expander 'when
		     (lambda (x e)
			(match-case x
			   ((?- ?si . ?body)
			    (e `(if ,si
				    (begin ,@body)
				    #f)
			       e))
			   (else
			    (error "when" "Illegal form" x)))))
   
   ;; unless
   (install-expander 'unless
		     (lambda (x e)
			(match-case x
			   ((?- ?si . ?body)
			    (e `(if ,si
				    #f
				    (begin ,@body))
			       e))
			   (else
			    (error "unless" "Illegal form" x)))))
   ;; define-record-type
   (install-expander 'define-record-type expand-define-record-type)
   
   ;; args-parse
   (install-expander 'args-parse expand-args-parse)
   
   ;; tprint
   (install-expander 'tprint (lambda (x e)
				(set-car! x 'fprint)
				(e (if (epair? x)
				       (match-case (cer x)
					  ((at ?name ?pos)
					   (set-cdr! x
						     (cons*
						      '(current-error-port)
						      name
						      ","
						      (file-position->line pos name)
						      ":"
						      (cdr x)))
					   x)
					  (else
					   (set-car! x 'fprint)
					   (set-cdr! x (cons
							'(current-error-port)
							(cdr x)))
					   x))
				       (begin
					  (set-car! x 'fprint)
					  (set-cdr! x (cons
						       '(current-error-port)
						       (cdr x)))
					  x))
				   e)))
   
   ;; and-let*
   (install-expander 'and-let*
		     (lambda (x e)
			(define (and-let-error)
			   (error #f "Illegal `and-let*' form" x))
			(match-case
			      x
			   ((?- (and (? pair-or-null?) ?bindings) .
				(and ?body (not ())))
			    (if (null? bindings)
				`(begin ,(e (normalize-progn body) e))
				(let ((first-binding (car bindings)))
				   (unless (pair? first-binding)
				      (and-let-error))
				   (let ((sl `(and-let* ,(cdr bindings)
							,@body)))
				      (match-case first-binding
					 (((and (? symbol?)?varname) ?expr)
					  (e `(let (,first-binding)
						 (and ,varname ,sl))
					     e))
					 ((?expr)
					  (e `(and ,expr ,sl) e))
					 (else
					  (and-let-error)))))))
			   (else (and-let-error)))))
   
   ;; define-syntax
   (install-expander 'define-syntax (lambda (x e) (expand-define-syntax x e)))
   (install-expander 'letrec-syntax (lambda (x e) (expand-letrec-syntax x e)))
   (install-expander 'let-syntax (lambda (x e) (expand-let-syntax x e)))
   
   ;; trace
   (install-expander 'when-trace expand-when-trace)
   (install-expander 'with-trace expand-with-trace)
   (install-expander 'trace-item expand-trace-item)
   
;*---------------------------------------------------------------------*/
;*    Interpreter macros                                               */
;*---------------------------------------------------------------------*/
   ;; bind-exit
   (install-eval-expander 'bind-exit (lambda (x e)
					(match-case x
					   ((?- (?exit) . (and ?body (not ())))
					    `(bind-exit (,exit)
						,(e (normalize-progn body)
						    e)))
					   (else
		    			    (error "bind-exit"
						   "Illegal form"
						   x)))))
   
   ;; unwind-protect
   (install-eval-expander 'unwind-protect (lambda (x e)
					     (match-case x
						((?- ?body . ?exp)
						 `(unwind-protect
						     ,(e body e)
						     ,@(map (lambda (x)
							       (e x e))
							    exp)))
						(else
						 (error "unwind-protect"
							"Illegal form"
							x)))))
   
   ;; multiple-value-bind
   (install-eval-expander 'multiple-value-bind
			  (lambda (x e)
			     (match-case x
				((?- ?vars ?call . ?exprs)
				 (e `(call-with-values (lambda () ,call)
						       (lambda ,vars ,@exprs))
				    e))
				(else
				 (error "multiple-value-bind"
					"Illegal form"
					x)))))
   ;; module
   (install-eval-expander 'module (lambda (x e) x))
   
   ;; if
   (install-eval-expander 'if (lambda (x e)
				 (match-case x
				    ((if ?si ?alors ?sinon)
				     (set-car! (cdr x) (expand-test si e))
				     (set-car! (cddr x) (e alors e))
				     (set-car! (cdddr x) (e sinon e))
				     x)
				    ((if ?si ?alors)
				     (set-car! (cdr x) (expand-test si e))
				     (set-car! (cddr x) (e alors e))
				     (set-cdr! (cddr x) (cons #f '()))
				     x)
				    (else
				     (error "if" "Illegal form" x)))))
   
   ;; or
   (install-eval-expander 'or (lambda (x e)
				 (match-case x
				    ((?- . (and ?r (? list?)))
				     `(or ,@(map (lambda (x1) (e x1 e)) r)))
				    (else
				     (error 'or "Illegal form" x)))))
   ;; and
   (install-eval-expander 'and (lambda (x e)
				  (match-case x
				     ((?- . (and ?r (? list?)))
				      `(and ,@(map (lambda (x1) (e x1 e)) r)))
				     (else
				      (error 'and "Illegal form" x)))))
   
   ;; not
   (install-eval-expander 'not (lambda (x e)
				  (match-case x
				     ((?- ?x1)
				      `(not ,(e x1 e)))
				     (else
				      (error 'not "Illegal form" x)))))
   
   ;; lambda
   (install-eval-expander 'lambda expand-eval-lambda)
   
   ;; let
   (install-eval-expander 'let expand-eval-let)
   
   ;; let*
   (install-eval-expander 'let* expand-eval-let*)
   
   ;; letrec
   (install-eval-expander 'letrec expand-eval-letrec)
   
   ;; labels
   (install-eval-expander 'labels expand-eval-labels)
   
   ;; define
   (install-eval-expander 'define expand-eval-define)
   
   ;; define-inline
   (install-eval-expander 'define-inline expand-eval-define-inline)
   
   ;; define-generic
   (install-eval-expander 'define-generic expand-eval-define-generic)
   
   ;; define-generic
   (install-eval-expander 'define-method expand-eval-define-method)
   
   ;; define-struct
   (install-eval-expander 'define-struct expand-eval-define-struct)

   ;; case
   (install-eval-expander 'case expand-eval-case)
   
   ;; cond-expand
   (install-eval-expander 'cond-expand expand-cond-expand)
   
   ;; profile
   (install-eval-expander 'profile
			  (lambda (x e)
			     (match-case x
				((?- (and (? symbol?) ?lbl) . ?exprs)
				 (let* ((la  `(lambda () ,@exprs))
					(lam (if (epair? x)
						 (econs (car la)
							(cdr la)
							(cer x))
						 la))
					(val (let ((sym (gensym 'value)))
						sym))
					(aux `(let ((,lbl ,lam))
						 (GC-profile-push
						  ,(symbol->string lbl)
						  ,lbl)
						 (let ((,val (,lbl)))
						    (GC-profile-pop)
						    ,val)))
					(res (if (epair? x)
						 (econs (car aux)
							(cdr aux)
							(cer x))
						 aux)))
				    (e aux e)))
				(else
				 (error "profile" "Illegal form" x)))))
   
   ;; instantiate
   (install-eval-expander 'instantiate
			  (lambda (x e)
			     (match-case x
				((?id . ?-)
				 (error id "Unknown class" x)))))
   
   ;; with-access
   (install-eval-expander 'with-access
			  (lambda (x e)
			     (match-case x
				((?id . ?-)
				 (error id "Unknown class" x))))))
   
   
