;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/input.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug  4 15:42:25 1992                          */
;*    Last change :  Sun Nov 20 07:09:49 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.2 Input (page 30, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_input_6_10_2
   
   (import  __error
	    __r4_ports_6_10_1
	    __param)
   
   (use     __type
	    __bigloo
	    __tvector
	    
	    __rgc
	    
	    __r4_output_6_10_3
	    __r4_equivalence_6_2
	    __r4_vectors_6_8
	    __r4_booleans_6_1
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_strings_6_7
	    __r4_control_features_6_9
	    __r4_characters_6_6
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    
	    __evenv)
   
   (extern  (macro c-eof-object?::bool (::obj) "EOF_OBJECTP")
	    (c-char-ready?::bool (::input-port) "bgl_rgc_charready")
	    ($sendchars::obj (::input-port ::output-port ::long ::long) "bgl_sendchars")
	    (macro beof::obj "BEOF"))
   
   (java    (class foreign
	       (method static c-eof-object?::bool (::obj) "EOF_OBJECTP")
	       (method static c-char-ready?::bool (::input-port) "bgl_rgc_charready")
	       (field static beof::obj "BEOF")))
   
   (export  (read/rp    ::procedure ::input-port . obj)
	    (read/lalrp ::procedure ::procedure ::input-port . obj)
	    
	    (read-char . port)
	    (peek-char . port)
	    (inline eof-object?::bool ::obj)
	    (inline char-ready?::bool . port)
	    (read-line::obj . input-port)
	    (read-lines::pair-nil . input-port)
	    (read-string::bstring . input-port)
	    (read-of-strings::obj . input-port)
	    (read-chars::obj ::int . port)
	    (read-chars!::obj ::bstring ::int . port)
	    (read-fill-string!::int ::bstring ::int ::int . port)
	    (port->string-list::pair-nil ::input-port)
	    (send-chars::long ::input-port ::output-port . obj)
	    (file-lines ::bstring)
	    (file-position->line ::int ::obj))
   
   (pragma  (eof-object? side-effect-free nesting args-safe)
	    (char-ready? side-effect-free args-safe)))

;*---------------------------------------------------------------------*/
;*    read/rp ...                                                      */
;*---------------------------------------------------------------------*/
(define (read/rp grammar port . opts)
   (cond
      ((pair? opts)
       (apply grammar port opts))
      ((correct-arity? grammar 1)
       (grammar port))
      (else
       (error 'read/rp "Grammar arity mismatch" grammar))))

;*---------------------------------------------------------------------*/
;*    read/lalr ...                                                    */
;*---------------------------------------------------------------------*/
(define (read/lalrp lalr rgc port . eof-fun?)
   (if (null? eof-fun?)
       (lalr rgc port eof-object?)
       (lalr rgc port (car eof-fun?))))

;*---------------------------------------------------------------------*/
;*    read-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (the-character)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    peek-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (peek-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (let ((c (the-character)))
			 (rgc-buffer-unget-char (the-port) (char->integer c))
			 c)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    eof-object? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (eof-object? object)
   (c-eof-object? object))

;*---------------------------------------------------------------------*/
;*    char-ready? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (char-ready? . port)
   (c-char-ready? (if (pair? port) (car port) (current-input-port))))

;*---------------------------------------------------------------------*/
;*    read-line ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-line . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (if (>fx (c-input-port-bufsiz port) 2)
	  (let ((grammar (regular-grammar ((xall (or (out #\Newline #\Return)
						     #a000)))
			    ((: (+ xall) (or #\Newline #\Return))
			     (the-substring 0 (-fx (the-length) 1)))
			    ((: (+ xall) #\Return #\Newline)
			     (the-substring 0 (-fx (the-length) 2)))
			    ((+ xall)
			     (the-string))
			    ((or #\Newline #\Return (: #\Return #\Newline))
			     "")
			    (else
			     (the-failure)))))
	     (read/rp grammar port))
	  ;; IOs are unbufferized, uses read-char to get the
	  ;; characters one by one
	  (let loop ((c (read-char port))
		     (w 0)
		     (m 100)
		     (acc (make-string 100)))
	     (cond
		((eof-object? c)
		 ;; shrink the buffer and return 
		 (if (=fx w 0) c (substring acc 0 w)))
		((=fx w m)
		 ;; enlarge the buffer
		 (loop c
		       w
		       (*fx m 2)
		       (let ((new-acc (make-string (*fx m 2))))
			  (blit-string! acc 0 new-acc 0 m)
			  new-acc)))
		((char=? c #\Return)
		 (let ((c2 (read-char port)))
		    (if (char=? c2 #\Newline)
			(substring acc 0 w)
			(begin
			   (string-set! acc w c)
			   (loop c2 (+fx w 1) m acc)))))
		((char=? c #\Newline)
		 ;; shrink the buffer and return 
		 (substring acc 0 w))
		(else
		 ;; fill the buffer
		 (string-set! acc w c)
		 (loop (read-char port) (+fx w 1) m acc)))))))

;*---------------------------------------------------------------------*/
;*    read-lines ...                                                   */
;*---------------------------------------------------------------------*/
(define (read-lines . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (let loop ((l (read-line port))
		 (ls '()))
	 (if (eof-object? l)
	     (reverse! ls)
	     (loop (read-line port) (cons l ls))))))

;*---------------------------------------------------------------------*/
;*    read-string ...                                                  */
;*---------------------------------------------------------------------*/
(define (read-string . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (read/rp (regular-grammar ()
		  ((+ (or all #\Newline)) (the-string))
		  (else ""))
	       port)))
   
;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define *read-of-strings-grammar*
   (regular-grammar ()
      ((+ (in #\space #\tab #\newline))
       (ignore))
      ((+ (out #\space #\tab #\newline))
       (the-string))))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define (read-of-strings . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (read/rp *read-of-strings-grammar* port)))

;*---------------------------------------------------------------------*/
;*    read-chars ...                                                   */
;*---------------------------------------------------------------------*/
(define (read-chars len . input-port)
   (if (<fx len 0)
       (error 'read-chars "Illegal length" len)
       (let* ((s (c-make-string/wo-fill len))
	      (p (if (pair? input-port) (car input-port) (current-input-port)))
	      (n ($rgc-blit-string! p s 0 len)))
	  (cond
	     ((=fx n 0)
	      (if (rgc-buffer-eof? p)
		  beof
		  ""))
	     ((<fx n len)
	      (string-shrink! s n))
	     (else
	      s)))))

;*---------------------------------------------------------------------*/
;*    read-chars! ...                                                  */
;*---------------------------------------------------------------------*/
(define (read-chars! buf len . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      ($rgc-blit-string! port buf 0 len)))

;*---------------------------------------------------------------------*/
;*    read-fill-string! ...                                            */
;*---------------------------------------------------------------------*/
(define (read-fill-string! s o len . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      ($rgc-blit-string! port s o len)))

;*---------------------------------------------------------------------*/
;*    port->string-list ...                                            */
;*---------------------------------------------------------------------*/
(define (port->string-list ip)
   (let loop ((res '()))
      (let ((exp (read-of-strings ip)))
	 (if (eof-object? exp)
	     (reverse! res)
	     (loop (cons exp res))))))

;*---------------------------------------------------------------------*/
;*    %sendchars ...                                                   */
;*    -------------------------------------------------------------    */
;*    Internal Scheme implementation of sendchars for back-ends        */
;*    (e.g., JVM and .NET) that don't support the sendfile             */
;*    system call.                                                     */
;*---------------------------------------------------------------------*/
(define (%sendchars::int ip::input-port op::output-port sz::long offset::long)
   (when (>=fx offset 0)
      (set-input-port-position! ip offset))
   (let* ((bufsize (cond
		      ((=fx sz -1)
		       (c-input-port-bufsiz ip))
		      ((<fx c-default-io-bufsiz sz)
		       c-default-io-bufsiz)
		      (else
		       sz)))
	  (buf (make-string bufsize))
	  (chars-to-read bufsize)
	  (chars-read 0))
      (if (<fx sz 0)
	  (let loop ((chars-read 0))
	     (let ((n (read-chars! buf bufsize ip)))
		(if (=fx n 0)
		    chars-read
		    (let ((s (if (<fx n bufsize) (substring buf 0 n) buf)))
		       (display s op)
		       (loop (+fx chars-read n))))))
	  (let loop ((chars-read 0)
		     (chars-to-read bufsize)
		     (sz sz))
	     (if (=fx chars-to-read 0)
		 chars-read
		 (let ((n (read-chars! buf chars-to-read ip)))
		    (if (=fx n 0)
			chars-read
			(let ((s (if (<fx n bufsize) (substring buf 0 n) buf)))
			   (display s op)
			   (let* ((sz (-fx sz n))
				  (ctr (if (<fx sz bufsize) sz bufsize)))
			      (loop (+fx chars-read n) ctr sz))))))))))

;*---------------------------------------------------------------------*/
;*    send-chars ...                                                   */
;*---------------------------------------------------------------------*/
(define (send-chars::long ip::input-port op::output-port . obj)
   (let ((sz::long (cond
		      ((null? obj) -1)
		      ((fixnum? (car obj)) (car obj))
		      ((elong? (car obj)) (elong->fixnum (car obj)))
		      (else (error 'send-chars "Illegal count" obj))))
	 (offset::long (cond
			  ((null? obj) -1)
			  ((null? (cdr obj)) -1)
			  ((fixnum? (cadr obj)) (cadr obj))
			  ((elong? (cadr obj)) (elong->fixnum (cadr obj)))
			  (else (error 'send-chars "Illegal offset" obj)))))
      (cond-expand
	 (bigloo-c
	  (or ($sendchars ip op sz offset)
	      (%sendchars ip op sz offset)))
	 (else
	  (%sendchars ip op sz offset)))))

;*---------------------------------------------------------------------*/
;*    file-lines ...                                                   */
;*    -------------------------------------------------------------    */
;*    Returns a list of lines start/stop positions.                    */
;*---------------------------------------------------------------------*/
(define (file-lines file)
   (define gram
      (regular-grammar (start)
	 (#\Newline
	  (let* ((stop (input-port-position (the-port)))
		 (desc (cons start stop)))
	     (set! start (+fx 1 stop))
	     (cons desc (ignore))))
	 ((+ all)
	  (ignore))
	 (else
	  (let ((c (the-failure)))
	     (if (eof-object? c)
		 (let ((stop (input-port-position (the-port))))
		    (if (>fx stop start)
			(list (cons start stop))
			'()))
		 (error 'file-lines "Illegal files" file))))))
   (if (not (file-exists? file))
       #f
       (with-input-from-file file
	  (lambda ()
	     (read/rp gram (current-input-port) 0)))))

;*---------------------------------------------------------------------*/
;*    file-position->line ...                                          */
;*---------------------------------------------------------------------*/
(define (file-position->line pos fdesc)
   (cond
      ((pair? fdesc)
       (let loop ((flines fdesc)
		  (line 1))
	  (cond
	     ((null? flines)
	      #f)
	     ((>=fx pos (cdar flines))
	      (loop (cdr flines) (+fx line 1)))
	     (else
	      line))))
      ((string? fdesc)
       (let ((gram (regular-grammar (pos line)
		      (#\Newline
		       (if (>=fx (input-port-position (the-port)) pos)
			   line
			   (begin
			      (set! line (+fx line 1))
			      (ignore))))
		      ((+ all)
		       (ignore))
		      (else
		       (let ((c (the-failure)))
			  (if (eof-object? c)
			      '()
			      (error 'file-position->line
				     "Illegal files"
				     fdesc)))))))
	  (if (not (file-exists? fdesc))
	      #f
	      (with-input-from-file fdesc
		 (lambda ()
		    (read/rp gram (current-input-port) pos 1))))))
      (else
       (error 'file-position->line "Illegal file description" fdesc))))
       
