;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/intext.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano & Pierre Weis                      */
;*    Creation    :  Tue Jan 18 08:11:58 1994                          */
;*    Last change :  Thu Oct  6 10:33:10 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The serialization process does not make hypothesis on word's     */
;*    size.                                                            */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/body.texi@                                */
;*       @node Object Dumping@                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __intext
   
   (import  __error
	    __hash
	    __thread
	    __r4_symbols_6_4
	    __bexit
	    __param)

   (use     __type
	    __bigloo
	    __structure
	    __tvector
	    __bit
	    __object
	    __dsssl
	    __ucs2
	    __unicode
	    
	    __process
	    __custom
	    __date
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __evenv)

   (extern  (macro cnst->integer::long (::obj)
		   "CCNST")
	    (macro integer->cnst::obj (::long)
		   "BCNST")
	    (macro pointer?::bool (::obj)
		   "POINTERP")
	    (macro size-of-long::long
		   "sizeof( long )")
	    (macro struct-mark-offset::long
		   "STRUCTURE_MARK_OFFSET")
	    (macro %%mark-string!::obj (::bstring)
		   "MARK_INTEXT_STRING")
	    (macro %%unmark-string!::obj (::bstring)
		   "UNMARK_INTEXT_STRING")
	    (macro %%string-marked?::bool (::bstring)
		   "INTEXT_STRING_MARKED_P")
	    (macro %struct-mark::obj (::struct) "STRUCT_KEY")
	    (macro %struct-mark-set!::obj (::struct ::obj) "STRUCT_KEY_SET")
	    (export string->obj "string_to_obj")
	    (export obj->string "obj_to_string"))
   
   (java    (class foreign
	       (method static cnst->integer::long (::obj)
		       "CCNST")
	       (method static integer->cnst::obj (::long)
		       "BCNST")
	       (method static pointer?::bool (::obj)
 		       "POINTERP")
	       (field static size-of-long::long
		       "SIZEOFLONG")
	       (field static struct-mark-offset::long
		       "STRUCTURE_MARK_OFFSET")
	       (method static %%mark-string!::obj (::bstring)
		       "MARK_INTEXT_STRING")
	       (method static %%unmark-string!::obj (::bstring)
		       "UNMARK_INTEXT_STRING")
	       (method static %%string-marked?::bool (::bstring)
		       "INTEXT_STRING_MARKED_P")
	       (method static %struct-mark::obj (::struct) "STRUCT_KEY")
	       (method static %struct-mark-set!::obj (::struct ::obj) "STRUCT_KEY_SET"))
	    (export string->obj "string_to_obj")
	    (export obj->string "obj_to_string"))
   
   (export  (string->obj ::bstring)
	    (obj->string::bstring ::obj)
	    (set-obj-string-mode! ::obj)
	    (register-custom-serialization ::bstring ::procedure ::procedure)
	    (register-procedure-serialization ::procedure ::procedure)
	    (register-process-serialization ::procedure ::procedure)
	    (register-opaque-serialization ::procedure ::procedure))
   
   (option  (set! *unsafe-type*   #t)
	    (set! *unsafe-arity*  #t)
	    (set! *unsafe-range*  #t)
	    (set! *unsafe-struct* #t))
   
   (pragma  (string->obj side-effect-free)
	    (obj->string side-effect-free)
	    (cnst->integer nesting)
	    (integer->cnst nesting)
	    (pointer? nesting)))

;*---------------------------------------------------------------------*/
;*    for  ....                                                        */
;*---------------------------------------------------------------------*/
(define-macro (for var min max . body)
   (let ((loop (gensym 'for)))
      `(let ,loop ((,var ,min))
	    (if (<=fx ,var ,max)
		(begin
		   ,@body
		   (,loop (+fx ,var 1)))
		'done))))

;*---------------------------------------------------------------------*/
;*    Les variables de controle de `string->obj'                       */
;*---------------------------------------------------------------------*/
(define *ref-vector* '#())
(define *defining* #f)
(define *pointeur* 0)
(define *nb-ref* 0)
(define *ref* 0)
(define *epair?* #t)

(define *mutex-intern* (make-mutex "intern"))
(define *mutex-extern* (make-mutex "extern"))

;*---------------------------------------------------------------------*/
;*    *buffer*                                                         */
;*---------------------------------------------------------------------*/
(define *buffer* "")
(define *buffer-len*  0)

(define *input-buffer* "")

;*---------------------------------------------------------------------*/
;*    verifie-taille-buffer ...                                        */
;*---------------------------------------------------------------------*/
(define (verifie-taille-buffer! taille)
   (let ((l (+fx *pointeur* (+fx taille (+fx *taille-du-mot-maximum* 1)))))
      (if (>=fx l *buffer-len*)
	  (begin
	     (let ((vieille-longeur *buffer-len*)
		   (vieux-buffer    *buffer*))
		(set! *buffer-len* (*fx 2 (+fx l 100)))
		(set! *buffer* (make-string *buffer-len*))
		(blit-string-ur! vieux-buffer 0 *buffer*
				 0 vieille-longeur))))))

;*---------------------------------------------------------------------*/
;*    set-obj-string-mode! ...                                         */
;*    -------------------------------------------------------------    */
;*    That function control whenever extended pair must be outputed    */
;*    as usual pair (loosing the cer slot) or as specific extended     */
;*    pairs.                                                           */
;*---------------------------------------------------------------------*/
(define (set-obj-string-mode! mode)
   (case mode
      ((epair)
       (set! *epair?* #t))
      ((pair)
       (set! *epair?* #f))))

;*---------------------------------------------------------------------*/
;*    read-taille ...                                                  */
;*---------------------------------------------------------------------*/
(define (read-taille::int s)
   (let ((accu-entier::int 0))
      (let ((taille::int (char->integer (string-ref s *pointeur*))))
	 (set! *pointeur* (+fx *pointeur* 1))
	 (for i 0 (-fx taille 1)
	      (let ((d (string-ref s *pointeur*)))
		 (set! accu-entier (+fx (*fx 256 accu-entier)
					(char->integer d)))
		 (set! *pointeur* (+fx *pointeur* 1))))
	 accu-entier)))

;*---------------------------------------------------------------------*/
;*    read-nombre-entier ...                                           */
;*---------------------------------------------------------------------*/
(define (read-nombre-entier s)
   (read-taille s))

;*---------------------------------------------------------------------*/
;*    read-di ...                                                      */
;*---------------------------------------------------------------------*/
(define (read-di)
   (read-nombre-entier *input-buffer*))

;*---------------------------------------------------------------------*/
;*    read-nombre-flottant ...                                         */
;*---------------------------------------------------------------------*/
(define (read-nombre-flottant s)
   (let* ((taille (read-taille s))
	  (res    (string->real (substring s
					   *pointeur*
					   (+fx *pointeur* taille)))))
      (set! *pointeur* (+fx *pointeur* taille))
      res))

;*---------------------------------------------------------------------*/
;*    read-df ...                                                      */
;*---------------------------------------------------------------------*/
(define (read-df)
   (read-nombre-flottant *input-buffer*))

;*---------------------------------------------------------------------*/
;*    read-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-char s)
   (integer->char (read-nombre-entier s)))

;*---------------------------------------------------------------------*/
;*    read-da ...                                                      */
;*---------------------------------------------------------------------*/
(define (read-da)
   (read-char *input-buffer*))

;*---------------------------------------------------------------------*/
;*    read-string ...                                                  */
;*---------------------------------------------------------------------*/
(define (read-string s)
   (let* ((taille (read-taille s))
	  (res    (substring s *pointeur* (+fx *pointeur* taille))))
      (if (fixnum? *defining*)
	  (begin
	     (vector-set! *ref-vector* *defining* res)
	     (set! *defining* #f)))
      (set! *pointeur* (+fx *pointeur* taille))
      res))

;*---------------------------------------------------------------------*/
;*    read-block ...                                                   */
;*    -------------------------------------------------------------    */
;*    This function implements an implicit cast from bstring to        */
;*    string. READ-BLOCK is supposed to be called from C.              */
;*---------------------------------------------------------------------*/
(define (read-block::string)
   (read-string *input-buffer*))

;*---------------------------------------------------------------------*/
;*    @deffn string->obj@ ...                                          */
;*---------------------------------------------------------------------*/
(define (string->obj s)
   (define (read-definition)
      (set! *defining* (read-item))
      (read-item))
   (define (read-reference)
      (vector-ref *ref-vector* (read-item)))
   (define (read-symbol)
      (string->symbol (read-item)))
   (define (read-keyword)
      (string->keyword (read-item)))
   (define (read-cnst)
      (integer->cnst (read-nombre-entier s)))
   (define (read-ucs2)
      (integer->ucs2 (read-nombre-entier s)))
   (define (read-custom)
      (let* ((str (read-string s))
	     (unserializer (find-custom-unserializer str)))
	 (if (not (procedure? unserializer))
	     (error "string->obj" "Can't unserialize custom object" str)
	     (let ((old *input-buffer*))
		(set! *input-buffer* s)
		(let ((res (unserializer)))
		   (set! *input-buffer* old)
		   res)))))
   (define (read-elong)
      (let* ((taille (read-taille s))
	     (res    (string->elong (substring s
					       *pointeur*
					       (+fx *pointeur* taille)))))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-llong)
      (let* ((taille (read-taille s))
	     (res    (string->llong (substring s
					       *pointeur*
					       (+fx *pointeur* taille)))))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-vecteur)
      (let* ((taille (read-taille s))
 	     (res    (c-create-vector taille)))
	 (if (fixnum? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-vecteur-tague)
      (let* ((tag    (read-item))
	     (taille (read-taille s))
	     (res    (c-create-vector taille)))
	 (vector-tag-set! res tag)
	 (if (fixnum? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-vecteur-type)
      (let* ((id (read-item))
	     (v  (read-item))
	     (tv (vector->tvector id v)))
	 (if (fixnum? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* tv)
		(set! *defining* #f)))
	 tv))
   (define (read-liste)
      (let* ((taille (read-taille s))
	     (res    (cons '() '())))
	 (if (fixnum? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (let loop ((i  0)
		    (hd res))
	    (if (=fx i (-fx taille 2))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (read-item)))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (cons '() '()))
		   (loop (+fx i 1) (cdr hd)))))
	 res))
   (define (read-extended-liste)
      (let* ((taille (read-taille s))
	     (res    (econs '() '() #unspecified)))
	 (if (fixnum? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (let loop ((i  0)
		    (hd res))
	    (if (=fx i (-fx taille 2))
		(begin
		   (set-car! hd (read-item))
		   (set-cer! hd (read-item))
		   (set-cdr! hd (read-item)))
		(begin
		   (set-car! hd (read-item))
		   (set-cer! hd (read-item))
		   (set-cdr! hd (econs '() '() #unspecified))
		   (loop (+fx i 1) (cdr hd)))))
	 res))
   (define (read-cellule)
      (let ((res (make-cell (unspecified))))
	 (if (fixnum? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (cell-set! res (read-item))
	 res))
   (define (read-special s converter)
      ;; unserialize a procedure, a process or an opaque
      (let* ((taille (read-taille s))
	     (res    (substring s *pointeur* (+fx *pointeur* taille))))
	 (if (fixnum? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (set! *pointeur* (+fx *pointeur* taille))
	 (converter res)))
   (define (read-structure)
      (let* ((defining (let ((old *defining*))
			  (set! *defining* #f)
			  old))
	     (key      (read-item))
	     (taille   (read-taille s))
	     (res      (make-struct key taille (unspecified))))
	 (if (fixnum? defining)
	     (vector-set! *ref-vector* defining res))
	 (for i 0 (-fx taille 1)
	      (begin
		 (struct-set! res i (read-item))))
	 res))
   (define (read-object)
      (let* ((defining (let ((old *defining*))
			  (set! *defining* #f)
			  old))
	     (key      (read-item))
	     (taille   (read-taille s))
	     (struct   (make-struct key taille (unspecified)))
	     (object   (allocate-instance key)))
	 (if (fixnum? defining)
	     (vector-set! *ref-vector* defining object))
	 (for i 0 (-fx taille 1)
	      (struct-set! struct i (read-item)))
	 (let ((hash (read-item)))
	    (if (=fx hash (class-hash (object-class object)))
		(struct+object->object object struct)
		(error "string->obj" "corrupted class" object)))))
   (define (read-item)
      (let ((d (string-ref s *pointeur*)))
	 (set! *pointeur* (+fx *pointeur* 1))
	 (case d
	    ((#\=) (read-definition))
	    ((#\#) (read-reference))
	    ((#\') (read-symbol))
	    ((#\:) (read-keyword))
	    ((#\a) (read-char s))
	    ((#\u) (read-ucs2))
	    ((#\F) #f)
	    ((#\T) #t)
	    ((#\;) #unspecified)
	    ((#\.) '())
	    ((#\<) (read-cnst))
	    ((#\") (read-string s))
	    ((#\U) (utf8-string->ucs2-string (read-string s)))
	    ((#\[) (read-vecteur))
	    ((#\t) (read-vecteur-tague))
	    ((#\V) (read-vecteur-type))
	    ((#\() (read-liste))
	    ((#\^) (read-extended-liste))
	    ((#\{) (read-structure))
	    ((#\|) (read-object))
	    ((#\f) (read-nombre-flottant s))
	    ((#\-) (negfx (read-nombre-entier s)))
	    ((#\!) (read-cellule))
	    ((#\+) (read-custom))
	    ((#\E) (read-elong))
	    ((#\L) (read-llong))
	    ((#\p) (read-special s *string->procedure*))
	    ((#\e) (read-special s *string->process*))
	    ((#\o) (read-special s *string->opaque*))
	    ((#\d) (seconds->date (string->elong (read-string s))))
	    (else  (set! *pointeur* (-fx *pointeur* 1))
		   (read-nombre-entier s)))))
   (mutex-lock! *mutex-intern*)
   (unwind-protect
      (begin
	 (set! *pointeur* 0)
	 (let ((d (string-ref s *pointeur*)))
	    (if (char=? d #\c)
		(begin
		   (set! *pointeur* (+fx *pointeur* 1))
		   (set! *ref-vector* (make-vector (read-taille s))))))
	 (read-item))
      (mutex-unlock! *mutex-intern*)))

;*---------------------------------------------------------------------*/
;*    les structures de marks                                          */
;*---------------------------------------------------------------------*/
(define-struct mark obj old-value ref defined? ref-count aux)

;*---------------------------------------------------------------------*/
;*    incr-mark-ref-count! ...                                         */
;*---------------------------------------------------------------------*/
(define (incr-mark-ref-count! mark ref)
   (let ((old-mark (mark-ref-count mark)))
      (mark-ref-count-set! mark (+fx 1 old-mark))
      (if (=fx old-mark 0)
	  (+fx ref 1)
	  ref)))

;*---------------------------------------------------------------------*/
;*    pair-unmark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-unmark! pair)
   (let ((old-value (mark-old-value (get-pair-mark pair))))
      (set-cdr! pair old-value)))

;*---------------------------------------------------------------------*/
;*    pair-mark! ...                                                   */
;*---------------------------------------------------------------------*/
(define (pair-mark! pair)
   (let ((new (make-mark)))
      (mark-obj-set!       new pair)
      (mark-old-value-set! new (cdr pair))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (set-cdr! pair new)
      new))

;*---------------------------------------------------------------------*/
;*    pair-marked? ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-marked? pair)
   (mark? (cdr pair)))

;*---------------------------------------------------------------------*/
;*    get-pair-mark ...                                                */
;*---------------------------------------------------------------------*/
(define (get-pair-mark pair)
   (cdr pair))

;*---------------------------------------------------------------------*/
;*    *pointer-table* ...                                              */
;*---------------------------------------------------------------------*/
(define *pointer-table* '())

;*---------------------------------------------------------------------*/
;*    pointer-unmark! ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-unmark! ptr)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    pointer-mark! ...                                                */
;*---------------------------------------------------------------------*/
(define (pointer-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new #unspecified)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (set! *pointer-table* (cons (cons ptr new) *pointer-table*))
      new))

;*---------------------------------------------------------------------*/
;*    pointer-marked? ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-marked? ptr)
   (pair? (assq ptr *pointer-table*)))

;*---------------------------------------------------------------------*/
;*    get-pointer-mark ...                                             */
;*---------------------------------------------------------------------*/
(define (get-pointer-mark ptr)
   (cdr (assq ptr *pointer-table*)))

;*---------------------------------------------------------------------*/
;*    cell-unmark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-unmark! cell)
   (let ((old-value (mark-old-value (get-cell-mark cell))))
      (cell-set! cell old-value)))

;*---------------------------------------------------------------------*/
;*    cell-mark! ...                                                   */
;*---------------------------------------------------------------------*/
(define (cell-mark! cell)
   (let ((new (make-mark)))
      (mark-obj-set!       new cell)
      (mark-old-value-set! new (cell-ref cell))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (cell-set! cell new)
      new))

;*---------------------------------------------------------------------*/
;*    cell-marked? ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-marked? cell)
   (mark? (cell-ref cell)))

;*---------------------------------------------------------------------*/
;*    get-cell-mark ...                                                */
;*---------------------------------------------------------------------*/
(define (get-cell-mark cell)
   (cell-ref cell))

;*---------------------------------------------------------------------*/
;*    *string-mark-table* ...                                          */
;*---------------------------------------------------------------------*/
(define *string-mark-table* '())

;*---------------------------------------------------------------------*/
;*    string-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (string-unmark! ptr)
   (%%unmark-string! ptr))

;*---------------------------------------------------------------------*/
;*    string-mark! ...                                                 */
;*    -------------------------------------------------------------    */
;*    Strings have been allocated has atomic (i.e. not containing      */
;*    pointers). The marking process stores a pointer into the string  */
;*    length field thus, this pointer is not traced by the collector.  */
;*    To fix this, we also put this pointer into a table: the          */
;*    *string-mark-table*                                              */
;*---------------------------------------------------------------------*/
(define (string-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (mark-old-value-set! new (string-length ptr))
      (hashtable-put! *string-mark-table* ptr new)
      (%%mark-string! ptr)
      new))

;*---------------------------------------------------------------------*/
;*    string-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (string-marked? ptr)
   (%%string-marked? ptr))

;*---------------------------------------------------------------------*/
;*    get-string-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-string-mark ptr)
   (string-unmark! ptr)
   (let ((mark (hashtable-get *string-mark-table* ptr)))
      (if (not mark)
	  (error "obj->string" "Illegal string" ptr)
	  (begin
	     (%%mark-string! ptr)
	     mark))))

;*---------------------------------------------------------------------*/
;*    get-ucs2-string-utf8-string ...                                  */
;*---------------------------------------------------------------------*/
(define (get-ucs2-string-utf8-string ptr)
   (let ((mark (hashtable-get *string-mark-table* ptr)))
      (if (not mark)
	  (error "obj->string" "Illegal ucs2-string" ptr)
	  mark)))

;*---------------------------------------------------------------------*/
;*    set-ucs2-string-utf8-string! ...                                 */
;*---------------------------------------------------------------------*/
(define (set-ucs2-string-utf8-string! ptr new)
   (hashtable-put! *string-mark-table* ptr new))

;*---------------------------------------------------------------------*/
;*    custom-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (custom-marked? ptr)
   (eq? (custom-identifier ptr) ""))

;*---------------------------------------------------------------------*/
;*    custom-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (custom-mark! ptr)
   (let ((new  (make-mark))
	 (hash (get-custom-hash-table))
	 (id   (custom-identifier ptr)))
      (mark-obj-set!       new ptr)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (mark-old-value-set! new id)
      (hashtable-put! hash (custom-hash ptr 10) new)
      (custom-identifier-set! new "")
      new))

;*---------------------------------------------------------------------*/
;*    custom-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (custom-unmark! custom)
   (let ((mark (get-custom-mark custom)))
      (custom-identifier-set! custom (mark-old-value mark))
      custom))

;*---------------------------------------------------------------------*/
;*    get-custom-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-custom-mark ptr)
   (let ((ctm (hashtable-get (get-custom-hash-table) (custom-hash ptr 10))))
      (if (not ctm)
	  (error "obj->string" "Illegal custom" #unspecified)
	  ctm)))

;*---------------------------------------------------------------------*/
;*    *custom-mark-table* ...                                          */
;*---------------------------------------------------------------------*/
(define *custom-mark-table* #unspecified)

;*---------------------------------------------------------------------*/
;*    get-custom-hash-table ...                                        */
;*---------------------------------------------------------------------*/
(define (get-custom-hash-table)
   (if (not (hashtable? *custom-mark-table*))
       (set! *custom-mark-table* (make-hashtable 1024)))
   *custom-mark-table*)

;*---------------------------------------------------------------------*/
;*    vector-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (vector-unmark! ptr)
   (let ((old-value (mark-old-value (get-vector-mark ptr))))
      (vector-set! ptr 0 old-value)))

;*---------------------------------------------------------------------*/
;*    vector-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (vector-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (vector-ref ptr 0))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (vector-set! ptr 0 new)
      new))

;*---------------------------------------------------------------------*/
;*    vector-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (vector-marked? ptr)
   (mark? (get-vector-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-vector-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-vector-mark ptr)
   (vector-ref ptr 0))

;*---------------------------------------------------------------------*/
;*    *tvector-table* ...                                              */
;*---------------------------------------------------------------------*/
(define *tvector-table* '())

;*---------------------------------------------------------------------*/
;*    tvector-unmark! ...                                              */
;*---------------------------------------------------------------------*/
(define (tvector-unmark! ptr)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    tvector-mark! ...                                                */
;*---------------------------------------------------------------------*/
(define (tvector-mark! ptr v)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new #unspecified)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (mark-aux-set!       new v)
      (set! *tvector-table* (cons (cons ptr new) *tvector-table*))
      new))

;*---------------------------------------------------------------------*/
;*    tvector-marked? ...                                              */
;*---------------------------------------------------------------------*/
(define (tvector-marked? ptr)
   (pair? (assq ptr *tvector-table*)))

;*---------------------------------------------------------------------*/
;*    get-tvector-mark ...                                             */
;*---------------------------------------------------------------------*/
(define (get-tvector-mark ptr)
   (cdr (assq ptr *tvector-table*)))

;*---------------------------------------------------------------------*/
;*    mark-tvector->vector ...                                         */
;*---------------------------------------------------------------------*/
(define (mark-tvector->vector ptr)
   (mark-aux (get-tvector-mark ptr)))

;*---------------------------------------------------------------------*/
;*    struct-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (struct-unmark! ptr)
   (let ((old-value (mark-old-value (get-struct-mark ptr))))
      (%struct-mark-set! ptr old-value)))

;*---------------------------------------------------------------------*/
;*    struct-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (struct-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (%struct-mark ptr))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (%struct-mark-set! ptr new)
      new))

;*---------------------------------------------------------------------*/
;*    struct-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (struct-marked? ptr)
   (mark? (get-struct-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-struct-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-struct-mark ptr)
   (%struct-mark ptr))

;*---------------------------------------------------------------------*/
;*    object-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (object-mark! ptr struct)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (object-widening ptr))
      (mark-aux-set!       new struct)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (object-widening-set! ptr new)
      new))

;*---------------------------------------------------------------------*/
;*    object-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (object-unmark! ptr)
   (let ((old-value (mark-old-value (get-object-mark ptr))))
      (object-widening-set! ptr old-value)))

;*---------------------------------------------------------------------*/
;*    object-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (object-marked? ptr)
   (mark? (get-object-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-object-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-object-mark ptr)
   (object-widening ptr))

;*---------------------------------------------------------------------*/
;*    mark-object->struct ...                                          */
;*---------------------------------------------------------------------*/
(define (mark-object->struct ptr)
   (mark-aux (get-object-mark ptr)))

;*---------------------------------------------------------------------*/
;*    *taille-du-mot-maximum* ...                                      */
;*---------------------------------------------------------------------*/
(define *taille-du-mot-maximum* size-of-long)

;*---------------------------------------------------------------------*/
;*    taille-du-mot ...                                                */
;*---------------------------------------------------------------------*/
(define (taille-du-mot m)
   (let loop ((taille 0)
	      (m      m))
      (if (=fx m 0)
	  taille
	  (loop (+fx taille 1)
		(bit-rsh m 8)))))

;*---------------------------------------------------------------------*/
;*    print-marqueur ...                                               */
;*---------------------------------------------------------------------*/
(define (print-marqueur c)
   (verifie-taille-buffer! 0)
   (string-set! *buffer* *pointeur* c)
   (set! *pointeur* (+fx *pointeur* 1)))

;*---------------------------------------------------------------------*/
;*    print-int-as-char ...                                            */
;*---------------------------------------------------------------------*/
(define (print-int-as-char c)
   (print-marqueur (integer->char c)))

;*---------------------------------------------------------------------*/
;*    print-mot ...                                                    */
;*---------------------------------------------------------------------*/
(define (print-mot m)
   (let ((taille (taille-du-mot m)))
      (if (=fx taille 0)
	  (print-int-as-char 0)
	  (begin
	     (print-int-as-char taille)
	     (let loop ((i (-fx taille 1)))
		(if (=fx i -1)
		    'done
		    (begin
		       (let ((d (bit-and (bit-rsh m (*fx 8 i)) #xff)))
			  (print-int-as-char d)
			  (loop (-fx i 1))))))))))

;*---------------------------------------------------------------------*/
;*    print-di ...                                                     */
;*    -------------------------------------------------------------    */
;*    Serialize a fixnum                                               */
;*---------------------------------------------------------------------*/
(define (print-di i::long)
   (verifie-taille-buffer! 0)
   (if (<fx i 0)
       (begin
	  (string-set! *buffer* *pointeur* #\-)
	  (set! *pointeur* (+fx *pointeur* 1))
	  (print-mot (negfx i)))
       (print-mot i)))

;*---------------------------------------------------------------------*/
;*    print-chars ...                                                  */
;*---------------------------------------------------------------------*/
(define (print-chars s taille)
   (print-taille taille)
   ;; we can't use BLIT-STRING here, we have to use BLIT-STRING-UR because
   ;; the string sizes might be incorrect
   (blit-string-ur! s 0 *buffer* *pointeur* taille)
   (set! *pointeur* (+fx *pointeur* taille)))

;*---------------------------------------------------------------------*/
;*    print-block ...                                                  */
;*    -------------------------------------------------------------    */
;*    This function implements an implicit cast from string to         */
;*    bstring (print-block is supposed to be called from C).           */
;*---------------------------------------------------------------------*/
(define (print-block s::string len::long)
   (print-chars s len))

;*---------------------------------------------------------------------*/
;*    print-taille ...                                                 */
;*---------------------------------------------------------------------*/
(define (print-taille taille)
   (verifie-taille-buffer! taille)     
   (print-mot taille))

;*---------------------------------------------------------------------*/
;*    print-df ...                                                     */
;*    -------------------------------------------------------------    */
;*    Serialize of flonum.                                             */
;*---------------------------------------------------------------------*/
(define (print-df f::double)
   (let ((s (real->string f)))
      (print-chars s (string-length s))))

;*---------------------------------------------------------------------*/
;*    print-de ...                                                     */
;*    -------------------------------------------------------------    */
;*    Serialize of elong                                               */
;*---------------------------------------------------------------------*/
(define (print-de e::elong)
   (let ((s (elong->string e)))
      (print-chars s (string-length s))))

;*---------------------------------------------------------------------*/
;*    print-dll ...                                                    */
;*    -------------------------------------------------------------    */
;*    Serialize of llong                                               */
;*---------------------------------------------------------------------*/
(define (print-dll l::llong)
   (let ((s (llong->string l)))
      (print-chars s (string-length s))))

;*---------------------------------------------------------------------*/
;*    print-da ...                                                     */
;*---------------------------------------------------------------------*/
(define (print-da c::char)
   (print-marqueur #\a)
   (print-di (char->integer c)))

;*---------------------------------------------------------------------*/
;*    @deffn obj->string@ ...                                          */
;*---------------------------------------------------------------------*/
(define (obj->string obj)
   (set! *ref*      -1)
   (set! *nb-ref*   0)
   (set! *pointeur* 0)
   (set! *buffer-len* 100)
   (set! *buffer* (make-string *buffer-len* #\space))
   (define (get-new-ref)
      (set! *ref* (+fx *ref* 1))
      *ref*)
   (define (print-dv v ref0 len)
      (print-taille len)
      (if (>fx len 0)
	  (print-item ref0))
      (for i 1 (-fx len 1)
	   (print-item (vector-ref-ur v i))))
   (define (print-du v len)
      (print-taille len)
      (for i 0 (-fx len 1)
	   (print-item (struct-ref v i))))
   (define (pair-mark-gc! p)
      (let ((mark (get-pair-mark p)))
	 (if (and (mark-defined? mark)
		  (>fx (mark-ref-count mark) 0))
	     (mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
	     (pair-unmark! p))))
   (define (print-dl p len)
      (print-taille len)
      (let loop ((i 0)
		 (p p))
	 (cond
	    ((=fx i (-fx len 1))
	     (if (pair? p)
		 (begin
		    (print-item (car p))
		    (print-item '())
		    (pair-mark-gc! p))
		 (print-item p)))
	    (else
	     (let* ((mark (get-pair-mark p))
		    (vcdr (mark-old-value mark)))
		(print-item (car p))
		(pair-mark-gc! p)
		(if (and (pair? vcdr)
			 (let ((mark (get-pair-mark vcdr)))
			    (or (> (mark-ref-count mark) 0)
				(mark-defined? mark))))
		    (print-item vcdr)
		    (loop (+fx i 1) vcdr)))))))
   (define (print-edl p len)
      (print-taille len)
      (let loop ((i 0)
		 (p p))
	 (cond
	    ((=fx i (-fx len 1))
	     (if (pair? p)
		 (begin
		    (print-item (car p))
		    (if (epair? p)
			(print-item (cer p))
			(print-item #unspecified))
		    (print-item '())
		    (pair-mark-gc! p))
		 (print-item p)))
	    (else
	     (let* ((mark (get-pair-mark p))
		    (vcdr (mark-old-value mark)))
		(print-item (car p))
		(if (epair? p)
		    (print-item (cer p))
		    (print-item #unspecified))
		(pair-mark-gc! p)
		(if (and (pair? vcdr)
			 (let ((mark (get-pair-mark vcdr)))
			    (or (> (mark-ref-count mark) 0)
				(mark-defined? mark))))
		    (print-item vcdr)
		    (loop (+fx i 1) vcdr)))))))
   (define (print-struct marqueur item)
      (cond
	 ((mark-defined? (get-struct-mark item))
	  (print-marqueur #\#)
	  (print-di (mark-ref (get-struct-mark item)))
	  (mark-ref-count-set! (get-struct-mark item)
			       (-fx (mark-ref-count
				     (get-struct-mark item))
				    1))
	  (if (=fx (mark-ref-count (get-struct-mark item)) 0)
	      (struct-unmark! item)))
	 ((=fx (mark-ref-count (get-struct-mark item)) 0)
	  (struct-unmark! item)
	  (print-marqueur marqueur)
	  (print-item (%struct-mark item))
	  (print-du item (struct-length item)))
	 (else
	  (let* ((ref  (get-new-ref))
		 (mark (get-struct-mark item))
		 (len  (struct-length item))
		 key
		 tag)
	     (begin
		;; il faut momentanement restorer la structure
		(%struct-mark-set! item (mark-old-value mark))
		(set! key (%struct-mark item))
		;; on restore
		(%struct-mark-set! item mark))
	     (mark-ref-set! mark ref)
	     (mark-defined?-set! mark #t)
	     (print-marqueur #\=)
	     (print-di ref)
	     (print-marqueur marqueur)
	     (print-item key)
	     (print-du item len)))))
   (define (print-string marqueur item)
      (let ((mark (get-string-mark item)))
	 (cond
	    ((mark-defined? mark)
	     (print-marqueur #\#)
	     (print-di (mark-ref mark))
	     (mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
	     (if (=fx (mark-ref-count mark) 0)
		 (string-unmark! item)))
	    ((=fx (mark-ref-count mark) 0)
	     (string-unmark! item)
	     (print-marqueur marqueur)
	     (print-chars item (string-length item)))
	    (else
	     (let ((ref (get-new-ref)))
		(mark-ref-set! mark ref)
		(mark-defined?-set! mark #t)
		(print-marqueur #\=)
		(print-di ref)
		(print-marqueur marqueur)
		(print-chars item (mark-old-value mark)))))))
   (define (print-custom marqueur item)
      (let ((mark (get-custom-mark item)))
	 (cond
	    ((mark-defined? mark)
	     (print-marqueur #\#)
	     (print-di (mark-ref mark))
	     (mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
	     (if (=fx (mark-ref-count mark) 0)
		 (custom-unmark! item)))
	    ((=fx (mark-ref-count mark) 0)
	     (custom-unmark! item)
	     (print-marqueur marqueur)
	     (let* ((ident (custom-identifier item))
		    (serializer (find-custom-serializer ident)))
		(if (not (procedure? serializer))
		    (error "obj->string" "unregistered custom" item)
		    (begin
		       (print-chars ident (string-length ident))
		       (serializer item)))))
	    (else
	     (let ((ref  (get-new-ref)))
		(mark-ref-set! mark ref)
		(mark-defined?-set! mark #t)
		(print-marqueur #\=)
		(print-di ref)
		(print-marqueur marqueur)
		(print-chars item (mark-old-value mark)))))))
   (define (print-item item)
      (cond
	 ((object? item)
	  (let ((mark (get-object-mark item)))
	     (cond
		((mark-defined? mark)
		 (print-marqueur #\#)
		 (print-di (mark-ref mark))
		 (mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
		 (if (=fx (mark-ref-count mark) 0)
		     (object-unmark! item)))
		((=fx (mark-ref-count mark) 0)
		 (let ((struct (mark-object->struct item)))
		    (object-unmark! item)
		    (print-struct #\| struct)
		    (print-item (class-hash (object-class item)))))
		(else
		 (let ((ref    (get-new-ref))
		       (struct (mark-object->struct item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-struct #\| struct)
		    (print-item (class-hash (object-class item))))))))
	 ((struct? item)
	  (print-struct #\{ item))
	 ((symbol? item)
	  (print-marqueur #\')
	  (print-string #\" (symbol->string item)))
	 ((keyword? item)
	  (print-marqueur #\:)
	  (print-string #\" (keyword->string item)))
	 ((char? item)
	  (print-da item))
	 ((ucs2? item)
	  (print-marqueur #\u)
	  (print-di (ucs2->integer item)))
	 ((eq? item #unspecified)
	  (print-marqueur #\;))
	 ((eq? item '())
	  (print-marqueur #\.))
	 ((eq? item #t)
	  (print-marqueur #\T))
	 ((eq? item #f)
	  ;; #f is not bound to be a constant. It can be a special
	  ;; value.
	  (print-marqueur #\F))
	 ((cnst? item)
	  (print-marqueur #\<)
	  (print-di (cnst->integer item)))
	 ((fixnum? item)
	  (print-di item))
	 ((real? item)
	  (print-marqueur #\f)
	  (print-df item))
	 ((string? item)
	  (print-string #\" item))
	 ((ucs2-string? item)
	  (print-string #\U (get-ucs2-string-utf8-string item)))
	 ((cell? item)
	  (cond
	     ((mark-defined? (get-cell-mark item))
	      (print-marqueur #\#)
	      (print-di (mark-ref (get-cell-mark item)))
	      (mark-ref-count-set! (get-cell-mark item)
				   (-fx (mark-ref-count
					 (get-cell-mark item))
					1))
	      (if (=fx (mark-ref-count (get-cell-mark item)) 0)
		  (cell-unmark! item)))
	     ((=fx (mark-ref-count (get-cell-mark item)) 0)
	      (cell-unmark! item)
	      (print-marqueur #\!)
	      (print-item (cell-ref item)))
	     (else
	      (let* ((ref  (get-new-ref))
		     (mark (get-cell-mark item))
		     tag
		     len) 
		 (mark-ref-set! mark ref)
		 (mark-defined?-set! mark #t)
		 (print-marqueur #\=)
		 (print-di ref)
		 (print-marqueur #\!)
		 (print-item (mark-old-value mark))))))
	 ((and (epair? item) *epair?*)
	  (cond
	     ((mark-defined? (get-pair-mark item))
	      (print-marqueur #\#)
	      (print-di (mark-ref (get-pair-mark item)))
	      (pair-mark-gc! item))
	     ((=fx (mark-ref-count (get-pair-mark item)) 0)
	      (let ((len (marked-pair-length item)))
		 (print-marqueur #\^)
		 (mark-defined?-set! (get-pair-mark item) #t)
		 (print-edl item len)))
	     (else
	      (let ((ref  (get-new-ref))
		    (mark (get-pair-mark item))
		    (len  (marked-pair-length item)))
		 (mark-ref-set! mark ref)
		 (mark-defined?-set! mark #t)
		 (print-marqueur #\=)
		 (print-di ref)
		 (print-marqueur #\^)
		 (print-edl item len)))))
	 ((pair? item)
	  (cond
	     ((mark-defined? (get-pair-mark item))
	      (print-marqueur #\#)
	      (print-di (mark-ref (get-pair-mark item)))
	      (pair-mark-gc! item))
	     ((=fx (mark-ref-count (get-pair-mark item)) 0)
	      (let ((len (marked-pair-length item)))
		 (print-marqueur #\()
		 (mark-defined?-set! (get-pair-mark item) #t)
		 (print-dl item len)))
	     (else
	      (let ((ref  (get-new-ref))
		    (mark (get-pair-mark item))
		    (len  (marked-pair-length item)))
		 (mark-ref-set! mark ref)
		 (mark-defined?-set! mark #t)
		 (print-marqueur #\=)
		 (print-di ref)
		 (print-marqueur #\()
		 (print-dl item len)))))
	 ((vector? item)
	  (cond
	     ((=fx (vector-length item) 0)
	      (let ((tag (vector-tag item)))
		 (if (>fx tag 0)
		     (begin
			(print-marqueur #\t)
			(print-di tag)
			(print-dv item '() 0))
		     (begin
			(print-marqueur #\[)
			(print-dv item '() 0)))))
	     ((mark-defined? (get-vector-mark item))
	      (print-marqueur #\#)
	      (print-di (mark-ref (get-vector-mark item)))
	      (mark-ref-count-set! (get-vector-mark item)
				   (-fx (mark-ref-count
					 (get-vector-mark item))
					1))
	      (if (=fx (mark-ref-count (get-vector-mark item)) 0)
		  (vector-unmark! item)))
	     ((=fx (mark-ref-count (get-vector-mark item)) 0)
	      (vector-unmark! item)
	      (let ((tag (vector-tag item)))
		 (if (>fx tag 0)
		     (begin
			(print-marqueur #\t)
			(print-di tag)
			(print-dv item
				  (vector-ref item 0)
				  (vector-length item)))
		     (begin
			(print-marqueur #\[)
			(print-dv item
				  (vector-ref item 0)
				  (vector-length item))))))
	     (else
	      (let* ((ref  (get-new-ref))
		     (mark (get-vector-mark item))
		     (tag  (vector-tag item))
		     (len  (vector-length item))
		     ref0)
		 (begin
		    ;; il faut momentanement restorer le vecteur
		    (vector-set! item 0 (mark-old-value mark))
		    (set! ref0 (vector-ref item 0))
		    ;; on restore
		    (vector-set! item 0 mark))
		 (mark-ref-set! mark ref)
		 (mark-defined?-set! mark #t)
		 (print-marqueur #\=)
		 (print-di ref)
		 (if (>fx tag 0)
		     (begin
			(print-marqueur #\t)
			(print-di tag)
			(print-dv item ref0 len))
		     (begin
			(print-marqueur #\[)
			(print-dv item ref0 len)))))))
	 ((custom? item)
	  (print-custom #\+ item))
	 ((tvector? item)
	  (let ((mark (get-tvector-mark item)))
	     (cond
		((mark-defined? mark)
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-tvector-mark item)))
		 (mark-ref-count-set! (get-tvector-mark item)
				      (-fx (mark-ref-count
					    (get-tvector-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-tvector-mark item)) 0)
		     (tvector-unmark! item)))
		((=fx (mark-ref-count mark) 0)
		 (let ((v (mark-tvector->vector item)))
		    (tvector-unmark! item)
		    (print-marqueur #\V)
		    (print-item (tvector-id item))
		    (print-item v)))
		(else
		 (let* ((ref  (get-new-ref))
			(len  (tvector-length item))
			(v    (mark-tvector->vector item))
			id)
		    (set! id (tvector-id item))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\V)
		    (print-item id)
		    (print-item v))))))
	 ((custom? item)
	  (let ((item (*procedure->string* item)))
	     (set! *procedure-table* (cons (cons obj item) *procedure-table*))
	     (mark-item! item)))
	 ((procedure? item)
	  (let ((nitem (cdr (assq item *procedure-table*))))
	     (print-string #\p nitem)))
	 ((process? item)
	  (let ((nitem (cdr (assq item *process-table*))))
	     (print-string #\e nitem)))
	 ((opaque? item)
	  (let ((nitem (cdr (assq item *opaque-table*))))
	     (print-string #\o nitem)))
	 ((elong? item)
	  (print-marqueur #\E)
	  (print-de item))
	 ((llong? item)
	  (print-marqueur #\L)
	  (print-dll item))
	 ((date? item)
	  (print-marqueur #\d)
	  (let ((s (elong->string (date->seconds item))))
	     (print-chars s (string-length s))))
	 (else
	  (error "obj->string" "Unknown object" item))))
   (mutex-lock! *mutex-extern*)
   (unwind-protect
      (begin
	 (set! *string-mark-table*
	       (make-hashtable 1024
			       10
			       eq?
			       (lambda (s) (get-pointer-hashnumber s 16))))
	 (mark-item! obj)
	 (set! *pointeur* 0)
	 (if (>fx *nb-ref* 0)
	     (begin
		(print-marqueur #\c)
		(print-di *nb-ref*)))
	 (print-item obj)
	 (set! *string-mark-table* #unspecified)
	 (set! *custom-mark-table* #unspecified)
	 (substring *buffer* 0 *pointeur*))
      (begin
	 (set! *procedure-table* '())
	 (set! *process-table* '())
	 (set! *opaque-table* '())
	 (set! *tvector-table* '())
	 (set! *pointer-table* '())
	 (set! *buffer-len* 0)
	 (set! *buffer* "")
	 (mutex-unlock! *mutex-extern*))))

;*---------------------------------------------------------------------*/
;*    mark-item! ...                                                   */
;*---------------------------------------------------------------------*/
(define (mark-item! obj)
   (let loop ((obj obj))
      (cond
	 ((object? obj)
	  (if (object-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-object-mark obj)
						   *nb-ref*))
	      (let ((struct (object->struct obj)))
		 (object-mark! obj struct)
		 (loop struct))))
 	 ((struct? obj)
	  (if (struct-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-struct-mark obj)
						   *nb-ref*))
	      (let ((key (%struct-mark obj))
		    (len (struct-length obj)))
		 ;; on marque la cle
		 (loop key)
		 ;; on marque la structure
		 (struct-mark! obj)
		 (let liip ((i 0))
		    (if (=fx i len)
			'done
			(begin
			   (loop (struct-ref obj i))
			   (liip (+fx i 1))))))))
	 ((and (epair? obj) *epair?*)
	  (if (pair-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-pair-mark obj)
						   *nb-ref*))
	      (let ((ocar (car obj))
		    (ocdr (cdr obj))
		    (ocer (cer obj)))
		 ;; on marque la paire
		 (pair-mark! obj)
		 ;; on la parcours
		 (loop ocar)
		 (loop ocer)
		 (loop ocdr))))
	 ((pair? obj)
	  (if (pair-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-pair-mark obj)
						   *nb-ref*))
	      (let ((ocar (car obj))
		    (ocdr (cdr obj)))
		 ;; on marque la paire
		 (pair-mark! obj)
		 ;; on la parcours
		 (loop ocar)
		 (loop ocdr))))
	 ((cell? obj)
	  (if (cell-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-cell-mark obj)
						   *nb-ref*))
	      (let ((oref (cell-ref obj)))
		 ;; on marque la cellule
		 (cell-mark! obj)
		 ;; on la parcours
		 (loop oref))))
	 ((symbol? obj)
	  (loop (symbol->string obj)))
	 ((keyword? obj)
	  (loop (keyword->string obj)))
	 ((real? obj)
	  'done)
	 ((string? obj)
	  (if (string-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-string-mark obj)
						   *nb-ref*))
	      (string-mark! obj)))
	 ((ucs2-string? obj)
	  (let ((str (ucs2-string->utf8-string obj)))
	     (set-ucs2-string-utf8-string! obj str)
	     (loop str)))
	 ((vector? obj)
	  (if (=fx (vector-length obj) 0)
	      'done
	      (if (vector-marked? obj)
		  (set! *nb-ref* (incr-mark-ref-count! (get-vector-mark obj)
						       *nb-ref*))
		  (let ((len (vector-length obj))
			(tag (vector-tag obj)))
		     (loop (vector-ref-ur obj 0))
		     (vector-mark! obj)
		     (let liip ((i 1))
			(if (>=fx i len)
			    'done
			    (begin
			       (loop (vector-ref-ur obj i))
			       (liip (+fx i 1)))))))))
	 ((tvector? obj)
	  (if (tvector-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-tvector-mark obj)
						   *nb-ref*))
	      (let ((v (tvector->vector obj)))
		 (loop (tvector-id obj))
		 (loop v)
		 (tvector-mark! obj v))))
	 ((custom? obj)
	  (if (custom-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-custom-mark obj)
						   *nb-ref*))
	      (custom-mark! obj)))
	 ((procedure? obj)
	  (let ((item (*procedure->string* obj)))
	     (set! *procedure-table* (cons (cons obj item) *procedure-table*))
	     (mark-item! item)))
	 ((process? obj)
	  (let ((item (*process->string* obj)))
	     (set! *process-table* (cons (cons obj item) *process-table*))
	     (mark-item! item)))
	 ((opaque? obj)
	  (let ((item (*opaque->string* obj)))
	     (set! *opaque-table* (cons (cons obj item) *opaque-table*))
	     (mark-item! item)))
	 ((not (pointer? obj))
	  'done)
	 ((pointer-marked? obj) 
	  (set! *nb-ref* (incr-mark-ref-count! (get-pointer-mark obj)
					       *nb-ref*)))
	 (else
	  'done))))

;*---------------------------------------------------------------------*/
;*    marked-pair-length ...                                           */
;*---------------------------------------------------------------------*/
(define (marked-pair-length l)
   (let loop ((l l)
	      (r 1))
      (let* ((mark (get-pair-mark l))
	     (vcdr (mark-old-value mark)))
	 (if (pair? vcdr)
	     (let ((mark (get-pair-mark vcdr)))
		(if (or (> (mark-ref-count mark) 0)
			(mark-defined? mark))
		    (+fx r 1)
		    (loop vcdr (+fx r 1))))
	     (+fx r 1)))))

;*---------------------------------------------------------------------*/
;*    *custom-serialization* ...                                       */
;*---------------------------------------------------------------------*/
(define *custom-serialization* '())

;*---------------------------------------------------------------------*/
;*    register-custom-serialization ...                                */
;*---------------------------------------------------------------------*/
(define (register-custom-serialization ident serializer unserializer)
   (let ((cell (assoc ident *custom-serialization*)))
      (if (not (pair? cell))
	  (set! *custom-serialization*
		(cons (list ident serializer unserializer)
		      *custom-serialization*)))))

;*---------------------------------------------------------------------*/
;*    find-custom-serializer ...                                       */
;*---------------------------------------------------------------------*/
(define (find-custom-serializer ident)
   (let ((cell (assoc ident *custom-serialization*)))
      (if (pair? cell)
	  (cadr cell)
	  #f)))
   
;*---------------------------------------------------------------------*/
;*    find-custom-unserializer ...                                     */
;*---------------------------------------------------------------------*/
(define (find-custom-unserializer ident)
   (let ((cell (assoc ident *custom-serialization*)))
      (if (pair? cell)
	  (caddr cell)
	  #f)))
   
;*---------------------------------------------------------------------*/
;*    *procedure->string* ...                                          */
;*---------------------------------------------------------------------*/
(define *procedure->string*
   (lambda (item)
      (error "obj->string" "can't extern procedure" item)))

;*---------------------------------------------------------------------*/
;*    *string->procedure* ...                                          */
;*---------------------------------------------------------------------*/
(define *string->procedure*
   (lambda (string)
      (error "string->obj" "Can't intern procedure item" string)))

;*---------------------------------------------------------------------*/
;*    *procedure-table* ...                                            */
;*---------------------------------------------------------------------*/
(define *procedure-table* '())

;*---------------------------------------------------------------------*/
;*    @deffn register-procedure-serialization@ ...                     */
;*---------------------------------------------------------------------*/
(define (register-procedure-serialization serializer unserializer)
   (set! *procedure->string* serializer)
   (set! *string->procedure* unserializer))
   
;*---------------------------------------------------------------------*/
;*    @deffn get-procedure-serialization@ ...                          */
;*---------------------------------------------------------------------*/
(define (get-procedure-serialization)
   (cons *procedure->string* *string->procedure*))
   
;*---------------------------------------------------------------------*/
;*    *process->string* ...                                            */
;*---------------------------------------------------------------------*/
(define *process->string*
   (lambda (item)
      (error "obj->string" "can't extern process" item)))

;*---------------------------------------------------------------------*/
;*    *string->process* ...                                            */
;*---------------------------------------------------------------------*/
(define *string->process*
   (lambda (string)
      (error "string->obj" "Can't intern process item" string)))

;*---------------------------------------------------------------------*/
;*    *process-table* ...                                              */
;*---------------------------------------------------------------------*/
(define *process-table* '())

;*---------------------------------------------------------------------*/
;*    @deffn register-process-serialization@ ...                       */
;*---------------------------------------------------------------------*/
(define (register-process-serialization serializer unserializer)
   (set! *process->string* serializer)
   (set! *string->process* unserializer))
   
;*---------------------------------------------------------------------*/
;*    @deffn get-process-serialization@ ...                            */
;*---------------------------------------------------------------------*/
(define (get-process-serialization)
   (cons *process->string* *string->process*))

;*---------------------------------------------------------------------*/
;*    *opaque->string* ...                                             */
;*---------------------------------------------------------------------*/
(define *opaque->string*
   (lambda (item)
      (error "obj->string" "can't extern opaque" item)))

;*---------------------------------------------------------------------*/
;*    *string->opaque* ...                                             */
;*---------------------------------------------------------------------*/
(define *string->opaque*
   (lambda (string)
      (error "string->obj" "Can't intern opaque item" string)))

;*---------------------------------------------------------------------*/
;*    *opaque-table* ...                                               */
;*---------------------------------------------------------------------*/
(define *opaque-table* '())

;*---------------------------------------------------------------------*/
;*    @deffn register-opaque-serialization@ ...                        */
;*---------------------------------------------------------------------*/
(define (register-opaque-serialization serializer unserializer)
   (set! *opaque->string* serializer)
   (set! *string->opaque* unserializer))
   
;*---------------------------------------------------------------------*/
;*    @deffn get-opaque-serialization@ ...                             */
;*---------------------------------------------------------------------*/
(define (get-opaque-serialization)
   (cons *opaque->string* *string->opaque*))
