;*=====================================================================*/
;*    .../prgm/project/bigloo/api/multimedia/src/Llib/music.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul 30 14:07:08 2005                          */
;*    Last change :  Thu Sep  7 05:59:49 2006 (serrano)                */
;*    Copyright   :  2005-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    Generic music player API                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __multimedia-music

   (export (class music)

	   (generic music-close ::music)
	   (generic music-abort ::music)

	   (generic music-playlist-get::pair-nil ::music)
	   (generic music-playlist-add! ::music ::bstring)
	   (generic music-playlist-delete! ::music ::bstring)
	   (generic music-playlist-clear! ::music)
	   
	   (generic music-play ::music . song)
	   (generic music-seek ::music ::obj . song)
	   (generic music-stop ::music)
	   (generic music-pause ::music)
	   (generic music-next ::music)
	   (generic music-prev ::music)
	   
	   (generic music-properties::pair-nil ::music)
	   (generic music-info ::music)
	   (generic music-song ::music)
	   (generic music-time::int ::music)
	   
	   (generic music-volume-get::int ::music)
	   (generic music-volume-set! ::music ::int)))

;*---------------------------------------------------------------------*/
;*    Abstract implementation                                          */
;*---------------------------------------------------------------------*/
(define-generic (music-close m::music))
(define-generic (music-abort m::music))
(define-generic (music-playlist-get::pair-nil m::music))
(define-generic (music-playlist-add! m::music s::bstring))
(define-generic (music-playlist-delete! m::music s::bstring))
(define-generic (music-playlist-clear! m::music))

(define-generic (music-properties::pair-nil m::music))
(define-generic (music-info m::music))
(define-generic (music-song m::music))
(define-generic (music-time::int m::music))

(define-generic (music-play m::music . song))
(define-generic (music-seek m::music p::obj . song))
(define-generic (music-stop m::music))
(define-generic (music-pause m::music))
(define-generic (music-next m::music))
(define-generic (music-prev m::music))

(define-generic (music-volume-get::int m::music))
(define-generic (music-volume-set! m::music v::int))
