;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/web/src/Llib/rss.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 17 08:12:41 2005                          */
;*    Last change :  Wed May 10 13:06:33 2006 (serrano)                */
;*    Copyright   :  2005-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    RSS parsing                                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __web_rss

   (import __web_xml
	   __web_html)
   
   (export (rss-parse ::input-port ::obj ::procedure ::procedure ::procedure)))

;*---------------------------------------------------------------------*/
;*    rss-parse ...                                                    */
;*---------------------------------------------------------------------*/
(define (rss-parse port clength make-rss make-channel make-item)
   (define (html-decode o)
      (cond
	 ((string? o)
	  (html-string-decode o))
	 ((pair? o)
	  (map html-decode o))
	 (else
	  o)))
   (define (rss1.0 attr body)
      (define (item->html e2)
	 (let ((title #f)
	       (link #f)
	       (descr #f)
	       (date #f)
	       (subject #f))
	    (for-each (lambda (e3)
			 (when (pair? e3)
			    (case (car e3)
			       ((title)
				(set! title (caddr e3)))
			       ((link)
				(set! link (car (caddr e3))))
			       ((description)
				(set! descr (html-decode (caddr e3))))
			       ((pubDate)
				(set! date (caddr e3)))
			       ((dc:subject)
				(set! subject (caddr e3))))))
		      (caddr e2))
	    (make-item link title date subject descr)))
      (define (channel->html body)
	 (let ((title #f)
	       (link #f))
	    (for-each (lambda (e1)
			 (when (pair? e1)
			    (case (car e1)
			       ((title)
				(set! title (car (caddr e1))))
			       ((link)
				(set! link (car (caddr e1)))))))
		      body)
	    (make-channel link title)))
      (let ((channel #f)
	    (items '()))
	 (for-each (lambda (e)
		      (when (pair? e)
			 (case (car e)
			    ((channel)
			     (set! channel (channel->html (caddr e))))
			    ((item)
			     (set! items (cons (item->html e) items))))))
		   body)
	 (make-rss channel items)))
   (define (rss2.0 attr body)
      (define (item->html e2)
	 (let ((title #f)
	       (link #f)
	       (descr #f)
	       (date #f)
	       (subject #f))
	    (for-each (lambda (e3)
			 (when (pair? e3)
			    (case (car e3)
			       ((title)
				(set! title (caddr e3)))
			       ((link)
				(set! link (car (caddr e3))))
			       ((description)
				(set! descr (html-decode (caddr e3))))
			       ((pubDate)
				(set! date (caddr e3)))
			       ((dc:subject>)
				(set! subject (caddr e3))))))
		      (caddr e2))
	    (make-item link title date subject descr)))
      (define (channel->html body)
	 (let ((title #f)
	       (link #f)
	       (items '()))
	    (for-each (lambda (e1)
			 (when (pair? e1)
			    (case (car e1)
			       ((title)
				(set! title (car (caddr e1))))
			       ((link)
				(set! link (car (caddr e1))))
			       ((item)
				(set! items (cons (item->html e1) items))))))
		      body)
	    (make-rss (make-channel link title)
		      (reverse! items))))
      (let ((res #f))
	 (for-each (lambda (e)
		      (when (and (pair? e) (eq? (car e) 'channel))
			 (set! res (channel->html (caddr e)))))
		   body)
	 res))
   (filter-map (lambda (el)
		  (when (pair? el)
		     (case (car el)
			((rss)
			 (rss2.0 (cadr el) (caddr el)))
			((rdf:RDF rdf:rdf)
			 (rss1.0 (cadr el) (caddr el)))
			(else
			 #f))))
	       (xml-parse port (if (elong? clength)
				   (elong->fixnum clength)
				   clength))))
