var bm = require("../shared-modules/bookmarks");

const TIMEOUT = 5000;

const LOCAL_TEST_FOLDER = collector.addHttpResource('../test-files/');
const LOCAL_TEST_PAGE = LOCAL_TEST_FOLDER + 'test.html';

var setupModule = function(module) {
    module.controller = mozmill.getBrowserController();
    module.jum = {}
    module.sync = {}
    Cu.import("resource://mozmill/modules/jum.js", module.jum);
    Cu.import("resource://bindwood/sync.jsm", module.sync);
    module.synchroniser = null;
    bm.clearBookmarks();
};


var setupTest = function() {
    synchroniser = new sync.Synchroniser(null, "profile_name");
};

var teardownTest = function() {
    bm.clearBookmarks();
};

var test_special_ids = function() {
    var placesRoot = bm.bookmarksService.placesRoot;
    var toolbarFolder = bm.bookmarksService.toolbarFolder;
    var bookmarksMenuFolder = bm.bookmarksService.bookmarksMenuFolder;
    var unfiledBookmarksFolder = bm.bookmarksService.unfiledBookmarksFolder;

    // Special folders get mapped to fixed GUIDs
    jum.assertEquals(
        synchroniser.guid_from_id(placesRoot), "root_profile_name");
    jum.assertEquals(
        synchroniser.guid_from_id(toolbarFolder), "toolbar_profile_name");
    jum.assertEquals(
        synchroniser.guid_from_id(bookmarksMenuFolder), "menu_profile_name");
    jum.assertEquals(
        synchroniser.guid_from_id(unfiledBookmarksFolder),
        "unfiled_profile_name");

    // Special fixed GUIDs get mapped to special folders
    jum.assertEquals(
        synchroniser.guid_to_id("root_profile_name"), placesRoot);
    jum.assertEquals(
        synchroniser.guid_to_id("toolbar_profile_name"), toolbarFolder);
    jum.assertEquals(
        synchroniser.guid_to_id("menu_profile_name"), bookmarksMenuFolder);
    jum.assertEquals(
        synchroniser.guid_to_id("unfiled_profile_name"),
        unfiledBookmarksFolder);
};

var test_guid_from_id = function() {
    var bookmark_id = bm.bookmarksService.insertBookmark(
        bm.bookmarksService.toolbarFolder,
        bm.createURI(LOCAL_TEST_PAGE),
        bm.bookmarksService.DEFAULT_INDEX,
        "Bookmark title");
    // guid_from_id returns the same value with multiple calls.
    var bookmark_guid = synchroniser.guid_from_id(bookmark_id);
    jum.assertNotEquals(bookmark_guid, null);
    jum.assertEquals(synchroniser.guid_from_id(bookmark_id), bookmark_guid);
};

var test_guid_to_id = function() {
    var bookmark_id = bm.bookmarksService.insertBookmark(
        bm.bookmarksService.toolbarFolder,
        bm.createURI(LOCAL_TEST_PAGE),
        bm.bookmarksService.DEFAULT_INDEX,
        "Bookmark title");
    var bookmark_guid = synchroniser.guid_from_id(bookmark_id);

    // Bookmark can be looked up by the GUID.
    jum.assertEquals(synchroniser.guid_to_id(bookmark_guid), bookmark_id);

    // The bookmark can be located by scanning all bookmarks if it
    // isn't available in the local cache.
    delete synchroniser.guid_item_map[bookmark_guid];
    jum.assertEquals(synchroniser.guid_to_id(bookmark_guid), bookmark_id);

    // Non-existent GUIDs result in a null result.
    jum.assertEquals(synchroniser.guid_to_id("non-existent"), null);
};

var test_get_all_bookmarks = function() {
    var first_id = bm.bookmarksService.insertBookmark(
        bm.bookmarksService.toolbarFolder,
        bm.createURI(LOCAL_TEST_PAGE + "#one"),
        bm.bookmarksService.DEFAULT_INDEX,
        "Bookmark 1");
    var second_id = bm.bookmarksService.createFolder(
        bm.bookmarksService.bookmarksMenuFolder,
        "Folder", bm.bookmarksService.DEFAULT_INDEX);
    var third_id = bm.bookmarksService.insertBookmark(
        second_id,
        bm.createURI(LOCAL_TEST_PAGE + "#three"),
        bm.bookmarksService.DEFAULT_INDEX,
        "Bookmark 3");
    var fourth_id = bm.bookmarksService.insertBookmark(
        bm.bookmarksService.unfiledBookmarksFolder,
        bm.createURI(LOCAL_TEST_PAGE + "#four"),
        bm.bookmarksService.DEFAULT_INDEX,
        "Bookmark 4");

    var bookmarks = synchroniser.get_all_bookmarks();
    jum.assertNotUndefined(bookmarks["root_profile_name"]);
    jum.assertNotUndefined(bookmarks["toolbar_profile_name"]);
    jum.assertNotUndefined(bookmarks[synchroniser.guid_from_id(first_id)]);
    jum.assertNotUndefined(bookmarks["menu_profile_name"]);
    jum.assertNotUndefined(bookmarks[synchroniser.guid_from_id(second_id)]);
    jum.assertNotUndefined(bookmarks[synchroniser.guid_from_id(third_id)]);
    jum.assertNotUndefined(bookmarks["unfiled_profile_name"]);
    jum.assertNotUndefined(bookmarks[synchroniser.guid_from_id(fourth_id)]);
};
