#ifndef COMMON_H
#define COMMON_H

#define INT_MAX_STR_SIZE        	1024
#define MAX_TIMESTAMP_SIZE      	1024
#define TIMESTAMP_FORMAT        	"%b %d, %Y @ %T"
#define STRING_ENTRY_FORMAT		"0\tstring\t%s\t\"%s\""
#define TMP_MAGIC_FILE			"/tmp/binwalk.magic.raw.search"

/* These globals are set once, read many */
struct bin_globals
{
        FILE *fsout;
        int quiet;
} globals;

int str2int(char *str);
const void *file_read(char *file, size_t *fsize);
void print(const char* format, ...);
char *timestamp();
char *create_magic_file(char *search_string);
void cleanup_magic_file(void);

#endif
