#ifndef __DD_H__
#define __DD_H__

#include <stdint.h>

#define DD_WILDCARD		"all"
#define EXTRACT_PLACEHOLDER	"%e"
#define DEV_NULL		"/dev/null"
#define USER_EXTRACT		"extract.conf"
#ifndef EXTRACT
#define EXTRACT			"./extract.conf"
#endif

struct dd_rule
{
	char *match;
	char *ext;
	char *cmd;
	int count;
};

int dd_rule_index(char *match, char *extension);
void add_dd_rule(char *match, char *extension, char *cmd);
void free_dd_rule_members(int i);
void free_dd_rules(void);
int matches_dd_rule(char *description);
void dd(int index, uint32_t offset, char *data, size_t size, int verbose);
void parse_dd_option(char *optarg);
void parse_extract_file(char *fname);
void parse_extract_config(void);

#endif
