/*
   birthday

   Birthday/Anniversary display on login

   (c) 1996 AS Mortimer

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  You may also
    distribute it under the Artistic License, as comes with Perl.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You should also have recieved a copy of the Artistic license with
    this program.

   $Id: birthday.c,v 1.5 1999/04/25 14:01:29 andy Exp $
*/

#include <string.h>
#include <stdio.h>

#include "birthday.h"

#ifdef DOS
#include "getopt.h"
#else /* DOS */
#include <unistd.h>
#endif /* DOS */

int main(int argc, char *argv[])
{
  char *fname = NULL;
  struct event *evl; /* evl => event list */
  unsigned i;
  enum {F_WARN, F_CAL} func;

  func = F_WARN;
  
  while ((i = getopt (argc, argv, "wcf:W:M:m:l:p:d:i:")) != -1)
    switch (i)
      {
      case 'w':
	func=F_WARN;
	break;
      case 'c':
	func=F_CAL;
	break;
      case 'f':
	fname=strdup(optarg);
	break;
      case 'W':
	iDWarn = atoi(optarg);
	break;
      case 'M':
	iMaxWarn = atoi(optarg);
	break;
      case 'm':
	iMinWarn = atoi(optarg);
	break;
      case 'l':
	iCLines=atoi(optarg);
	break;
      case 'p':
	iCWeeks=atoi(optarg);
	break;
      case 'd':
	iCTotal=atoi(optarg);
	break;
      case 'i':
	iCWidth=atoi(optarg);
	break;
      default:
	fatal("Internal error: unprocessed option %c\n", i);
      }
  
  evl = readlist(fname); /* read and format entries */

  switch(func)
    {
    case F_WARN:
      liststrings(evl, puts);
      break;
    case F_CAL:
      do_cal(evl);
      break;
    }
  
  return 0;
}
