.TH birthday 1
.SH NAME
birthday \- warn about upcoming birthdays and other events
.SH SYNOPSIS
.BR birthday\  [ -w | -c ]\ [ -f
.IR file ]
.RB [ -W
.IR defwarn ]
.RB [ -M
.IR maxwarn ]
.RB [ -m
.IR minwarn ]
.RB [ -l
.IR lines ]
.RB [ -p
.IR weeks ]
.RB [ -d
.IR total ]
.RB [ -i
.IR width ]

.SH DESCRIPTION
The 
.B birthday
command reads a file, by default
.IR ~/.birthdays ,
which gives a list of events in the near future (see section
.B FILE FORMAT
for details). It can then produce either a list of events which are coming up within the next few weeks, or a text-based
calendar with a few lines for each day.

.SH OPTIONS

.TP
.B -w
Display a list of upcoming events. This is the default.
.TP
.B -c
Display a calendar, designed to be piped to
.BR lpr (1).
.TP
.BI -f\  file
Read the events from
.I file
rather than
.IR ~/.birthdays.
If
.I file
is a single hyphen, read the events from the standard input (usually
the terminal).

.SS List Options

.TP
.BI -W\  warn
Warn
.I warn
days in advance, for entries that have no
.B w
flag (see
.BR FILE\ FORMAT ).
If this switch is not specified, it defaults to 21 days.
.TP
.BI -M\  max
Warn at most
.I max
days in advance. This overrides any flag given in the file.
.TP
.BI -m\  min
Warn at least
.I min
days in advance. This overrides any flag given in the file.

.SS Calendar Options

.TP
.BI -l\  lines
Print
.I lines
lines for every day.
.TP
.BI -p\  weeks
Print
.I weeks
weeks on every page of the calendar. If set to
.IR 0 ,
the default, disables page breaks.
.TP
.BI -d\  days
Print the calendar for up to
.I days
days in advance.
.TP
.BI -i\  width
Print the calendar
.I width
characters wide. This affects the length of the lines separating each day, and the point at which events will be
word-wrapped.

.SH FILE FORMAT

Each line beginning with a hash sign, 
.RB ` # ',
is a comment and will be ignored. Lines beginning with an ampersand,
.RB ` & ',
are directives. Currently there is only one such directive,
.B &include
.IR file ,
which reads in a seperate file from your
.I .birthdays
file.
.I file
should be given with an absolute path, which should not use the tilde notation to specify your home directory.

Any other line specifies the name of a person or event, followed by an equals sign and
a date
.RI ( DD/MM ,\  DD/MM/YY \ or\  DD/MM/YYYY ,
where the form
.I DD/MM/YY
is assumed to give a date in the 20th century and is now deprecated),
and finally some extra options. These options are:
.TP
.B bd
This line is a birthday (the default). The year, if given, should be when the person was born. A line designated as a
birthday will produce output like
.B Erin has a birthday in 3 days' time
or
.BR "Jemima is 3 in 2 weeks' time" .
.TP
.B ann
This line is an anniversary. The year, if given, should be the year in which the thing happened, producing output like
.B Pen exploded 3 years ago tomorrow
given a line such as
.BR "Pen exploded=12/09/93 ann" .
.TP
.B ev
This line is an event of some sort. If a year is given, the text will be displayed in that year only; otherwise, it will
be displayed every year. The remaining time is simply appended to the text; for instance, the input
.B Easter=7/4/1996 ev
would give rise to the text
.BR "Easter in 1 week's time" .
.TP
.BI w n
Warn
.I n
days in advance of the date, rather than the default of 21 days or the number given with the
.B -w
flag.
.TP
.BI to date
The event lasts until
.IR date ,
which should be in the same format as for the date of the event.
.TP
.BI for days
The event lasts for
.B days
days.

.SH DATE SPECIFICATION

The file format documented here handles dates in a couple of slightly
non-standard ways.  Firstly, the dates are given in British format of
.IR DD/MM/YYYY ,
as opposed to the more normal US format
.IR MM/DD/YYYY .

Secondly, dates with a two-digit year are assumed to be in the 20th
century
.RI (19 xx ),
rather than taking the standard convention of assuming all two-digit
years less than 70 are in the 21st century.  This is for reasons of
compatibility with older data files, since many people have birthdays
before 1970, and the program was written before I came across the Y2K
issues. :-(  You should probably avoid this format.

.SH FILES

.TP
.I ~/.birthdays
Your default birthdays file.

.SH SEE ALSO

.BR cal (1)

.SH BUGS
Both the "features" in the
.B DATE SPECIFICATION
section could be construed as bugs, and are mostly present for
backwards compatibility.

The calendar mode should be a seperate program.

The program cannot warn more than one year in advance of anything.

.SH AUTHOR
Andy Mortimer <andy.mortimer@zetnet.co.uk>
