/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#define DEFAULT_ARROW_GAP 0.25
#define UTILS_ARROW_PLOTTER_LINE_WIDTH .1


/**
 *Rimappa i font per l'esportazione
 */

string remap_ps_font(int fltkfont);

/**
 *Rimappa un componente del colore da 32 a 488 bit
 */

int remap_color_48(int trentadue);


float remap_color_1(int byte);

/**
 *Rimappa la y per l'esportazione
 */

float remap_y_ps(float vx);



void draw_pango_string(std::string st,int x, int y, std::string font,int dim,
                       int cr, int cg, int cb);

/**
 *Trova  un punto  appartenente  ad una  retta  perpendicolare a  quella
 *definita dai punti in ingresso.
 *
 *\param dax  Ascissa corrispondente  all'inizio del segmento  sul quale
 *disegnare la freccia.
 *
 *\param day  Ascissa corrispondente  all'inizio del segmento  sul quale
 *disegnare la freccia.
 *
 *\param ax Ascissa delpunto sul quale disegnare la freccia
 *\param ay Ascissa delpunto sul quale disegnare la freccia
 *\param gap distanza tra la retta e il punto
 *\param verso il lato verso cui disegnare la freccia.
 *\param risx ascissa del punto risultante
 *\param risy ordinata del punto risultante
 *
 *
 */

void trova_perpendicolare(float dax, float day, 
			  float ax, float ay, 
			  bool verso,float gap,
			  float& risx, float&risy);

  /**
   *Ricava l'equazione di una retta partendo da due punti appartenenti.
   *
   *\param x1 l'ascissa del primo punto
   *\param y1 l'ordinata del primo punto
   *\param x2 l'ascissa del primo punto
   *\param y1 l'ascissa del primo punto
   *\param m  il coefficente angolare
   *\param l'intercetta
   *
   *\return  true se  l'equazione  non e'  del  tipo <em>x=k</em>  false
   *altrimenti.
   */

bool  rett_eqn(float x1, float y1, 
		float x2, float y2, 
		float& m, float& q);




/**
 *calcola i vertici di una punta della freccia.
 *
 *\param dax Ascissa corrispondente  all'inizio del segmento sul quale
 *disegnare la freccia.
 *
 *\param day Ascissa corrispondente  all'inizio del segmento sul quale
 *disegnare la freccia.
 *
 *\param ax Ascissa delpunto sul quale disegnare la freccia
 *\param ay Ascissa delpunto sul quale disegnare la freccia
 *\param spessore lo spessore della freccia
 *\param verso il lato verso cui disegnare la freccia.
 */




void calculate_arrow_points(float dax, float day, 
                            float ax, float ay, 
                            float spessore,float arr_w, 
                            float arr_h, float arr_gap,
                            int cr, int cg, int cb,
                            std::vector<float>& results_x,
                            std::vector<float>& results_y,
                            bool verso=false);




/**
 *disegna una punta della freccia.
 *
 *\param dax Ascissa corrispondente  all'inizio del segmento sul quale
 *disegnare la freccia.
 *
 *\param day Ascissa corrispondente  all'inizio del segmento sul quale
 *disegnare la freccia.
 *
 *\param ax Ascissa delpunto sul quale disegnare la freccia
 *\param ay Ascissa delpunto sul quale disegnare la freccia
 *\param spessore lo spessore della freccia
 *\param verso il lato verso cui disegnare la freccia.
 */


void disegna_freccia(float dax, float day, 
		     float ax, float ay, 
		     float spessore,float arr_w, 
		     float arr_h, float arr_gap,
                     int cr, int cg, int cb,
		     bool verso=false);



/**
 *Disegna  una retta  parallela a  quella definita  dai punti  dati come
 *parametri.
 *
 *\param dax  Ascissa corrispondente  all'inizio del segmento  sul quale
 *disegnare la freccia.
 *
 *\param day  Ascissa corrispondente  all'inizio del segmento  sul quale
 *disegnare la freccia.
 *
 *\param ax Ascissa delpunto sul quale disegnare la freccia
 *\param ay Ascissa delpunto sul quale disegnare la freccia
 *\param gap la retta sara' piu' corta della principale di?
 *\param verso il lato verso cui disegnare la freccia.
 *\param tratt true se il legame e' tatteggiato, false se pieno
 *
 */

void disegna_parallela(float dax, float day, 
		       float ax, float ay,
                       int cr, int cg,int cb,
                       bool verso=false, 
		       float gap=MULTIPLE_BOND_GAP, bool tratt=false, bool noaccorc=false);


/**
 *\return true o false a seconda del semipiano di appartenenza:
 *true se y>=mx+q false se y<mx+q 
 *
 *\param x l'ascissa del punto da valutare
 *\param y l'ordinata del punto da valutare
 *\param xrt l'ascissa di un punto appartenente alla retta
 *\param yrt l'ordinata di un punto appartenente alla retta
 *\param xrt2 l'ascissa di un punto appartenente alla retta
 *\param yrt2 l'ordinata di un punto appartenente alla retta

 *
 */

bool ritorna_semipiano_app(float x, float y, 
			   float xrt, float yrt,
			   float xrt2, float yrt2
			   );


/**
 *trova il punto di intersezione tra un segmento ed una retta verticale.
 *\param da_x ascissa del primo punto del segmento
 *\param da_y ordinata del primo punto del segmento
 *\param fino_x ascissa del secondo punto del segmento
 *\param fino_y ordinata del secondo punto del segmento
 *
 *\param x_edge ascissa della retta verticale
 *\return l'ordinata del punto di intersezione
 */

float b_clip_v(float da_x, float da_y, float fino_x, float fino_y, float x_edge);


/**
 *trova il punto di intersezione tra un segmento ed una retta orizzontale.
 *\param da_x ascissa del primo punto del segmento
 *\param da_y ordinata del primo punto del segmento
 *\param fino_x ascissa del secondo punto del segmento
 *\param fino_y ordinata del secondo punto del segmento
 *
 *\param y_edge ascissa della retta verticale
 *\return l'ascissa del punto di intersezione
 */

float b_clip_h(float da_x, float da_y, float fino_x, float fino_y, float y_edge);



/**
 *\return true se il punto appartiene al segmento, false altrimenti
 */

bool appartiene_retta(int x_m, int y_m, 
		      float st_x, float st_y,
		      float e_x, float e_y,
		      int spessore=1);




/**
 *disegna un bel pallino in posizione x y e raggio uguale a RAGGIO_EL
 */

void disegna_pallino(float x, float y);


void draw_shadowed_point(float x, float y, int r, int g, int b);

/**
 *disegna quattro bei pallini ai vertici della box passata come argomento
 */

void disegna_cornice_pallini(int x, int y , int w ,int h);

/**
 *Ritorna la corretta bounding box per l'etichetta in relazione all'allineamento./
 */

void get_bb_etic(etichetta& et, float& x, float& y);


void get_visual_bb_etic(etichetta& et, float& x, float& y);


/**
 *Ottieni i font corretti
 */

void get_font_handle(etichetta et, int &font_fltk, string &font_libplot);


/**
 *Mostra "non ancora implementato"
 */

void not_impl();



/**
 *\param format il formato del file come estensione
 *\return true se il formato e' supportato, false altrimenti
 */

bool format_supported(string format);


/**
 *ricava l'hash per una stringa
 *\param value la stringa dalla quale ricavare l'hash
 *\return l'hash come unsigned int ( max 33554393)
 */


unsigned int create_hash(string value);


/**
 *trova le coordinate del punto di intersezione tra due rette
 *
 *\param xy1  
 *\param xy2 array  delle coordinate dei  punti appartenenti all rette che si intersecano xy1 = {x, y, x2, y2}
 *\param risx ascissa dell'intersezione
 *\param risy ordinata dell'intersezione
 *\return true se le rette non sono parallele o coincidenti , false altrimenti
 */

bool trova_intersezione(float* xy1,float* xy2, float& risx, float& risy);


/**
 *classe per disegnare la splashpage
 */


class splash_window: public Fl_Window {

public:
  splash_window(int w, int h);
  virtual ~splash_window();
  virtual int handle(int e);
};


class splash_widget: public Fl_Widget {
public:
  splash_widget(int x,int y,int w, int h);

  virtual ~splash_widget();

protected:
  virtual void draw();
};



void fondi_gruppi(gruppo* g_st , gruppo* g_arr,atomo* st, atomo* arr, int tipo);


/**
 *calcola la bounding box
 */

void calc_bb_gen(vector<float> x, vector<float>y, 
		 pair<float,float>& ld,
		 pair<float,float>& ru);


/**
 *de-scala pt rispetto a __pref.getZoom();
 */

float descale(float scaled);

/**
 *scala pt rispetto a __pref.getZoom();
 */

float scale_z(float scaled);


float scale_center_point(double point,double trasl, double zoom);


vector<float> correct_arrow(float xtan_st, float ytan_st, 
			    float xtan_end, float ytan_end, 
			    float entity=5/8);



int ask_overwrite_file(string the_file);

int ask_overwrite_file_console(string the_file);

/**
 *bezier curve
 */

std::pair<float, float> poly_bezier(float x0, float y0,
				    float x1, float y1,
				    float x2, float y2,
				    float x3, float y3,
				    float t) throw (out_of_range);
/**
 *return bool if value of v i inside interval (ref-offset;ref+offset)
 */

template <class T> bool similar_to(T v, T ref, T offset){
  bool res=false;
  if( (v >= ref - offset) && (v <= ref + offset) ){
    res=!res;
  }
  return res;
}


/**
 *rotate point (around pivot (0,0)) counterclockwise
 *\param angle angle in radiant 
 */

std::pair<float, float> rotate_point(float x, float y, float angle);

/**
 *Print redfog wisdom to stdout
 */

void print_redfog_wisdom();



float rad2deg(float angle);

float deg2rad(float angle);

/**
 *Attract mouse to magnetic point as specified in preferences
 */

void attract_mouse_to_magnetic_point(int* x_m, int* y_m);



std::string trim(std::string s,const std::string drop=" \t");

/**
 *\param desidered the string representing a font
 *\destination the font whre to copy destination
 *\the number of fonts in fonttable
 */

void search_for_font(const char* desidered, Fl_Font destination, int num_fonts);

void set_actual_font_from_prefs();


bond_type shift_bond_type(bond_type curr);
  


/**
 *
 *guess type of input file
 */
bool guess_is_mdl_file(std::string f);


/**
 *
 *guess type of input file
 */
bool guess_is_cml_file(std::string f);
