/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <config.h>

#include <global.hpp>
#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <wordexp.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>
//portability problem?
#include <pthread.h>

#include <cstdio>


#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Check_Button.H>
//#include <FL/Fl_PNG_Image.H>

#include <interfacce.hpp>

#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <prefs.hpp>

#include <set_conf.hpp>
#include <command_line.hpp>
#include <util.hpp>



#include <join_ring.hpp>

#include <join_ring_dialog.h>

extern finestra_pr* __la_finestra;

extern Preferences  __pref;

extern bool __close;




/**
 *Un plugin deve avere :
 *
 *una funzione  bool (*need_group)()  che ritorna true  se il  plugin ha
 *bisogno di conoscre quali atomi sono selezionati;
 *
 *una funzione  bool (*need_leg)()  che ritorna true  se il  plugin ha
 *bisogno di conoscere quali legami sono selezionati;
 *
 *una funzione  bool (*act)()  che computa quello  per cui il  plugin e'
 *stato scritto
 *
 */



join_ring::join_ring(immagine* image,string libpath)
  :bist_plugin(image,libpath),
   _has_to_act(true),
   _has_acted(false),
   _delete_old(false)
   
{
  
}


void join_ring::inizialize(){

 _the_image->elimina_elem_selected();
 _the_image->elimina_legami_selected();

 Fl_Double_Window* win=  make_join_ring_dialog();
 
 while(win->shown()){
   cout << Fl::wait() << endl;
 }
  
 Fl_Check_Button* d = dynamic_cast<Fl_Check_Button*>(win->child(2));
 _delete_old=d->value();
 
 delete win;
 
}

bool join_ring::need_atom(){
  return false;
}

bool join_ring::need_leg(){
  return false;
}

bool join_ring::act(int e){
  //  cout << "yyy_has_to_act " << _has_to_act << endl;
  if(_has_to_act){
    //fl_message("ahoo");
    if(check()){
      connect_molecules();
    }else{
      //fl_message("ahoo");
      // errore!
      
    }
    _has_acted=true;
    _has_to_act=false;
  }
  return true;
}


join_ring::~join_ring(){
  
  cout << "join ring distruzione!!! " << _the_image <<endl;
}

void join_ring::register_plugin(){

}

 
bool join_ring::time_to_act(){
  cout << " join plugin says " << _the_image << "---" << r_elem_selected()->size() << "---" <<  endl;
  bool res=false;
  if(r_elem_selected()->size()>3 && !_has_acted){
    _has_to_act=true;
    res=true;
  }
  
  return res;
  
}
    

string join_ring::libpath(){
  return _lib;
}


bool join_ring::check(){
  //cout << "xxxxxcheck" << endl;
  bool result=true;

  /**
   *Contiene  coppie <tipo, < gruppo, id > > selezionati, se  si e'
   *selezionato una etichetta gruppo e' uguale a NO_VALID_GROUP
   */

  vector< pair < int, pair<int,int> > >* elem=r_elem_selected();



  vector <gruppo>* gruppi=r_groups();
  //vector <int> num_gruppi;
  vector < pair<int,int> > comp_gruppi;

  //controlliamo che ci siano solo due gruppi

  for(unsigned int el_sel=0;el_sel<elem->size();el_sel++){
    int group_at=(*elem)[el_sel].second.first;
    bool found=false;
    for(unsigned i=0;i< comp_gruppi.size();i++){
      if(comp_gruppi[i].first==group_at){
	found=true;
	break;
      }
    }
    if(!found){
      pair<int,int> p(group_at,0);
      comp_gruppi.push_back(p);
    }
  }  
  


  if(comp_gruppi.size()>2){
    cout << "xxxx errore: piu' di due gruppi selezionati" << endl;
    return false;
  }

  //ora controlliamo che ci siano solo due atomi per ogni gruppo

  for(unsigned int el_sel=0;el_sel<elem->size();el_sel++){
    int group_at=(*elem)[el_sel].second.first;
    for(unsigned i=0;i< comp_gruppi.size();i++){
      pair<int,int> cmp=comp_gruppi[i];
      if(group_at==cmp.first){
	comp_gruppi[i].second++;
      }
    }
  }


  for(unsigned i=0;i< comp_gruppi.size();i++){
    pair<int,int> cmp=comp_gruppi[i];
    //    cout <<"xxx comp.second: " << cmp.second <<endl;
    if(cmp.second>2){
      cout << "xxxx errore: piu' di due elementi per gruppo" << endl;
      return false;
    }
  }


  

  vector<atomo> copies;

  cout << "misura ele " << elem->size() << endl;

  for(unsigned int el_sel=0;el_sel<elem->size();el_sel++){
    
    pair< int, pair<int,int> > selected=(*elem)[el_sel];

    cout << endl << "XXX " << el_sel << endl;

    if(selected.second.first!=NO_VALID_GROUP){
      if(selected.first==ATOMO){
	cout << "XXXXXXselezionato atomo!" << endl;
	for(unsigned int ct_atm=0;ct_atm<gruppi->size();ct_atm++){ //cerchiamo gli atomi
	  vector<atomo>::iterator in=(*gruppi)[ct_atm].iniz_atom();
	  vector<atomo>::iterator fi=(*gruppi)[ct_atm].fin_atom();

	  while(in!=fi){
	    if((*in).id()==selected.second.second &&
	       (*in).id_gruppo()==selected.second.first){
	      cout << "xxxx " << el_sel << " selzionato id " 
		   <<  (*in).id() 
		   << " " << (*in).id_gruppo() << endl;
	      copies.push_back((*in));
	      break;
	    }
	    in++;
	  }
	}
	cout << "yyyyy"  << _the_image << endl;

	/*
	_the_image->cancella_elementi_selected();
	_the_image->elimina_elem_selected();
	_the_image->elimina_legami_selected();
	*/
	
      }else{
	cout << "XXXXXXselezionato procedura!" << endl;
	result=false;
      }


    }else{
      cout << "XXXXXselezionato stringa!" << endl;
      result=false;
    }


  }

  for(unsigned int i=0;i< copies.size(); i++){
    cout << "pppp " << copies[i].id() << " " << copies[i].id_gruppo() << endl;
  }


  //ora controlliamo  che gli atomi  dello stesso gruppo  siano legati
  //direttamente l'uno all'altro
  /*  
bool found=false;
  
  for(unsigned int i =0;i< copies.size(); i++){
    atomo* tmp_i=_the_image->ritorna_atomo_ident(copies[i].id_gruppo(),
						 copies[i].id());
    vector<legame>::iterator leginiz=tmp_i->primo_leg();
    vector<legame>::iterator legfin=tmp_i->ultimo_leg();
    while(leginiz!=legfin){
      for(unsigned int ct_cp=0;ct_cp< copies.size();ct_cp++){
	int idleg=(*leginiz).id_atomo();
	if(idleg==copies[ct_cp].id() && copies[ct_cp].id_gruppo()==tmp_i->id_gruppo()){
	  found =true;
	}
      }
      leginiz++;
    }
  }
  */

  /*  
  bool found[2]={false,false};
  int ptf=0;
  for(unsigned int i =0;i< copies.size(); i++){
    atomo atm=copies[i];
    vector<legame>::iterator leginiz=atm.primo_leg();
    vector<legame>::iterator legfin=atm.ultimo_leg();
    while(leginiz!=legfin){
      int idleg=(*leginiz).id_atomo();
      //bool exists=false;
      for(unsigned int ct_cp=0;ct_cp< copies.size();ct_cp++){
	cout << "xxxidatt " << idleg 
	     << " bfiglio di " << atm.id() << " " 
	     << " copies[ct_cp].id() " << copies[ct_cp].id()
	     << " copies[ct_cp].id_gruppo() " << copies[ct_cp].id_gruppo()
	     <<  " atm.id_gruppo() " << atm.id_gruppo() << endl;
	if(idleg==copies[ct_cp].id() && copies[ct_cp].id_gruppo()==atm.id_gruppo()){
	  found[ptf]=true;
	  if(ptf<2){
	    ptf++;
	  }
	}
      }

      leginiz++;
    }
    
  }
  

  if(!(found[0] && found[1])){
    cout << _("xxxError: two atoms are not directly linked") << endl;
    return false;
  }
  */
  return result;
  

}



void join_ring::connect_molecules(){
  cout << "zzz start connecting" << endl;
  vector< pair < int, pair<int,int> > >* elem=r_elem_selected();
  vector <gruppo>* gruppi=r_groups();

  


  vector<atomo> copies_group_st;
  vector<atomo> copies_group_arr;

  for(unsigned int y=0;y<gruppi->size();y++){
    cout << "zzz y: " << y << endl;
    bool stop=false;
    if((*gruppi)[y].id_gruppo()==((*elem)[0].second).first){
      vector<atomo>::iterator in=(*gruppi)[y].iniz_atom();
      vector<atomo>::iterator fi=(*gruppi)[y].fin_atom();
      while(in!=fi){
	if((*in).id()==((*elem)[0].second).second){
	  copies_group_st.push_back((*in));
	  stop=true;
	  break;
	}
	in++;
      }
    }
    if(stop){
      break;
    }
  }

  cout << "zzz primo aggiunto: " << copies_group_st[0].id() 
       <<  " " << copies_group_st[0].id_gruppo() << endl;

  /**
   *Contiene  coppie <tipo, < gruppo, id > > selezionati, se  si e'
   *selezionato una etichetta gruppo e' uguale a NO_VALID_GROUP
   */


  for(unsigned int i=0;i<elem->size();i++){
    cout << "zzz sel: " <<  (*elem)[i].first <<
      " " << (*elem)[i].second.second << " " << (*elem)[i].second.first << endl;
  }


  
  for(unsigned int i=0;i<elem->size();i++){

    for(unsigned int el_sel=0;el_sel<copies_group_st.size();el_sel++){
      cout << "zzz el_sel_st: " << el_sel << endl;
      if(copies_group_st[el_sel].id_gruppo()==(*elem)[i].second.first &&
	 copies_group_st[el_sel].id()!=(*elem)[i].second.second){
	atomo* tmp=_the_image->ritorna_atomo_ident(copies_group_st[el_sel].id_gruppo(),
				       (*elem)[i].second.second);
	copies_group_st.push_back((*tmp));
	break;
      }
      
    }

	
    if(copies_group_arr.size()<=0){
      cout << "zzzAHHOO" << endl;
      if((*elem)[i].second.first!=copies_group_st[0].id_gruppo()){
	atomo* tmp=_the_image->ritorna_atomo_ident((*elem)[i].second.first,
						   (*elem)[i].second.second);
	copies_group_arr.push_back((*tmp));
	//break;
      }
    }

    for(unsigned int el_sel=0;el_sel<copies_group_arr.size();el_sel++){

	if(copies_group_arr[el_sel].id_gruppo()==(*elem)[i].second.first &&
	   copies_group_arr[el_sel].id()!=(*elem)[i].second.second){
	  atomo* tmp=_the_image->ritorna_atomo_ident(copies_group_arr[el_sel].id_gruppo(),
						     (*elem)[i].second.second);
	  copies_group_arr.push_back((*tmp));
	  break;
	}
      
    }
  }
  

  cout << "zzz size" << copies_group_st.size() << " " << copies_group_arr.size() << endl;

  for(unsigned int i=0;i<copies_group_st.size();i++){
    cout << "zzz finale " 
	 << copies_group_st[i].id() << " " << copies_group_st[i].id_gruppo()<< " arr" 
	 << copies_group_arr[i].id()  <<  " " << copies_group_arr[i].id_gruppo() <<endl;
  }


  /*
  int pos_group_start=-1;
  int pos_group_arr=-1;

  for(unsigned int i=0;i< gruppi->size();i++){
    if((*gruppi)[i].id()==copies_group_st[0].id_gruppo()){
      pos_group_start=i;
    }else if((*gruppi)[i].id()==copies_group_arr[0].id_gruppo()){
      pos_group_arr=i;
    }
  }

  //id del piu' grande degli id del gruppo cui st appartiene
  int id_st_max=(*(((*gruppi)[pos_group_start]).fin_atom()-1)).id()+1;
  

  //id previsto per l'atomo a cui aggiungere i legami per secondo
  int pos_id_atm_rem=0;

  vector<atomo>::iterator in=(*gruppi)[pos_group_arr].iniz_atom();
  vector<atomo>::iterator fi=(*gruppi)[pos_group_arr].fin_atom();  

  while(in!=fi){
    if((*in).id()==copies_group_arr[1].id()){
      break;
    }
    pos_id_atm_rem++;
    in++;
  }
  */


  int group_id_backup=copies_group_st[0].id_gruppo();
  int pos_group_st_back=-1;
  int nw_id_start=copies_group_st[0].id_gruppo();

  if(copies_group_st[0].id_gruppo() > copies_group_arr[0].id_gruppo()){
    nw_id_start=-1;

    
    for(unsigned int i=0;i< gruppi->size();i++){
      if((*gruppi)[i].id()==copies_group_st[0].id_gruppo()){
	pos_group_st_back=i;
      }
    }

    gruppo* shift=&(*gruppi)[pos_group_st_back];
    shift->id_gruppo(nw_id_start);
    atomo* first=_the_image->ritorna_atomo_ident(nw_id_start,
						 copies_group_st[0].id());
    atomo* second=_the_image->ritorna_atomo_ident(nw_id_start,
						  copies_group_st[1].id());



    
    copies_group_st.erase(copies_group_st.begin(),copies_group_st.end());
    copies_group_st.push_back(*first);
    copies_group_st.push_back(*second);
    cout << "pppp dopo lo scambio " <<  copies_group_st[0].id() 
	 << " " <<  copies_group_st[0].id_gruppo()
	 << " "  
	 << copies_group_st[1].id() << " " << copies_group_st[0].id_gruppo() << endl;

    //return;
    //    copies_group_arr[0]=
  }
  

  adjust(copies_group_st, copies_group_arr);


  int the_prevision[2];
  prevision(the_prevision,copies_group_st ,copies_group_arr);


  cout << "ppp prevision" << the_prevision[0] << " " << the_prevision[1] << endl;


  //previsione  (se ho ben capito)
  
  //int id_prev=id_st_max+pos_id_atm_rem;
  

  //cout << "zzzz previsione: " << id_prev << endl;

  //copiamo i primi vicini degli atomi contenuti copies_group_st nel gruppo 
  
  
  atomo* start_st=_the_image->ritorna_atomo_ident(copies_group_st[0].id_gruppo(),
						  copies_group_st[0].id());
  
  atomo* atm_arr=_the_image->ritorna_atomo_ident(copies_group_arr[0].id_gruppo(),
						  copies_group_arr[0].id());
  vector<legame>::iterator in_leg=start_st->primo_leg();
  vector<legame>::iterator fi_leg=start_st->ultimo_leg();

  while(in_leg!=fi_leg){
    cout << "ppp comincio!" << endl;
    if((*in_leg).id_atomo() != copies_group_st[1].id()){

      cout << "ppp cerco di legare (id_gruppo, id_atomo): " 
	   << copies_group_st[0].id_gruppo() << " " << (*in_leg).id_atomo() 
	   << " a " 
	   << atm_arr->id_gruppo() << " " << atm_arr->id() << endl;

      

      atomo* picked=_the_image->ritorna_atomo_ident(copies_group_st[0].id_gruppo(),
						    (*in_leg).id_atomo());
      
      cout << "ppp atomo ritorna indirizzo " << picked << " " 
	   << copies_group_st[0].id_gruppo() <<endl;

      _the_image->crea_legame_nuovo(picked,atm_arr ,(*in_leg).tipo_legame());
      
      cout << "ppp creato con successo!!!" << endl;
      //return;
      //cout << "zzz iii " << iii << " " <<  picked->id() 
      //	   << "id_gruppo: " <<   picked->id_gruppo()<< endl;

      //int ppo=copies_group_st[0].id();;

      for(unsigned int j=0;j<gruppi->size();j++){
	cout << "ppp dump_gruppo " << &((*gruppi)[j]) 
	     << " " << (*gruppi)[j].id_gruppo()<< endl;
	
      }


      cout << "ppp rrrrrrrrrrrrrrrrrrrr" << endl;

      for(unsigned int jj=0;jj<gruppi->size();jj++){
	if((*gruppi)[jj].id_gruppo()==nw_id_start){
	  copies_group_st[0].aggiungi_genitore(&(*gruppi)[jj]);
	  copies_group_st[1].aggiungi_genitore(&(*gruppi)[jj]);
	}
      }

      atm_arr=_the_image->ritorna_atomo_ident(copies_group_st[0].id_gruppo(),
					      the_prevision[0]);
      cout << "ppppp okkkkkk" << endl;
      //return;
      //break;

    }
    in_leg++;
    cout << "ppp finicco" << endl;

  }

  cout << "pppp hhhhhhhhhhhhhhhh "  << endl;

  
    
  start_st=_the_image->ritorna_atomo_ident(copies_group_st[1].id_gruppo(),
						  copies_group_st[1].id());
  atm_arr=_the_image->ritorna_atomo_ident(copies_group_st[1].id_gruppo(),
					  the_prevision[1]);
  in_leg=start_st->primo_leg();
  fi_leg=start_st->ultimo_leg();

  while(in_leg!=fi_leg){
    if((*in_leg).id_atomo() != copies_group_st[0].id()){
      atomo* picked=_the_image->ritorna_atomo_ident(start_st->id_gruppo(),
						    (*in_leg).id_atomo());
      
      _the_image->crea_legame_nuovo(picked, atm_arr ,(*in_leg).tipo_legame());
    }
    in_leg++;

  }
  
  for(unsigned int jj=0;jj<gruppi->size();jj++){
    if((*gruppi)[jj].id_gruppo()==nw_id_start){
      (*gruppi)[jj].id_gruppo(group_id_backup);
    }
  }
  


  
  _the_image->elimina_elem_selected();
  _the_image->elimina_legami_selected();
  
  
  _the_image->aggiungi_elem_selected(ATOMO,copies_group_st[0].id_gruppo(),
  			     copies_group_st[0].id());
  _the_image->aggiungi_elem_selected(ATOMO,copies_group_st[1].id_gruppo(),
				     copies_group_st[1].id());
  

  if(_delete_old){
    _the_image->cancella_elementi_selected();
    _the_image->elimina_elem_selected();
    _the_image->elimina_legami_selected();
  }

  
  sort(gruppi->begin(),gruppi->end(),ordina_gruppo_id);

}



void join_ring::adjust(vector<atomo>& start , vector<atomo>& arr){
  vector< pair <float, float> > start_v;
  vector< pair <float, float> > end_v;
  //costruiamo i vettori

  start_v.push_back(pair<float,float>(start[0].pos_x(),start[0].pos_y()));
  start_v.push_back(pair<float,float>(start[1].pos_x(),start[1].pos_y()));
  /*
  if(start[0].pos_y()<start[1].pos_y()){
    pair<float,float> tmp=start_v[0];
    start_v[0]=start_v[1];
    start_v[1]=tmp;
  }
  */
  end_v.push_back(pair<float,float>(arr[0].pos_x(),arr[0].pos_y()));
  end_v.push_back(pair<float,float>(arr[1].pos_x(),arr[1].pos_y()));
  /*
  if(arr[0].pos_y()<arr[1].pos_y()){
    pair<float,float> tmp=end_v[0];
    end_v[0]=end_v[1];
    end_v[1]=tmp;
  }
  */
  pair<float,float> vec_start;
  float comp_x_start = start_v[0].first - start_v[1].first;
  float comp_y_start = start_v[0].second - start_v[1].second;
  vec_start.first=comp_x_start;
  vec_start.second=comp_y_start;
  

  pair<float,float> vec_end;
  float comp_x_end = end_v[0].first - end_v[1].first;
  float comp_y_end = end_v[0].second - end_v[1].second;
  vec_end.first=comp_x_end;
  vec_end.second=comp_y_end;

  float vec_start_mag=sqrt( pow(vec_start.first,2) + pow(vec_start.second,2) );
  float vec_end_mag=sqrt( pow(vec_end.first,2) + pow(vec_end.second,2) );

  float dot_product= vec_start.first * vec_end.first + vec_start.second * vec_end.second;


  float teta=acos(dot_product/(vec_start_mag * vec_end_mag));

  //cout << "plg: vettore start: [ " << vec_start.first << " , " << vec_start.second << " ]" << endl;
  //cout << "plg: vettore end: [ " << vec_end.first << " , " << vec_end.second << " ]" << endl;
  
  float pivot[2]={0,0};
  vector <gruppo>* gruppi=r_groups();  

  for(unsigned int i=0;i<gruppi->size();i++){
    if(start[0].id_gruppo()==(*gruppi)[i].id_gruppo()){
      //pivot[0]= (*gruppi)[i].posx() + (*gruppi)[i].w() / 2;
      //pivot[1]= (*gruppi)[i].posy() + (*gruppi)[i].h() / 2;
      //cout << "plg teta: " << teta*180/M_PI << " vec_p " << dot_product << endl;
      /*
      cout << "ruota di teta pivot (x,y): " << pivot[0] 
	   << " " << pivot[1] <<endl;
      */
      float dx=arr[0].pos_x() - start[0].pos_x();
      float dy=arr[0].pos_y() - start[0].pos_y();
      (*gruppi)[i].trasla(dx,dy);
      vector<atomo>::iterator in=(*gruppi)[i].iniz_atom();
      vector<atomo>::iterator fi=(*gruppi)[i].fin_atom();  
      while(in!=fi){
	if(start[0].id()==(*in).id()){
	  pivot[0]=(*in).pos_x();
	  pivot[1]=(*in).pos_y();
	}
	in++;
      }

      if(dot_product >=0){
	//cout << "teta: diff" << vec_end.first - vec_start.first << " "
	//     << vec_end.first << " " <<  vec_start.first<<endl;
	if( vec_end.first - vec_start.first < 0){
	  //cout << "plg teta acuto dx <0" << endl;
	  (*gruppi)[i].ruota(teta,pivot[0],pivot[1]);
	}else{
	  //cout << "plg teta acuto dx >0" << endl;
	  (*gruppi)[i].ruota(-teta,pivot[0],pivot[1]);
	}
      }else{
	//cout << "plg teta ottuso dx <0" << endl;
	(*gruppi)[i].ruota(teta,pivot[0],pivot[1]);
      }
      break;
    }
  }


  
  

}


void join_ring::prevision(int* res,vector<atomo>& start , vector<atomo>& arr){
  //vector< pair < int, pair<int,int> > >* elem=r_elem_selected();
  vector <gruppo>* gruppi=r_groups();



  int pos_group_start=-1;
  int pos_group_arr=-1;

  for(unsigned int i=0;i< gruppi->size();i++){
    if((*gruppi)[i].id()==start[0].id_gruppo()){
      pos_group_start=i;
    }else if((*gruppi)[i].id()==arr[0].id_gruppo()){
      pos_group_arr=i;
    }
  }

  //id del piu' grande degli id del gruppo cui st appartiene
  int id_st_max=(*(((*gruppi)[pos_group_start]).fin_atom()-1)).id()+1;

  cout << " uuu " << id_st_max <<endl;
  
  



  int pos_id_atm_rem_1=0;
  int pos_id_atm_rem_2=0;

  //id previsto per l'atomo a cui aggiungere i legami per primo
  vector<atomo>::iterator in=(*gruppi)[pos_group_arr].iniz_atom();
  vector<atomo>::iterator fi=(*gruppi)[pos_group_arr].fin_atom();  

  while(in!=fi){
    if((*in).id()==arr[0].id()){
      break;
    }
    pos_id_atm_rem_1++;
    in++;
  }

  cout << "uuu rem_1 " << pos_id_atm_rem_1 <<endl;

  //id previsto per l'atomo a cui aggiungere i legami per secondo
  in=(*gruppi)[pos_group_arr].iniz_atom();
  fi=(*gruppi)[pos_group_arr].fin_atom();  

  while(in!=fi){
    if((*in).id()==arr[1].id()){
      break;
    }
    pos_id_atm_rem_2++;
    in++;
  }
  
  res[0]=id_st_max+pos_id_atm_rem_1;
  //cout << "uuures[0] " << res[0] <<endl;
  res[1]=id_st_max+pos_id_atm_rem_2;


}



/**************fine metodi di classe**********************************/




extern "C" bist_plugin* create_plugin(immagine* imm, string libpath){
  return new join_ring(imm, libpath);
}

extern "C" void destroy_plugin(bist_plugin* j){
  cout << "distruzione plugin: " << j <<  endl;
  delete j;
  cout << "riuscita" << endl;
}


