/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.misc.MACEDecoder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SoundResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1936614432;
    public static final int SQUAREWAVESYNTH = 1;
    public static final int WAVETABLESYNTH = 3;
    public static final int SAMPLEDSYNTH = 5;
    public static final int INITCHANLEFT = 2;
    public static final int INITCHANRIGHT = 3;
    public static final int WAVECHANNEL0 = 4;
    public static final int WAVECHANNEL1 = 5;
    public static final int WAVECHANNEL2 = 6;
    public static final int WAVECHANNEL3 = 7;
    public static final int INITMONO = 128;
    public static final int INITSTEREO = 192;
    public static final int INITMACE3 = 768;
    public static final int INITMACE6 = 1024;
    public static final int INITNOINTERP = 4;
    public static final int INITNODROP = 8;
    public static final int INITPANMASK = 3;
    public static final int INITSRATEMASK = 48;
    public static final int INITSTEREOMASK = 192;
    public static final int INITCOMPMASK = 65280;
    public static final int NULLCMD = 0;
    public static final int QUIETCMD = 3;
    public static final int FLUSHCMD = 4;
    public static final int REINITCMD = 5;
    public static final int WAITCMD = 10;
    public static final int PAUSECMD = 11;
    public static final int RESUMECMD = 12;
    public static final int CALLBACKCMD = 13;
    public static final int SYNCCMD = 14;
    public static final int AVAILABLECMD = 24;
    public static final int VERSIONCMD = 25;
    public static final int TOTALLOADCMD = 26;
    public static final int LOADCMD = 27;
    public static final int FREQDURATIONCMD = 40;
    public static final int RESTCMD = 41;
    public static final int FREQCMD = 42;
    public static final int AMPCMD = 43;
    public static final int TIMBRECMD = 44;
    public static final int GETAMPCMD = 45;
    public static final int VOLUMECMD = 46;
    public static final int GETVOLUMECMD = 47;
    public static final int WAVETABLECMD = 60;
    public static final int SOUNDCMD = 80;
    public static final int BUFFERCMD = 81;
    public static final int RATECMD = 82;
    public static final int GETRATECMD = 85;
    public static final int DATAOFFSETFLAG = Short.MIN_VALUE;
    public static final int RATE_44KHZ = -1404829696;
    public static final int RATE_22KHZ = 1458473891;
    public static final int RATE_22050KHZ = 1445068800;
    public static final int RATE_11KHZ = 729236945;
    public static final int RATE_11025KHZ = 722534400;
    public static final int STDSH = 0;
    public static final int EXTSH = -1;
    public static final int CMPSH = -2;
    private static final int RIFF = KSFLUtilities.fcc("RIFF");
    private static final int WAVE = KSFLUtilities.fcc("WAVE");
    private static final int FMT = KSFLUtilities.fcc("fmt ");
    private static final int DATA = KSFLUtilities.fcc("data");
    private static final int CYNH = KSFLUtilities.fcc("Cynh");
    private static final int FORM = KSFLUtilities.fcc("FORM");
    private static final int AIFC = KSFLUtilities.fcc("AIFC");
    private static final int FVER = KSFLUtilities.fcc("FVER");
    private static final int COMM = KSFLUtilities.fcc("COMM");
    private static final int SSND = KSFLUtilities.fcc("SSND");
    private static final short EXPONENT_44KHZ = 16398;
    private static final long MANTISSA_44KHZ = -6033697600769622016L;
    private static final short EXPONENT_22KHZ = 16397;
    private static final long MANTISSA_22KHZ = -5918548746663787925L;
    private static final short EXPONENT_22050KHZ = 16397;
    private static final long MANTISSA_22050KHZ = -6033697600769622016L;
    private static final short EXPONENT_11KHZ = 16396;
    private static final long MANTISSA_11KHZ = -5918548746663787925L;
    private static final short EXPONENT_11025KHZ = 16396;
    private static final long MANTISSA_11025KHZ = -6033697600769622016L;
    private static final short COMPID_NONE = 0;
    private static final short COMPID_ACE_2TO1 = 1;
    private static final short COMPID_ACE_8TO3 = 2;
    private static final short COMPID_MACE_3TO1 = 3;
    private static final short COMPID_MACE_6TO1 = 4;
    private static final short COMPID_USE_FORMAT = -1;
    private static final int FORMAT_NONE = 1313820229;
    private static final int FORMAT_ACE_2TO1 = 1094927666;
    private static final int FORMAT_ACE_8TO3 = 1094927672;
    private static final int FORMAT_MACE_3TO1 = 1296122675;
    private static final int FORMAT_MACE_6TO1 = 1296122678;
    private static final byte[] COMPNAME_NONE;
    private static final byte[] COMPNAME_ACE_2TO1;
    private static final byte[] COMPNAME_ACE_8TO3;
    private static final byte[] COMPNAME_MACE_3TO1;
    private static final byte[] COMPNAME_MACE_6TO1;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 14;
        byArray[1] = 110;
        byArray[2] = 111;
        byArray[3] = 116;
        byArray[4] = 32;
        byArray[5] = 99;
        byArray[6] = 111;
        byArray[7] = 109;
        byArray[8] = 112;
        byArray[9] = 114;
        byArray[10] = 101;
        byArray[11] = 115;
        byArray[12] = 115;
        byArray[13] = 101;
        byArray[14] = 100;
        COMPNAME_NONE = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 10;
        byArray2[1] = 65;
        byArray2[2] = 67;
        byArray2[3] = 69;
        byArray2[4] = 32;
        byArray2[5] = 50;
        byArray2[6] = 45;
        byArray2[7] = 116;
        byArray2[8] = 111;
        byArray2[9] = 45;
        byArray2[10] = 49;
        COMPNAME_ACE_2TO1 = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 10;
        byArray3[1] = 65;
        byArray3[2] = 67;
        byArray3[3] = 69;
        byArray3[4] = 32;
        byArray3[5] = 56;
        byArray3[6] = 45;
        byArray3[7] = 116;
        byArray3[8] = 111;
        byArray3[9] = 45;
        byArray3[10] = 51;
        COMPNAME_ACE_8TO3 = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 11;
        byArray4[1] = 77;
        byArray4[2] = 65;
        byArray4[3] = 67;
        byArray4[4] = 69;
        byArray4[5] = 32;
        byArray4[6] = 51;
        byArray4[7] = 45;
        byArray4[8] = 116;
        byArray4[9] = 111;
        byArray4[10] = 45;
        byArray4[11] = 49;
        COMPNAME_MACE_3TO1 = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[0] = 11;
        byArray5[1] = 77;
        byArray5[2] = 65;
        byArray5[3] = 67;
        byArray5[4] = 69;
        byArray5[5] = 32;
        byArray5[6] = 54;
        byArray5[7] = 45;
        byArray5[8] = 116;
        byArray5[9] = 111;
        byArray5[10] = 45;
        byArray5[11] = 49;
        COMPNAME_MACE_6TO1 = byArray5;
    }

    public static boolean isMyType(int type) {
        return type == 1936614432;
    }

    public SoundResource(short id, byte[] data) {
        super(1936614432, id, data);
    }

    public SoundResource(short id, String name, byte[] data) {
        super(1936614432, id, name, data);
    }

    public SoundResource(short id, byte attr, byte[] data) {
        super(1936614432, id, attr, data);
    }

    public SoundResource(short id, byte attr, String name, byte[] data) {
        super(1936614432, id, attr, name, data);
    }

    public SoundResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public SoundResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public SoundResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public SoundResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public int getFormat() {
        return KSFLUtilities.getShort(this.data, 0);
    }

    public int getRefCon() {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 2: {
                return KSFLUtilities.getShort(this.data, 2);
            }
        }
        return 0;
    }

    public int getDataFormatCount() {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return KSFLUtilities.getShort(this.data, 2);
            }
        }
        return 0;
    }

    public int getDataFormatID(int index) {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return KSFLUtilities.getShort(this.data, 4 + 6 * index);
            }
        }
        return 0;
    }

    public int getDataFormatInitOption(int index) {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return KSFLUtilities.getInt(this.data, 6 + 6 * index);
            }
        }
        return 0;
    }

    public int getCommandCount() {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return KSFLUtilities.getShort(this.data, 4 + 6 * KSFLUtilities.getShort(this.data, 2));
            }
            case 2: {
                return KSFLUtilities.getShort(this.data, 4);
            }
        }
        return 0;
    }

    public int getCommand(int index) {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return KSFLUtilities.getShort(this.data, 6 + 6 * KSFLUtilities.getShort(this.data, 2) + 8 * index);
            }
            case 2: {
                return KSFLUtilities.getShort(this.data, 6 + 8 * index);
            }
        }
        return 0;
    }

    public int getCommandParam1(int index) {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return KSFLUtilities.getShort(this.data, 8 + 6 * KSFLUtilities.getShort(this.data, 2) + 8 * index);
            }
            case 2: {
                return KSFLUtilities.getShort(this.data, 8 + 8 * index);
            }
        }
        return 0;
    }

    public int getCommandParam2(int index) {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return KSFLUtilities.getShort(this.data, 10 + 6 * KSFLUtilities.getShort(this.data, 2) + 8 * index);
            }
            case 2: {
                return KSFLUtilities.getShort(this.data, 10 + 8 * index);
            }
        }
        return 0;
    }

    public int getSoundDataOffset() {
        switch (KSFLUtilities.getShort(this.data, 0)) {
            case 1: {
                return 6 + 6 * KSFLUtilities.getShort(this.data, 2) + 8 * KSFLUtilities.getShort(this.data, 4 + 6 * KSFLUtilities.getShort(this.data, 2));
            }
            case 2: {
                return 6 + 8 * KSFLUtilities.getShort(this.data, 4);
            }
        }
        return 2;
    }

    public String getCodecName() {
        if (this.getFormat() < 1 || this.getFormat() > 2) {
            return null;
        }
        int i = 0;
        while (i < this.getCommandCount()) {
            int cmd = this.getCommand(i) & Short.MAX_VALUE;
            if (cmd != 0 && cmd != 80 && cmd != 81) {
                return null;
            }
            ++i;
        }
        int o = this.getSoundDataOffset();
        byte encoding = this.data[o + 20];
        if (encoding == -2) {
            int format = KSFLUtilities.getInt(this.data, o + 40);
            short compressionID = KSFLUtilities.getShort(this.data, o + 56);
            switch (compressionID) {
                case 0: {
                    return new String(COMPNAME_NONE).trim();
                }
                case 1: {
                    return new String(COMPNAME_ACE_2TO1).trim();
                }
                case 2: {
                    return new String(COMPNAME_ACE_8TO3).trim();
                }
                case 3: {
                    return new String(COMPNAME_MACE_3TO1).trim();
                }
                case 4: {
                    return new String(COMPNAME_MACE_6TO1).trim();
                }
                case -1: {
                    switch (format) {
                        case 1313820229: {
                            return new String(COMPNAME_NONE).trim();
                        }
                        case 1094927666: {
                            return new String(COMPNAME_ACE_2TO1).trim();
                        }
                        case 1094927672: {
                            return new String(COMPNAME_ACE_8TO3).trim();
                        }
                        case 1296122675: {
                            return new String(COMPNAME_MACE_3TO1).trim();
                        }
                        case 1296122678: {
                            return new String(COMPNAME_MACE_6TO1).trim();
                        }
                    }
                    return null;
                }
            }
            return null;
        }
        if (encoding == -1 || encoding == 0) {
            return new String(COMPNAME_NONE).trim();
        }
        return null;
    }

    public byte[] toWav() {
        if (this.getFormat() < 1 || this.getFormat() > 2) {
            return null;
        }
        int i = 0;
        while (i < this.getCommandCount()) {
            int cmd = this.getCommand(i) & Short.MAX_VALUE;
            if (cmd != 0 && cmd != 80 && cmd != 81) {
                return null;
            }
            ++i;
        }
        int o = this.getSoundDataOffset();
        int numBytes = KSFLUtilities.getInt(this.data, o + 4);
        int padding = 0;
        while ((numBytes + padding & 3) != 0) {
            ++padding;
        }
        int sampleRate = KSFLUtilities.getInt(this.data, o + 8);
        int loopStart = KSFLUtilities.getInt(this.data, o + 12);
        int loopEnd = KSFLUtilities.getInt(this.data, o + 16);
        byte encoding = this.data[o + 20];
        byte baseFrequency = this.data[o + 21];
        if (encoding == -2) {
            int numFrames = KSFLUtilities.getInt(this.data, o + 22);
            int format = KSFLUtilities.getInt(this.data, o + 40);
            short compressionID = KSFLUtilities.getShort(this.data, o + 56);
            short sampleSize = KSFLUtilities.getShort(this.data, o + 62);
            int sampleBytes = (sampleSize + 7) / 8;
            byte[] newdata = KSFLUtilities.copy(this.data, o + 22, numBytes * numFrames * sampleBytes);
            block3 : switch (compressionID) {
                case 0: {
                    break;
                }
                case 3: {
                    newdata = MACEDecoder.decompressMACE3(newdata, numBytes);
                    break;
                }
                case 4: {
                    newdata = MACEDecoder.decompressMACE6(newdata, numBytes);
                    break;
                }
                case -1: {
                    switch (format) {
                        case 1313820229: {
                            break block3;
                        }
                        case 1296122675: {
                            newdata = MACEDecoder.decompressMACE3(newdata, numBytes);
                            break block3;
                        }
                        case 1296122678: {
                            newdata = MACEDecoder.decompressMACE6(newdata, numBytes);
                            break block3;
                        }
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            int flength = newdata.length;
            int fpadding = 0;
            while ((flength + fpadding & 3) != 0) {
                ++fpadding;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream out2 = new DataOutputStream(out);
                out2.writeInt(RIFF);
                out2.writeInt(Integer.reverseBytes(56 + flength + fpadding));
                out2.writeInt(WAVE);
                out2.writeInt(FMT);
                out2.writeInt(0x10000000);
                out2.writeShort(256);
                out2.writeShort(Short.reverseBytes((short)numBytes));
                out2.writeInt(Integer.reverseBytes(sampleRate >>> 16));
                out2.writeInt(Integer.reverseBytes(numBytes * (sampleRate >>> 16) * sampleBytes));
                out2.writeShort(Short.reverseBytes((short)(numBytes * sampleBytes)));
                out2.writeShort(Short.reverseBytes(sampleSize));
                out2.writeInt(DATA);
                out2.writeInt(Integer.reverseBytes(flength + fpadding));
                if (sampleBytes == 1) {
                    int i2 = 0;
                    while (i2 < newdata.length) {
                        int n = i2++;
                        newdata[n] = (byte)(newdata[n] ^ 0x80);
                    }
                    out2.write(newdata);
                    i2 = 0;
                    while (i2 < fpadding) {
                        out2.writeByte(128);
                        ++i2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < newdata.length) {
                        int j = 0;
                        int k = sampleBytes - 1;
                        while (j < sampleBytes / 2) {
                            byte t = newdata[i3 + j];
                            newdata[i3 + j] = newdata[i3 + k];
                            newdata[i3 + k] = t;
                            ++j;
                            --k;
                        }
                        i3 += sampleBytes;
                    }
                    out2.write(newdata);
                    i3 = 0;
                    while (i3 < fpadding) {
                        out2.writeByte(0);
                        ++i3;
                    }
                }
                out2.writeInt(CYNH);
                out2.writeInt(0xC000000);
                out2.writeInt(Integer.reverseBytes(loopStart));
                out2.writeInt(Integer.reverseBytes(loopEnd));
                out2.writeInt(Integer.reverseBytes(baseFrequency));
                out2.close();
                out.close();
                return out.toByteArray();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (encoding == -1) {
            int numFrames = KSFLUtilities.getInt(this.data, o + 22);
            short sampleSize = KSFLUtilities.getShort(this.data, o + 48);
            int sampleBytes = (sampleSize + 7) / 8;
            byte[] newdata = KSFLUtilities.copy(this.data, o + 64, numBytes * numFrames * sampleBytes);
            int flength = newdata.length;
            int fpadding = 0;
            while ((flength + fpadding & 3) != 0) {
                ++fpadding;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream out2 = new DataOutputStream(out);
                out2.writeInt(RIFF);
                out2.writeInt(Integer.reverseBytes(56 + flength + fpadding));
                out2.writeInt(WAVE);
                out2.writeInt(FMT);
                out2.writeInt(0x10000000);
                out2.writeShort(256);
                out2.writeShort(Short.reverseBytes((short)numBytes));
                out2.writeInt(Integer.reverseBytes(sampleRate >>> 16));
                out2.writeInt(Integer.reverseBytes(numBytes * (sampleRate >>> 16) * sampleBytes));
                out2.writeShort(Short.reverseBytes((short)(numBytes * sampleBytes)));
                out2.writeShort(Short.reverseBytes(sampleSize));
                out2.writeInt(DATA);
                out2.writeInt(Integer.reverseBytes(flength + fpadding));
                if (sampleBytes == 1) {
                    int i4 = 0;
                    while (i4 < newdata.length) {
                        int n = i4++;
                        newdata[n] = (byte)(newdata[n] ^ 0x80);
                    }
                    out2.write(newdata);
                    i4 = 0;
                    while (i4 < fpadding) {
                        out2.writeByte(128);
                        ++i4;
                    }
                } else {
                    int i5 = 0;
                    while (i5 < newdata.length) {
                        int j = 0;
                        int k = sampleBytes - 1;
                        while (j < sampleBytes / 2) {
                            byte t = newdata[i5 + j];
                            newdata[i5 + j] = newdata[i5 + k];
                            newdata[i5 + k] = t;
                            ++j;
                            --k;
                        }
                        i5 += sampleBytes;
                    }
                    out2.write(newdata);
                    i5 = 0;
                    while (i5 < fpadding) {
                        out2.writeByte(0);
                        ++i5;
                    }
                }
                out2.writeInt(CYNH);
                out2.writeInt(0xC000000);
                out2.writeInt(Integer.reverseBytes(loopStart));
                out2.writeInt(Integer.reverseBytes(loopEnd));
                out2.writeInt(Integer.reverseBytes(baseFrequency));
                out2.close();
                out.close();
                return out.toByteArray();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (encoding == 0) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream out2 = new DataOutputStream(out);
                out2.writeInt(RIFF);
                out2.writeInt(Integer.reverseBytes(56 + numBytes + padding));
                out2.writeInt(WAVE);
                out2.writeInt(FMT);
                out2.writeInt(0x10000000);
                out2.writeShort(256);
                out2.writeShort(256);
                out2.writeInt(Integer.reverseBytes(sampleRate >>> 16));
                out2.writeInt(Integer.reverseBytes(sampleRate >>> 16));
                out2.writeShort(256);
                out2.writeShort(2048);
                out2.writeInt(DATA);
                out2.writeInt(Integer.reverseBytes(numBytes + padding));
                out2.write(this.data, o + 22, numBytes);
                int i6 = 0;
                while (i6 < padding) {
                    out2.writeByte(128);
                    ++i6;
                }
                out2.writeInt(CYNH);
                out2.writeInt(0xC000000);
                out2.writeInt(Integer.reverseBytes(loopStart));
                out2.writeInt(Integer.reverseBytes(loopEnd));
                out2.writeInt(Integer.reverseBytes(baseFrequency));
                out2.close();
                out.close();
                return out.toByteArray();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }

    public byte[] toAiff() {
        if (this.getFormat() < 1 || this.getFormat() > 2) {
            return null;
        }
        int i = 0;
        while (i < this.getCommandCount()) {
            int cmd = this.getCommand(i) & Short.MAX_VALUE;
            if (cmd != 0 && cmd != 80 && cmd != 81) {
                return null;
            }
            ++i;
        }
        int o = this.getSoundDataOffset();
        int numBytes = KSFLUtilities.getInt(this.data, o + 4);
        int padding = 0;
        while ((numBytes + padding & 1) != 0) {
            ++padding;
        }
        int sampleRate = KSFLUtilities.getInt(this.data, o + 8);
        int loopStart = KSFLUtilities.getInt(this.data, o + 12);
        int loopEnd = KSFLUtilities.getInt(this.data, o + 16);
        byte encoding = this.data[o + 20];
        byte baseFrequency = this.data[o + 21];
        if (encoding == -2) {
            int numFrames = KSFLUtilities.getInt(this.data, o + 22);
            short aiffSampleRateExponent = KSFLUtilities.getShort(this.data, o + 26);
            long aiffSampleRateMantissa = KSFLUtilities.getLong(this.data, o + 28);
            int format = KSFLUtilities.getInt(this.data, o + 40);
            short compressionID = KSFLUtilities.getShort(this.data, o + 56);
            short sampleSize = KSFLUtilities.getShort(this.data, o + 62);
            int sampleBytes = (sampleSize + 7) / 8;
            int flength = numBytes * numFrames * sampleBytes;
            int fpadding = 0;
            while ((flength + fpadding & 1) != 0) {
                ++fpadding;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream out2 = new DataOutputStream(out);
            out2.writeInt(FORM);
            out2.writeInt(98 + flength + fpadding);
            out2.writeInt(AIFC);
            out2.writeInt(FVER);
            out2.writeInt(4);
            out2.writeInt(-1568648896);
            out2.writeInt(COMM);
            out2.writeInt(38);
            out2.writeShort(numBytes);
            out2.writeInt(numFrames);
            out2.writeShort(sampleSize);
            out2.writeShort(aiffSampleRateExponent);
            out2.writeLong(aiffSampleRateMantissa);
            block5 : switch (compressionID) {
                case 0: {
                    out2.writeInt(1313820229);
                    out2.write(COMPNAME_NONE);
                    break;
                }
                case 1: {
                    out2.writeInt(1094927666);
                    out2.write(COMPNAME_ACE_2TO1);
                    break;
                }
                case 2: {
                    out2.writeInt(1094927672);
                    out2.write(COMPNAME_ACE_8TO3);
                    break;
                }
                case 3: {
                    out2.writeInt(1296122675);
                    out2.write(COMPNAME_MACE_3TO1);
                    break;
                }
                case 4: {
                    out2.writeInt(1296122678);
                    out2.write(COMPNAME_MACE_6TO1);
                    break;
                }
                case -1: {
                    switch (format) {
                        case 1313820229: {
                            out2.writeInt(1313820229);
                            out2.write(COMPNAME_NONE);
                            break block5;
                        }
                        case 1094927666: {
                            out2.writeInt(1094927666);
                            out2.write(COMPNAME_ACE_2TO1);
                            break block5;
                        }
                        case 1094927672: {
                            out2.writeInt(1094927672);
                            out2.write(COMPNAME_ACE_8TO3);
                            break block5;
                        }
                        case 1296122675: {
                            out2.writeInt(1296122675);
                            out2.write(COMPNAME_MACE_3TO1);
                            break block5;
                        }
                        case 1296122678: {
                            out2.writeInt(1296122678);
                            out2.write(COMPNAME_MACE_6TO1);
                            break block5;
                        }
                    }
                    out2.writeInt(format);
                    out2.write(new byte[16]);
                    break;
                }
                default: {
                    return null;
                }
            }
            try {
                out2.writeInt(CYNH);
                out2.writeInt(12);
                out2.writeInt(loopStart);
                out2.writeInt(loopEnd);
                out2.writeInt(baseFrequency);
                out2.writeInt(SSND);
                out2.writeInt(8 + flength);
                out2.writeInt(0);
                out2.writeInt(0);
                out2.write(this.data, o + 64, flength);
                int i2 = 0;
                while (i2 < fpadding) {
                    out2.writeByte(0);
                    ++i2;
                }
                out2.close();
                out.close();
                return out.toByteArray();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (encoding == -1) {
            int numFrames = KSFLUtilities.getInt(this.data, o + 22);
            short aiffSampleRateExponent = KSFLUtilities.getShort(this.data, o + 26);
            long aiffSampleRateMantissa = KSFLUtilities.getLong(this.data, o + 28);
            short sampleSize = KSFLUtilities.getShort(this.data, o + 48);
            int sampleBytes = (sampleSize + 7) / 8;
            int flength = numBytes * numFrames * sampleBytes;
            int fpadding = 0;
            while ((flength + fpadding & 1) != 0) {
                ++fpadding;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream out2 = new DataOutputStream(out);
                out2.writeInt(FORM);
                out2.writeInt(98 + flength + fpadding);
                out2.writeInt(AIFC);
                out2.writeInt(FVER);
                out2.writeInt(4);
                out2.writeInt(-1568648896);
                out2.writeInt(COMM);
                out2.writeInt(38);
                out2.writeShort(numBytes);
                out2.writeInt(numFrames);
                out2.writeShort(sampleSize);
                out2.writeShort(aiffSampleRateExponent);
                out2.writeLong(aiffSampleRateMantissa);
                out2.writeInt(1313820229);
                out2.write(COMPNAME_NONE);
                out2.writeInt(CYNH);
                out2.writeInt(12);
                out2.writeInt(loopStart);
                out2.writeInt(loopEnd);
                out2.writeInt(baseFrequency);
                out2.writeInt(SSND);
                out2.writeInt(8 + flength);
                out2.writeInt(0);
                out2.writeInt(0);
                out2.write(this.data, o + 64, flength);
                int i3 = 0;
                while (i3 < fpadding) {
                    out2.writeByte(0);
                    ++i3;
                }
                out2.close();
                out.close();
                return out.toByteArray();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (encoding == 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream out2 = new DataOutputStream(out);
            out2.writeInt(FORM);
            out2.writeInt(98 + numBytes + padding);
            out2.writeInt(AIFC);
            out2.writeInt(FVER);
            out2.writeInt(4);
            out2.writeInt(-1568648896);
            out2.writeInt(COMM);
            out2.writeInt(38);
            out2.writeShort(1);
            out2.writeInt(numBytes);
            out2.writeShort(8);
            switch (sampleRate) {
                case -1404829696: {
                    out2.writeShort(16398);
                    out2.writeLong(-6033697600769622016L);
                    break;
                }
                case 1458473891: {
                    out2.writeShort(16397);
                    out2.writeLong(-5918548746663787925L);
                    break;
                }
                case 1445068800: {
                    out2.writeShort(16397);
                    out2.writeLong(-6033697600769622016L);
                    break;
                }
                case 729236945: {
                    out2.writeShort(16396);
                    out2.writeLong(-5918548746663787925L);
                    break;
                }
                case 722534400: {
                    out2.writeShort(16396);
                    out2.writeLong(-6033697600769622016L);
                    break;
                }
                default: {
                    return null;
                }
            }
            try {
                out2.writeInt(1313820229);
                out2.write(COMPNAME_NONE);
                out2.writeInt(CYNH);
                out2.writeInt(12);
                out2.writeInt(loopStart);
                out2.writeInt(loopEnd);
                out2.writeInt(baseFrequency);
                out2.writeInt(SSND);
                out2.writeInt(8 + numBytes);
                out2.writeInt(0);
                out2.writeInt(0);
                byte[] newdata = KSFLUtilities.copy(this.data, o + 22, numBytes);
                int i4 = 0;
                while (i4 < newdata.length) {
                    int n = i4++;
                    newdata[n] = (byte)(newdata[n] ^ 0x80);
                }
                out2.write(newdata);
                i4 = 0;
                while (i4 < padding) {
                    out2.writeByte(0);
                    ++i4;
                }
                out2.close();
                out.close();
                return out.toByteArray();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }
}

