/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-22 20:09
 */
 
#include <string>
#include <stdio.h>
#include "LiteWindow.h"
#include "log.h"
#include "utils.h"

CLiteWindow::CLiteWindow()
{
}

CLiteWindow::~CLiteWindow()
{
}

gboolean CLiteWindow::delete_event(GtkWidget* widget, GdkEvent* event, gpointer data)
{
	gboolean result = TRUE;
	
	GtkWidget* dialog = gtk_message_dialog_new(NULL,
		GTK_DIALOG_MODAL,
		GTK_MESSAGE_QUESTION,
		GTK_BUTTONS_YES_NO,
		_("Are you sure to Exit?"));
		
	if(GTK_RESPONSE_YES == gtk_dialog_run(GTK_DIALOG(dialog)))
	{
		result = FALSE;
	}	
	
	gtk_widget_destroy(dialog);
	
	return result;
}

void CLiteWindow::destroy(GtkWidget* widget, gpointer data)
{
	gtk_main_quit();
}

void CLiteWindow::exit_button_clicked_event(GtkWidget* widget, gpointer data)
{
	CLiteWindow* window = (CLiteWindow*)data;
	
	GtkWidget* dialog = gtk_message_dialog_new(NULL,
		GTK_DIALOG_MODAL,
		GTK_MESSAGE_QUESTION,
		GTK_BUTTONS_YES_NO,
		_("Are you sure to Exit?"));
		
	if(GTK_RESPONSE_YES == gtk_dialog_run(GTK_DIALOG(dialog)))
	{
		gtk_widget_hide(GTK_WIDGET(window->_window));
		gtk_main_quit();
	}
	gtk_widget_destroy(dialog);	
}

void CLiteWindow::about_button_clicked_event(GtkWidget* widget, gpointer data)
{
		static const gchar *authors[] = {
			"Gao Xiancho <gxcoo@hotmail.com>",
			NULL
		};
		
		const gchar *documenters[] = {
		        "BitStorm Documentation Team",
			NULL
		};

		gtk_show_about_dialog(NULL,
			"name",		"BitStorm Lite",
			"version",	"0.2m",
			"copyright",	"\xC2\xA9 2005-2006 Gao Xianchao (gxcoo@hotmail.com)\n"
							"\xC2\xA9 2007 Gao Xianchao gnap_an linux_lyb ahlongxp\n",
			"comments",	_("http://sourceforge.net/projects/bbom/\n\n"
								"BitStorm is a p2p file-sharing freeware fully compatible with Bittorrent,"
								"which is one of the most popular p2p protocol designed for high-speed "
								"distribution of 100MB or GB sized files"),
			"authors",	authors,
			"documenters",	documenters,
			"translator-credits",	"translator-credits",
			"logo_icon_name",	"gnome-money",
			NULL);
}

void CLiteWindow::createWindow()
{
	//MainWindow
	_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	std::string title;
	if(_task->getTorrentFile()->IsUTF8Valid())
	{
		title = _task->getTorrentFile()->getNameUTF8() + " - BitStorm Lite";
	}
	else
	{
		title = _task->getTorrentFile()->getName() + " - BitStorm Lite";
	}
	
	gtk_window_set_title(GTK_WINDOW(_window), title.c_str()); 
	g_signal_connect(G_OBJECT(_window), "delete_event", G_CALLBACK(delete_event), NULL);
	g_signal_connect(G_OBJECT(_window), "destroy", G_CALLBACK(destroy), NULL);
	gtk_container_set_border_width(GTK_CONTAINER(_window), 10);	
	
	GtkWidget* vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(_window), vbox);	
	
	//TaskNameLabel
	GtkWidget* hbox = gtk_hbox_new(FALSE, 0);
	if(_task->getTorrentFile()->IsUTF8Valid())
	{
		_taskNameLabel = gtk_label_new(_task->getTorrentFile()->getNameUTF8().c_str()); 
	}
	else
	{
		_taskNameLabel = gtk_label_new(_task->getTorrentFile()->getName().c_str()); 
	}
	gtk_label_set_justify(GTK_LABEL(_taskNameLabel), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox), _taskNameLabel, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 3);	
	
	//TotalSize
	hbox = gtk_hbox_new(FALSE, 0);
	std::string totalSize =  byteCount2Str(_task->getStorage()->getSelectedCount());
	_totalSizeLabel = gtk_label_new(totalSize.c_str());
	gtk_label_set_justify(GTK_LABEL(_totalSizeLabel), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox), _totalSizeLabel, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 3);		
	
	//ProgressBar
	_progressBar = gtk_progress_bar_new();
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(_progressBar), gdouble(0));
	gtk_box_pack_start(GTK_BOX(vbox), _progressBar, FALSE, TRUE, 3);	

	//Time
	hbox = gtk_hbox_new(FALSE, 0);
	_timeLabel = gtk_label_new(_("time elapsed / estimated : "));
	gtk_label_set_justify(GTK_LABEL(_timeLabel), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox), _timeLabel, FALSE, TRUE, 0);
	_timeLabel = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(hbox), _timeLabel, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 3);			
	
	//DownloadTo
	hbox = gtk_hbox_new(FALSE, 0);
	std::string dest = _("downlaod to : ");
	if(_task->getTorrentFile()->IsUTF8Valid())
	{
		dest += _task->getDestPath() + _task->getTorrentFile()->getNameUTF8();
	}
	else
	{
		dest += _task->getDestPath() + _task->getTorrentFile()->getName();
	}
	_downloadToLabel = gtk_label_new(dest.c_str());
	gtk_label_set_justify(GTK_LABEL(_downloadToLabel), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox), _downloadToLabel, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 3);		
	
	//State
	GtkWidget* stateHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), stateHbox, FALSE, TRUE, 5);	
	
	
	GtkWidget* table = gtk_table_new(2, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(stateHbox), table, TRUE, TRUE, 0);	
	
	//DownloadRate
	_downloadRateLabel = gtk_label_new("download rate : ");
	gtk_label_set_markup(GTK_LABEL(_downloadRateLabel), _("<span><b>download rate : </b></span>"));
	gtk_label_set_justify(GTK_LABEL(_downloadRateLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _downloadRateLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 0, 1);	
	
	_downloadRateLabel = gtk_label_new("");
	gtk_label_set_justify(GTK_LABEL(_downloadRateLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _downloadRateLabel, FALSE, TRUE, 0);	
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 0, 1);	
	
	//UploadRate
	_uploadRateLabel = gtk_label_new("upload rate : ");
	gtk_label_set_markup(GTK_LABEL(_uploadRateLabel), _("<span><b>upload rate : </b></span>"));
	gtk_label_set_justify(GTK_LABEL(_uploadRateLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _uploadRateLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 1, 2);	
	
	_uploadRateLabel = gtk_label_new("");
	gtk_label_set_justify(GTK_LABEL(_uploadRateLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _uploadRateLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 1, 2);	
	

	table = gtk_table_new(2, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(stateHbox), table, TRUE, TRUE, 5);		
		
	//Downloaded
	_downloadedLabel = gtk_label_new("downloaded : ");
	gtk_label_set_markup(GTK_LABEL(_downloadedLabel), _("<span><b>downloaded : </b></span>"));
	gtk_label_set_justify(GTK_LABEL(_downloadedLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _downloadedLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 0, 1);		
	
	_downloadedLabel = gtk_label_new("");
	gtk_label_set_justify(GTK_LABEL(_downloadedLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _downloadedLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 0, 1);		
	
	//uploaded
	_uploadedLabel = gtk_label_new("uploaded : ");
	gtk_label_set_markup(GTK_LABEL(_uploadedLabel), _("<span><b>uploaded : </b></span>"));
	gtk_label_set_justify(GTK_LABEL(_uploadedLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _uploadedLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 1, 2);
	
	_uploadedLabel = gtk_label_new("");
	gtk_label_set_justify(GTK_LABEL(_uploadedLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);	
	gtk_box_pack_start(GTK_BOX(hbox), _uploadedLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 1, 2);				
		
	table = gtk_table_new(2, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(stateHbox), table, TRUE, TRUE, 5);	

	//Peers
	_peersLabel = gtk_label_new("peers : ");
	gtk_label_set_markup(GTK_LABEL(_peersLabel), _("<span><b>peers :  </b></span>"));
	gtk_label_set_justify(GTK_LABEL(_peersLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _peersLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 0, 1);	
	
	_peersLabel = gtk_label_new("");
	gtk_label_set_justify(GTK_LABEL(_peersLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _peersLabel, FALSE, TRUE, 0);	
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 0, 1);	

	_shareLabel = gtk_label_new("share rate : ");
	gtk_label_set_markup(GTK_LABEL(_shareLabel), _("<span><b>share rate : </b></span>"));
	gtk_label_set_justify(GTK_LABEL(_shareLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _shareLabel, FALSE, TRUE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 1, 2);	
	
	_shareLabel = gtk_label_new("0.00");
	gtk_label_set_justify(GTK_LABEL(_shareLabel), GTK_JUSTIFY_LEFT);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), _shareLabel, FALSE, TRUE, 0);	
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 1, 2);		


	//About/Pause/Exit Button
	GtkWidget* bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_SPREAD);
	gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, TRUE, 15);	
	
	_aboutButton = gtk_button_new_from_stock(GTK_STOCK_ABOUT);
	gtk_container_add(GTK_CONTAINER(bbox), _aboutButton);	
	g_signal_connect(G_OBJECT(_aboutButton), "clicked", G_CALLBACK(about_button_clicked_event), this);
	
//	_pauseButton = gtk_button_new_from_stock(GTK_STOCK_MEDIA_PAUSE);
//	gtk_container_add(GTK_CONTAINER(bbox), _pauseButton);

	_exitButton = gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_container_add(GTK_CONTAINER(bbox), _exitButton);	
	g_signal_connect(G_OBJECT(_exitButton), "clicked", G_CALLBACK(exit_button_clicked_event), this);
	
	//Options
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 5);	
	
	GtkWidget* label = gtk_label_new("KB/s");	
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, TRUE, 0);		
	_maxUploadSpin = gtk_spin_button_new_with_range(0, 50*1024, 1);
	if(_task->getRateMeasure()->getUploadSpeed() == IRateMeasure::NoLimitedSpeed)
	{
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(_maxUploadSpin), 0);
	}
	else
	{
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(_maxUploadSpin), _task->getRateMeasure()->getUploadSpeed()/1024);
	}
	gtk_box_pack_end(GTK_BOX(hbox), _maxUploadSpin, FALSE, TRUE, 3);
	label = gtk_label_new(_("upload cap"));
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, TRUE, 3);
	
	label = gtk_label_new("KB/s");	
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, TRUE, 3);	
	_maxDownloadSpin = gtk_spin_button_new_with_range(0, 50*1024, 1);
	if(_task->getRateMeasure()->getDownloadSpeed() == IRateMeasure::NoLimitedSpeed)
	{
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(_maxDownloadSpin), 0);
	}
	else
	{
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(_maxDownloadSpin), _task->getRateMeasure()->getDownloadSpeed()/1024);
	}
	gtk_box_pack_end(GTK_BOX(hbox), _maxDownloadSpin, FALSE, TRUE, 3);
	label = gtk_label_new(_("download cap"));	
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, TRUE, 3);
	
	label = gtk_label_new("MB");	
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, TRUE, 3);	
	_cacheSizeSpin = gtk_spin_button_new_with_range(2, 1024, 1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(_cacheSizeSpin), _task->getCacheSize()/(1024*1024));
	gtk_box_pack_end(GTK_BOX(hbox), _cacheSizeSpin, FALSE, TRUE, 3);
	label = gtk_label_new(_("cache"));	
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, TRUE, 3);	
}

void CLiteWindow::run(IBTTask* task)
{
	_task = task;
	
	_startTick = GetTickCount();
	
	createWindow();

	gtk_timeout_add(1000, (GtkFunction)timerFunc, this);
		
	gtk_window_set_default_size(GTK_WINDOW(_window), 450, 250);
	gtk_window_set_position(GTK_WINDOW(_window), GTK_WIN_POS_CENTER);	
	gtk_widget_show_all(_window);
	
	gtk_main();	
}

void  CLiteWindow::updateGUI()
{
	//ProgressBar
	float p = _task->getStorage()->getFinishedPercent();
	char buf[128];
	sprintf(buf, "%01.2f%%", p*100);
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(_progressBar), buf);
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(_progressBar), gdouble(p));	
	
	//Time
	std::string tempStr = second2Str( (GetTickCount() - _startTick)/1000);
	if(!_task->getStorage()->finished())
	{
		tempStr += " / ";
		
		if(_task->getDownloadSpeed() == 0)
		{
			tempStr += "∞";
		}
		else
		{
			tempStr += second2Str(_task->getStorage()->getLeftCount()/_task->getDownloadSpeed());
		}
	}
	gtk_label_set_text(GTK_LABEL(_timeLabel), tempStr.c_str());
	
	//Downloaded
	tempStr = byteCount2Str(_task->getDownlaodCount());
	gtk_label_set_text(GTK_LABEL(_downloadedLabel), tempStr.c_str());
	
	//Uploaded
	tempStr = byteCount2Str(_task->getUploadCount());
	gtk_label_set_text(GTK_LABEL(_uploadedLabel), tempStr.c_str());
	
	//Peers
	sprintf(buf, "%u/%u/%u",
		_task->getPeerManager()->getConnectedPeerCount(),
		_task->getTrackerManager()->getSeedCount(),
		_task->getTrackerManager()->getPeerCount());
	gtk_label_set_text(GTK_LABEL(_peersLabel), buf);
	
	//ShareRate
	if(_task->getDownlaodCount() != 0)
	{
		float shareRate = ((float)(_task->getUploadCount()))/(_task->getDownlaodCount());
		sprintf(buf, "%01.2f", shareRate);
	}
	else if(_task->getUploadCount() != 0)
	{
		sprintf(buf, "%s", "∞");
	}
	else
	{
		sprintf(buf, "%s", "0.00");
	}
	gtk_label_set_text(GTK_LABEL(_shareLabel), buf);
	
	//DownloadSpeed
	tempStr = byteCount2Str(_task->getDownloadSpeed()) + "/s";
	gtk_label_set_text(GTK_LABEL(_downloadRateLabel), tempStr.c_str());
	
	//UploadSpeed
	tempStr = byteCount2Str(_task->getUploadSpeed()) + "/s";
	gtk_label_set_text(GTK_LABEL(_uploadRateLabel), tempStr.c_str());	
	
	//MaxUpload
	int maxUpload = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(_maxUploadSpin));
	if(maxUpload == 0)
	{
		_task->getRateMeasure()->setUploadSpeed(IRateMeasure::NoLimitedSpeed);
	}
	else
	{
		_task->getRateMeasure()->setUploadSpeed(maxUpload*1024);
	}
	
	//MaxDownload
	int maxDownload = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(_maxDownloadSpin));
	if(maxDownload == 0)
	{
		_task->getRateMeasure()->setDownloadSpeed(IRateMeasure::NoLimitedSpeed);
	}
	else
	{
		_task->getRateMeasure()->setDownloadSpeed(maxDownload*1024);
	}
	
	//CacheSize
	int cacheSize = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(_cacheSizeSpin));
	_task->setCacheSize(cacheSize*1024*1024);
}

gboolean CLiteWindow::timerFunc(gpointer data)
{
	CLiteWindow* window = (CLiteWindow*)data;
	window->updateGUI();
	
	return TRUE;
}

std::string CLiteWindow::getUserInputTorrentFilePath()
{
	GtkWidget *dialog;
    GtkFileFilter *filter;
	char *filename = "";
	
	dialog = gtk_file_chooser_dialog_new (_("Please select a torrent file"),
					      NULL,
					      GTK_FILE_CHOOSER_ACTION_OPEN,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					      NULL);

    filter = gtk_file_filter_new ();
    gtk_file_filter_set_name (filter, _("Torrent files"));
    gtk_file_filter_add_mime_type (filter, "application/x-bittorrent");
    gtk_file_filter_add_pattern (filter, "*.torrent");
    gtk_file_filter_add_pattern (filter, "*.tor");
    gtk_file_chooser_add_filter (GTK_FILE_CHOOSER(dialog), filter);

    filter = gtk_file_filter_new ();
    gtk_file_filter_set_name (filter, _("All files"));
    gtk_file_filter_add_pattern (filter, "*");
    gtk_file_chooser_add_filter (GTK_FILE_CHOOSER(dialog), filter);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
	    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	}
	
	gtk_widget_destroy (dialog);
  
  	return filename;
}

std::string CLiteWindow::getUserInputDestPath(const char* fileName)
{
	GtkWidget *dialog;
	char *destDir = "";
	
	dialog = gtk_file_chooser_dialog_new (_("Please select a directory to save file"),
					      NULL,
					      GTK_FILE_CHOOSER_ACTION_SAVE,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_SAVE, GTK_FILE_CHOOSER_ACTION_SAVE,
					      NULL);
					      
	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER (dialog), fileName);
	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_FILE_CHOOSER_ACTION_SAVE)
	{
	    destDir = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (dialog));
	}
	
	gtk_widget_destroy (dialog);
	
	std::string result = destDir;
	if(result[result.size() -1] != '/')
	{
		result.append("/");
	}
  
  	return result;
}

void CLiteWindow::showMessage(const char* msg)
{
	GtkWidget* dialog = gtk_message_dialog_new(NULL,
		GTK_DIALOG_MODAL,
		GTK_MESSAGE_WARNING,
		GTK_BUTTONS_OK,
		msg);
	
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
}
