

import types
from threading import Thread
import time


class CustomThread( Thread):

  def __init__( self, function, attrs, additional_attrs=None, kw_attrs=None):
    """function is the function to run, attrs a list of attrs for which to run the
    consecutively the function, additional_attrs and kw_attrs are attrs that are added to
    each call of function"""
    Thread.__init__( self)
    self.function = function
    self.attrs = attrs
    self.additional_attrs = additional_attrs
    self.kw_attrs = kw_attrs


  def run( self):
    for a in self.attrs:
      aa = self.additional_attrs or []
      ka = self.kw_attrs or {}
      self.function( a, *aa, **ka)



def run_in_threads( function, attrs, processes=1, group_by=1, additional_attrs=None, kw_attrs=None):
    """function is the function to run, attrs a list of attrs for which to run the
    consecutively the function, additional_attrs and kw_attrs are attrs that are added to
    each call of function,

    *group_by* means how many attributes should be processed in one thread, this is useful when a
    single run of the function is too fast and the overhead of starting a thread is too high,
    it is good to set this value so that a runtime of one group is higher than at least 100ms,

    *processes* is a number of parallel threads that should run."""

    #if processes == 1:
    #  # in case of one process it is not economic to spawn any threads
    #  for num in nums:
    #    process_one_rfc( num, hit_dictionary, id_remap, logging=logger( verbose=options.verbose, quiet=options.quiet))

    assert type( group_by) == types.IntType
    assert type( processes) == types.IntType
    
    threads = []
    while attrs or threads:
      if len( threads) < processes and attrs:
        if len( attrs) > group_by:
          as = attrs[0:group_by]
          del attrs[0:group_by]
        else:
          as = attrs
          attrs = []

        t = CustomThread( function, as, additional_attrs=additional_attrs, kw_attrs=kw_attrs)
        threads.append( t)
        t.start()
      else:
        time.sleep( 0.05)

      threads = [t for t in threads if t.isAlive()]



if __name__ == "__main__":

  import operator

  def fact( n):
    if n == 0:
      ret = 1
    elif n == 1:
      ret = 1
    else:
      ret = reduce( operator.mul, range( 2, n+1))

    print n
    time.sleep( 0.02)
    return ret
      

  ns = range( 1, 500)

  run_in_threads( fact, ns, processes=1, group_by=10)
