//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio AB
// 

using GConf;
using Gtk;
using System;
using GtkSharp;
using Gecko;
using Mono.Posix;
using System.Collections;
using System.Reflection;
using System.IO;
using System.Net;
using System.Text;

namespace Imendio.Blam {
    public class ItemView {
        private WebControl mMoz;
	private ChannelCollection mCollection;
	private Imendio.Blam.Item currentItem;
	private bool textReady;
	private bool emittedReady;
	 
	public bool PageLoaded;

	public delegate void ItemLoadedHandler();
	public event ItemLoadedHandler ItemLoaded;

        public event StringUpdatedHandler OnUrl;

	public Imendio.Blam.Item CurrentItem {
	    get {
		return currentItem;
	    }
	     
	    set {
		currentItem = value;
		Load ();
	    }
	}

        public WebControl Widget {
            get {
                return mMoz;
            }
        }

	public ItemView (ChannelCollection collection)
        {
            this.mCollection = collection;

            this.mMoz = new WebControl ();
            //Application.BaseDir + "/mozilla",
              //                          "blam");
	   
            Conf.AddNotify (Preference.FONT_PATH, 
                            new NotifyEventHandler (FontNotifyHandler));
          //  Utils.GeckoInit ();
            SetFonts ();

            ProxyUpdatedCb ();
            Proxy.Updated += ProxyUpdatedCb;

            mMoz.OpenUri += new OpenUriHandler (LinkClickedCb);
            //mMoz.TitleChange += new EventHandler (TitleChangedCb);
            //mMoz.LocChange += new EventHandler (TitleChangedCb);
            mMoz.DestroyBrowser += new EventHandler (TitleChangedCb);
            mMoz.NetStart += new EventHandler (NetStartCb);
            mMoz.NetStop += new EventHandler (NetStopCb);
            mMoz.LinkMsg += new EventHandler (LinkMsgCb);
            //UrlRequested += new UrlRequestedHandler(UrlRequestedCb);
            //LinkClicked += new LinkClickedHandler(LinkClickedCb);
            mMoz.Show ();
	    PageLoaded = false;
        }
        
        private void TitleChangedCb (object obj, EventArgs args)
        {
            System.Console.WriteLine ("Title Changed: {0}", mMoz.Title);
        }

        private void LinkMsgCb (object obj, EventArgs args)
        {
            if (OnUrl != null) {
                OnUrl (mMoz.LinkMessage);
            }
        }

        private void NetStartCb (object obj, EventArgs args)
        {
            System.Console.WriteLine ("Net start");
        }

        private void NetStopCb (object obj, EventArgs args)
        {
            System.Console.WriteLine ("Net stop");
        }
        
	private void Load() 
        {
	    textReady = emittedReady = false;

            mMoz.OpenStream ("file://" + Defines.APP_DATADIR + "/images/",
                             "text/html");
            mMoz.AppendData (HtmlHeader());

	    if (currentItem.Text.Length > 0) {
                mMoz.AppendData ("<table cellpadding=\"2\"><tr><td>");
		mMoz.AppendData (EncodeUnicode(FixMarkup(currentItem.Text)));
                mMoz.AppendData ("</td></tr></table>");
	    }

            mMoz.AppendData (HtmlFooter());
            mMoz.CloseStream ();
	    //PageLoaded = true;
            //textReady = true;
            //if (!emittedReady && asyncReaders.Count <= 0) {
            //EmitItemLoaded();
        //}
	}

	private void LinkClickedCb(object obj, OpenUriArgs args)
	{
	    try {
                Gnome.Url.Show(args.AURI);
	    } 
	    catch (Exception e) {
                Console.WriteLine("Couldn't show URL: " + args.AURI);
            }

            args.RetVal = true;
        }

	private static string EncodeUnicode(string str)
	{
	    StringBuilder output = new StringBuilder();

	    foreach (char c in str) {
		if ((int)c > 128) {
		    output.Append("&#");
		    output.Append(((int)c).ToString());
		    output.Append(";");
		} else {
		    output.Append(c);
		}
	    }

	    return output.ToString();
	}

	private void EmitItemLoaded()
	{
	    emittedReady = true;

	    if (ItemLoaded != null) {
		ItemLoaded();
	    }
	}

	private string HtmlBox (string leftContent, string rightContent)
	{
	    string html = "<table bgcolor=\"#333333\" border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">" +
		"  <tr>" +
		"    <td bgcolor=\"#ffffff\">" +
		"      <img src=\"blam-box-top-left.png\">" +
		"    </td>" +
		"    <td colspan=2 width=\"100%\">" +
		"      <img src=\"blam-box-pad.png\">" +
		"    </td>" +
		"    <td bgcolor=\"#ffffff\">" +
		"      <img src=\"blam-box-top-right.png\">" +
		"    </td>" +
		"  </tr>" +
		"  <tr>" +
		"    <td>" +
		"      <img src=\"blam-box-pad.png\">" +
		"    </td>" +
		"    <td width=\"75%\" valign=\"top\">" +
		+ leftContent +
		"    </td>" +
		"    <td align=\"right\" valign=\"top\">" +
		+ rightContent + 
		"    </td>" +
		"    <td>" +
		"      <img src=\"blam-box-pad.png\">" +
		"    </td>" +
		"  </tr>" +
		"  <tr>" +
		"    <td bgcolor=\"#ffffff\">" +
		"      <img src=\"blam-box-bottom-left.png\">" +
		"    </td>" +
		"    <td colspan=2 width=\"100%\">" +
		"      <img src=\"blam-box-pad.png\">" +
		"    </td>" +
		"    <td bgcolor=\"#ffffff\">" +
		"      <img src=\"blam-box-bottom-right.png\">" +
		"    </td>" +
		"  </tr>" +
		"</table>";
	    
	    return html;
	}

	private string HtmlHeader ()
	{
	    string date = "";
	    string title;
            StringBuilder html;

            html = new StringBuilder ();
	    // Don't print the date if it's not set (avoid showing 0001 Jan 01)
	    // in the item header.
            
	    html.Append ("<html>" + 
                         "  <head>" +
                         "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />" +
                         "    <title>" + currentItem.Title + "</title>"+
                         "  </head>" +
                         "  <body>");
            
            if (!currentItem.PubDate.Equals (DateTime.MinValue)) {
		date = "<font color=\"#ffffff\" size=\"+1\">" +
		    currentItem.PubDate.ToString ("d MMM yyyy") +
		    "</font>";
	    } else {
                date = "&nbsp;";
            }
	    
	    title = "<font color=\"#ffffff\" size=\"+1\">" + 
		EncodeUnicode (currentItem.Title) +
		"</font>";

            html.Append (HtmlBox (title, date));
            return html.ToString ();
	}

	private string HtmlFooter()
	{
	    StringBuilder str = new StringBuilder();
	    string link = "";
	    string author;

	    if (currentItem.Link != null && currentItem.Link.Equals ("") != true) {
		link = String.Format("<a href=\"{0}\">" +
				     "<font color=\"#ffff00\">" +
				     Catalog.GetString ("Show in browser") +
				     "</font></a>",
				     currentItem.Link);
	    }

	    if (currentItem.Author != null && currentItem.Author != "") {
		string authorStr = String.Format (Catalog.GetString ("by {0}"), currentItem.Author);
		
		author = "<font color=\"#aaaaaa\">" + authorStr + "</font>";
	    } else {
		author = "&nbsp;";
	    }

	    str.Append("<br><br>");
	    str.Append(HtmlBox(link, author));
            str.Append("</body></html>");

	    return str.ToString();
	}

	private string FixMarkup(string str)
	{
	    string tStr = str.Trim().Replace("</p>", "").Replace("</P>", "");

	    if (!tStr.StartsWith("<p>") && !tStr.StartsWith("<P>")) {
		tStr = "<br/><br/>" + tStr;
	    }

	    return tStr.Replace("<p>", "<br/><br/>").Replace("<P>", "<br/><br/>");
	}

        private void SetFonts ()
        {
            string varFont = Conf.Get (Preference.VARIABLE_FONT, "Sans 12");
            string fixedFont = Conf.Get (Preference.FIXED_FONT, "Mono 12");

            Utils.GeckoSetFont (1, varFont);
            Utils.GeckoSetFont (2, fixedFont);
        }

        private void FontNotifyHandler (object sender, NotifyEventArgs args)
        {
            if (args.Key == Conf.GetFullKey (Preference.VARIABLE_FONT) ||
                args.Key == Conf.GetFullKey (Preference.FIXED_FONT)) {
                SetFonts ();
            }
        }

        private void ProxyUpdatedCb ()
        {
            Utils.GeckoSetProxy (Proxy.UseProxy, Proxy.ProxyHost, 
                                 Proxy.ProxyPort);
        }
    } 
}
