/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  1 22:36:34 EDT 2006 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twidsq_c -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -n 2 -dif -name q1fv_2 -include q1f.h */

/*
 * This function contains 6 FP additions, 4 FP multiplications,
 * (or, 6 additions, 4 multiplications, 0 fused multiply/add),
 * 8 stack variables, and 8 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twidsq_c.ml,v 1.8 2006-02-12 23:34:12 athena Exp $
 */

#include "q1f.h"

static const R *q1fv_2(R *ri, R *ii, const R *W, stride is, stride vs, INT m, INT dist)
{
     INT i;
     R *x;
     x = ri;
     for (i = 0; i < m; i = i + VL, x = x + (VL * dist), W = W + (TWVL * 2), MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(vs)) {
	  V T1, T2, T4, T5, T3, T6;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  T2 = LD(&(x[WS(is, 1)]), dist, &(x[WS(is, 1)]));
	  T4 = LD(&(x[WS(vs, 1)]), dist, &(x[WS(vs, 1)]));
	  T5 = LD(&(x[WS(vs, 1) + WS(is, 1)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  ST(&(x[0]), VADD(T1, T2), dist, &(x[0]));
	  T3 = BYTWJ(&(W[0]), VSUB(T1, T2));
	  ST(&(x[WS(is, 1)]), VADD(T4, T5), dist, &(x[WS(is, 1)]));
	  T6 = BYTWJ(&(W[0]), VSUB(T4, T5));
	  ST(&(x[WS(vs, 1)]), T3, dist, &(x[WS(vs, 1)]));
	  ST(&(x[WS(vs, 1) + WS(is, 1)]), T6, dist, &(x[WS(vs, 1) + WS(is, 1)]));
     }
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 2, "q1fv_2", twinstr, &GENUS, {6, 4, 0, 0}, 0, 0, 0 };

void X(codelet_q1fv_2) (planner *p) {
     X(kdft_difsq_register) (p, q1fv_2, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twidsq_c -simd -compact -variables 4 -pipeline-latency 8 -n 2 -dif -name q1fv_2 -include q1f.h */

/*
 * This function contains 6 FP additions, 4 FP multiplications,
 * (or, 6 additions, 4 multiplications, 0 fused multiply/add),
 * 8 stack variables, and 8 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twidsq_c.ml,v 1.8 2006-02-12 23:34:12 athena Exp $
 */

#include "q1f.h"

static const R *q1fv_2(R *ri, R *ii, const R *W, stride is, stride vs, INT m, INT dist)
{
     INT i;
     R *x;
     x = ri;
     for (i = 0; i < m; i = i + VL, x = x + (VL * dist), W = W + (TWVL * 2), MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(vs)) {
	  V T1, T2, T3, T4, T5, T6;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  T2 = LD(&(x[WS(is, 1)]), dist, &(x[WS(is, 1)]));
	  T3 = BYTWJ(&(W[0]), VSUB(T1, T2));
	  T4 = LD(&(x[WS(vs, 1)]), dist, &(x[WS(vs, 1)]));
	  T5 = LD(&(x[WS(vs, 1) + WS(is, 1)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  T6 = BYTWJ(&(W[0]), VSUB(T4, T5));
	  ST(&(x[WS(vs, 1)]), T3, dist, &(x[WS(vs, 1)]));
	  ST(&(x[WS(vs, 1) + WS(is, 1)]), T6, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  ST(&(x[0]), VADD(T1, T2), dist, &(x[0]));
	  ST(&(x[WS(is, 1)]), VADD(T4, T5), dist, &(x[WS(is, 1)]));
     }
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 2, "q1fv_2", twinstr, &GENUS, {6, 4, 0, 0}, 0, 0, 0 };

void X(codelet_q1fv_2) (planner *p) {
     X(kdft_difsq_register) (p, q1fv_2, &desc);
}
#endif				/* HAVE_FMA */
