// (C) 2006 M. Derezynski

#include <string>

#include "resolver.h"
#include "modfile.h"

#include <src/audio_typefind.hh>

TagLib::File * MODFileTypeResolver::createFile (const char                        *filename,
                                                bool                               read_properties,
                                                TagLib::AudioProperties::ReadStyle properties_style) const 
{
    std::string type;

    if (!Bmp::Audio::typefind (filename, type))
      return 0;

    if (type == "audio/x-mod")
    {
      TagLib::MOD::File * p = new TagLib::MOD::File(filename, read_properties, properties_style);

      if (p->isValid())
          return p;
      else
          delete p;
    }

    return 0;
}
