//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <glibmm.h>

#include <src/util_string.hh>
#include <src/util_file.hh>
#include <src/uri++.hh>

#include <src/database.hh>
#include <src/vfs.hh>

#include <src/x_library.hh>
#include <src/x_play.hh>

namespace Bmp
{
  namespace VFS
  {
      class PluginContainerFolder
          : public Bmp::VFS::PluginContainerBase
      {
        public:

          virtual bool
          can_process (Glib::ustring const& uri)
          {
            Bmp::URI u (uri);
            if (u.get_protocol () != Bmp::URI::PROTOCOL_FILE) return false;
            try
              {
                u.unescape ();
                Glib::ustring uri ((u));
                std::string path = Glib::filename_from_uri (uri);
                if (Glib::file_test (path, Glib::FILE_TEST_IS_DIR))
                  {
                    return true;
                  }
              }
            catch (...) {}
            return false;
          }

          virtual bool 
          handle_read	(Handle & handle, VUri & list)
          {
            Bmp::URI u (handle.get_uri());
            u.unescape ();
            Glib::ustring uri ((u));
            try
              {
                Util::FileList file_list;
                Util::collect_path (Glib::filename_from_uri (uri), file_list);

                for (Util::FileList::const_iterator iter = file_list.begin (), end = file_list.end (); iter != end; ++iter)
                { 
                  if (play->is_audio_file ((*iter)))
                    {
                      list.push_back (Glib::filename_to_uri (*iter));
                    }
                }
                return true;
              }
            catch (...)
              {
                return false;
              }
          }

          virtual bool
          can_write ()
          {
            return false;
          }

          virtual bool
          handle_write  (Handle &	handle, VUri const& uri_list)
          {
            return false;
          }

          virtual Bmp::VFS::ExportData
          get_export_data ()
          {
            static Bmp::VFS::ExportData export_data ("Folder Container Plugin", ""); 
            return export_data;
          }
      };
  }
}
  
extern "C" Bmp::VFS::PluginContainerBase* plugin_create ()
{
  return new Bmp::VFS::PluginContainerFolder;
}

extern "C" void plugin_delete (Bmp::VFS::PluginContainerFolder* p)
{
  delete p;
}
