//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <gtk/gtk.h>
#include <gtkmm.h>
#include <glibmm/i18n.h>

#include <cstdlib>
#include <cstring>
#include <iostream>
#include <sstream>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#include <boost/format.hpp>
#include <mcs/mcs.h>

#include "debug.hh"
#include "util_file.hh"
#include "util.hh"
#include "uri++.hh"
#include "amazon.hh"

#include "paths.hh"
#include "main.hh"

#include "x_library.hh"
#include "x_vfs.hh"

#include "library-ui-relocate-album.hh"

namespace
{
  void
  cbe_set_sensitive (Gtk::CheckButton *cb, Gtk::ComboBoxEntry *cbe)
  {
      cbe->set_sensitive (cb->get_active());
  }

  void
  fcb_set_sensitive (Gtk::CheckButton *cb, Gtk::FileChooserButton *fcb)
  {
      fcb->set_sensitive (cb->get_active());
  }

  bool
  folder_writeable (std::string const& path)
  {
    return (!access (path.c_str(), W_OK | X_OK)); 
  }
}

namespace Bmp
{
      LibraryUiRelocateAlbum::~LibraryUiRelocateAlbum ()
      {
        mcs->key_set<std::string>("bmp","file-chooser-path-relocate-album", m_widget_fcb_move->get_current_folder ());
      }

      LibraryUiRelocateAlbum::LibraryUiRelocateAlbum (BaseObjectType                       * obj,
                                                      Glib::RefPtr<Gnome::Glade::Xml> const& xml)
            : Gtk::Dialog       (obj),
              m_ref_xml         (xml),
              m_album_unknown   (Gdk::Pixbuf::create_from_file (BMP_IMAGE_DIR G_DIR_SEPARATOR_S BMP_COVER_IMAGE_DEFAULT))
      {
          m_ref_xml->get_widget ("coverart",
                                m_widget_image_coverart);

          m_ref_xml->get_widget ("e_album",
                                m_widget_entry_album);

          m_ref_xml->get_widget ("e_artist",
                                m_widget_entry_artist);

          m_ref_xml->get_widget ("cb_append_albumname",
                                m_widget_cb_append_albumname);

          m_ref_xml->get_widget ("fcb_move",
                                m_widget_fcb_move);

          m_ref_xml->get_widget ("hbox_warning",
                                m_widget_hbox_warning);

          m_ref_xml->get_widget ("okbutton2",
                                m_widget_ok);

          m_widget_fcb_move->signal_current_folder_changed ().connect
            (sigc::mem_fun (this, &LibraryUiRelocateAlbum::fcb_current_folder_changed));
          m_widget_fcb_move->set_current_folder (mcs->key_get<std::string>("bmp","file-chooser-path-relocate-album"));
      }

      void
      LibraryUiRelocateAlbum::fcb_current_folder_changed ()
      {
          GSList *filenames = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (m_widget_fcb_move->gobj())); 
          bool writable = folder_writeable ((char*)filenames->data);
          g_slist_free (filenames);
  
          if (writable)
              m_widget_hbox_warning->hide ();
          else
              m_widget_hbox_warning->show_all ();

          m_widget_ok->set_sensitive (writable);
      }

      LibraryUiRelocateAlbum* LibraryUiRelocateAlbum::create ()
      {
        const std::string path (BMP_GLADE_DIR G_DIR_SEPARATOR_S "library-ui-relocate-album.glade");
        Glib::RefPtr<Gnome::Glade::Xml> xml = Gnome::Glade::Xml::create (path);
        LibraryUiRelocateAlbum *p = 0;
        xml->get_widget_derived ("dialog_relocate_album", p);
        return p;
      }

      int
      LibraryUiRelocateAlbum::run (Bmp::Library::Album const& album) 
      {
          using namespace Glib;
          using namespace Gtk;
          using namespace Bmp::DB;
          using namespace Bmp::Library;
          using namespace std;

          m_widget_entry_artist->set_text (album.artist.get());
          m_widget_entry_album->set_text (album.album.get());

          try {
              if (!album.asin) throw 0;
              RefPtr<Gdk::Pixbuf> cover;
              Amazon::fetch( album.asin.get(), cover ); 
              m_widget_image_coverart->set (cover->scale_simple (128, 128, Gdk::INTERP_HYPER));
            }
          catch (...)
            {
              m_widget_image_coverart->set (m_album_unknown);
            }
          return Gtk::Dialog::run ();
      }
}
