#ifndef BMP_URI_HH
#define BMP_URI_HH

#include <string>
#include <glibmm.h>

namespace Bmp
{
    class URI
    {
      public:

#include "exception.hh"

        EXCEPTION(ParseError)

        typedef std::pair   < Glib::ustring,  Glib::ustring >	QElement;
        typedef std::map    < Glib::ustring,  QElement >	Query;
        typedef std::pair   < Glib::ustring,  QElement >	QueryPair;

        enum Protocol
        {
          PROTOCOL_UNKNOWN = -1,
          PROTOCOL_FILE,
          PROTOCOL_CDDA,
          PROTOCOL_HTTP,
          PROTOCOL_FTP,
          PROTOCOL_QUERY,
          PROTOCOL_TRACK,
          PROTOCOL_MMS, 
          PROTOCOL_MMSU,
          PROTOCOL_MMST,
          PROTOCOL_LASTFM
        };

        URI   (Glib::ustring const &uri, bool escape = false);
        URI   ();
        ~URI  () {};

        Protocol
        get_protocol ();

        static std::string
        get_protocol_scheme (Protocol p);

        void
        escape ();

        void
        unescape ();

        std::string
        fullpath ();

        void
        parse_query (Query& q);

        operator Glib::ustring ();

        Glib::ustring	scheme;
        Glib::ustring	userinfo;
        Glib::ustring	hostname;
        Glib::ustring	path;
        Glib::ustring	query;
        Glib::ustring	fragment;
        int		        port;

      private:

        bool
        fragmentize (Glib::ustring const& uri);

    };
}

#endif //!BMP_URI_HH
